/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.DefaultProjectFactory;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaSdkVersion;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.ClassFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwnerEx;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsParsingUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ModuleStubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiBinaryFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.StubbedSpine;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiClassHolderFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeLoader;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingFilter;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.cls.ClsFormatException;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ClsFileImpl
extends PsiBinaryFileImpl
implements Queryable,
PsiClassOwnerEx,
PsiCompiledFile,
PsiJavaFile,
PsiFileEx,
PsiFileWithStubSupport {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsFileImpl");
    private static final Key<Document> CLS_DOCUMENT_LINK_KEY = Key.create("cls.document.link");
    private final Object myMirrorLock;
    private final Object myStubLock;
    private final boolean myIsForDecompiling;
    private volatile SoftReference<StubTree> myStub;
    private volatile Reference<TreeElement> myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private static final InnerClassSourceStrategy<FileContentPair> STRATEGY = new InnerClassSourceStrategy<FileContentPair>(){

        @Override
        @Nullable
        public FileContentPair findInnerClass(String innerName, FileContentPair outerClass2) {
            String baseName = ((VirtualFile)outerClass2.first).getNameWithoutExtension();
            VirtualFile dir = ((VirtualFile)outerClass2.first).getParent();
            assert (dir != null) : outerClass2;
            VirtualFile innerClass = dir.findChild(baseName + '$' + innerName + ".class");
            if (innerClass != null) {
                try {
                    byte[] bytes = innerClass.contentsToByteArray(false);
                    return new FileContentPair(innerClass, bytes);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public void accept(FileContentPair innerClass, StubBuildingVisitor<FileContentPair> visitor2) {
            try {
                new ClassReader((byte[])innerClass.second).accept(visitor2, EMPTY_ATTRIBUTES, 4);
            }
            catch (Exception e) {
                VirtualFile file2 = (VirtualFile)innerClass.first;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(file2), e);
                }
                LOG.info(file2 + ": " + e.getMessage());
            }
        }
    };
    public static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];

    public ClsFileImpl(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(0);
        }
        this(viewProvider, false);
    }

    private ClsFileImpl(@NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        if (viewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(1);
        }
        super((PsiManagerImpl)viewProvider.getManager(), viewProvider);
        this.myMirrorLock = new Object();
        this.myStubLock = new Object();
        this.myIsForDecompiling = forDecompiling;
        JavaElementType.CLASS.getIndex();
    }

    @Override
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (this.myIsForDecompiling || this.getVirtualFile().isValid());
    }

    boolean isForDecompiling() {
        return this.myIsForDecompiling;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            ClsFileImpl.$$$reportNull$$$0(2);
        }
        return javaLanguage;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        PsiJavaModule module2 = this.getModuleDeclaration();
        if (module2 != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = module2;
        } else {
            psiElementArray = this.getClasses();
        }
        if (psiElementArray == null) {
            ClsFileImpl.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getStub().getClasses();
        if (psiClassArray == null) {
            ClsFileImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ClsPackageStatementImpl statement2 = this.myPackageStatement;
        if (statement2 == null) {
            String packageName;
            statement2 = ClsPackageStatementImpl.NULL_PACKAGE;
            PsiClassHolderFileStub<?> stub = this.getStub();
            if (!(stub instanceof PsiJavaFileStub && stub.findChildStubByType(JavaStubElementTypes.MODULE) != null || (packageName = ClsFileImpl.findPackageName(stub)) == null)) {
                statement2 = new ClsPackageStatementImpl(this, packageName);
            }
            this.myPackageStatement = statement2;
        }
        return statement2 != ClsPackageStatementImpl.NULL_PACKAGE ? statement2 : null;
    }

    private static String findPackageName(PsiClassHolderFileStub<?> stub) {
        String packageName = null;
        if (stub instanceof PsiJavaFileStub) {
            packageName = ((PsiJavaFileStub)stub).getPackageName();
        } else {
            int index2;
            String className2;
            PsiClass[] psiClasses = stub.getClasses();
            if (psiClasses.length > 0 && (className2 = psiClasses[0].getQualifiedName()) != null && (index2 = className2.lastIndexOf(46)) >= 0) {
                packageName = className2.substring(0, index2);
            }
        }
        return !StringUtil.isEmpty(packageName) ? packageName : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement2 = this.getPackageStatement();
        String string = statement2 == null ? "" : statement2.getPackageName();
        if (string == null) {
            ClsFileImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    @Override
    public PsiImportList getImportList() {
        return null;
    }

    @Override
    public boolean importClass(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            ClsFileImpl.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(7);
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(8);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(9);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(10);
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass2) {
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        PsiClassHolderFileStub<?> stub = this.getStub();
        if (stub instanceof PsiJavaFileStub && (level = ((PsiJavaFileStub)stub).getLanguageLevel()) != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                ClsFileImpl.$$$reportNull$$$0(11);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            ClsFileImpl.$$$reportNull$$$0(12);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        PsiClassHolderFileStub<?> stub = this.getStub();
        return stub instanceof PsiJavaFileStub ? ((PsiJavaFileStub)stub).getModule() : null;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            ClsFileImpl.$$$reportNull$$$0(13);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Deprecated
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsFileImpl.$$$reportNull$$$0(14);
        }
        this.appendMirrorText(buffer);
    }

    private void appendMirrorText(@NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsFileImpl.$$$reportNull$$$0(15);
        }
        buffer.append("\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n");
        PsiJavaModule module2 = this.getModuleDeclaration();
        if (module2 != null) {
            ClsElementImpl.appendText(module2, 0, buffer);
        } else {
            ClsElementImpl.appendText(this.getPackageStatement(), 0, buffer, "\n\n");
            PsiClass[] classes2 = this.getClasses();
            if (classes2.length > 0) {
                ClsElementImpl.appendText(classes2[0], 0, buffer);
            }
        }
    }

    @Deprecated
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsFileImpl.$$$reportNull$$$0(16);
        }
        this.setFileMirror(element);
    }

    private void setFileMirror(@NotNull TreeElement element) {
        Object mirrorElement;
        if (element == null) {
            ClsFileImpl.$$$reportNull$$$0(17);
        }
        if (!((mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull(element)) instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        PsiJavaModule module2 = this.getModuleDeclaration();
        if (module2 != null) {
            ClsElementImpl.setMirror(module2, mirrorFile.getModuleDeclaration());
        } else {
            ClsElementImpl.setMirrorIfPresent(this.getPackageStatement(), mirrorFile.getPackageStatement());
            ClsElementImpl.setMirrors((PsiElement[])this.getClasses(), (PsiElement[])mirrorFile.getClasses());
        }
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy navigationPolicy : ClsCustomNavigationPolicy.EP_NAME.getExtensionList()) {
            PsiElement psiElement;
            try {
                PsiElement navigationElement = navigationPolicy instanceof ClsCustomNavigationPolicyEx ? ((ClsCustomNavigationPolicyEx)navigationPolicy).getFileNavigationElement(this) : navigationPolicy.getNavigationElement(this);
                if (navigationElement == null) continue;
                psiElement = navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                continue;
            }
            if (psiElement == null) {
                ClsFileImpl.$$$reportNull$$$0(18);
            }
            return psiElement;
        }
        PsiElement psiElement = (PsiElement)CachedValuesManager.getCachedValue(this, () -> {
            PsiElement target = JavaPsiImplementationHelper.getInstance(this.getProject()).getClsFileNavigationElement(this);
            ModificationTracker tracker = FileIndexFacade.getInstance(this.getProject()).getRootModificationTracker();
            return CachedValueProvider.Result.create(target, this, target.getContainingFile(), tracker);
        });
        if (psiElement == null) {
            ClsFileImpl.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = SoftReference.dereference(this.myMirrorFileElement);
        if (mirrorTreeElement == null) {
            Object object = this.myMirrorLock;
            synchronized (object) {
                mirrorTreeElement = SoftReference.dereference(this.myMirrorFileElement);
                if (mirrorTreeElement == null) {
                    VirtualFile file2 = this.getVirtualFile();
                    AstLoadingFilter.assertTreeLoadingAllowed(file2);
                    PsiClass[] classes2 = this.getClasses();
                    String fileName = (classes2.length > 0 ? classes2[0].getName() : file2.getNameWithoutExtension()) + ".java";
                    Document document = FileDocumentManager.getInstance().getDocument(file2);
                    assert (document != null) : file2.getUrl();
                    CharSequence mirrorText = document.getImmutableCharSequence();
                    boolean internalDecompiler = StringUtil.startsWith(mirrorText, "\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n");
                    PsiFileFactory factory2 = PsiFileFactory.getInstance(this.getManager().getProject());
                    PsiFile mirror = factory2.createFileFromText(fileName, JavaLanguage.INSTANCE, mirrorText, false, false);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, this.getLanguageLevel());
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull(mirror);
                    try {
                        TreeElement finalMirrorTreeElement = mirrorTreeElement;
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            this.setFileMirror(finalMirrorTreeElement);
                            this.putUserData(CLS_DOCUMENT_LINK_KEY, document);
                        });
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file2.getUrl(), internalDecompiler ? e : ClsFileImpl.wrapException(e, file2));
                    }
                    ((PsiFileImpl)mirror).setOriginalFile(this);
                    this.myMirrorFileElement = new SoftReference<TreeElement>(mirrorTreeElement);
                }
            }
        }
        PsiElement psiElement = mirrorTreeElement.getPsi();
        if (psiElement == null) {
            ClsFileImpl.$$$reportNull$$$0(20);
        }
        return psiElement;
    }

    @Override
    public String getText() {
        VirtualFile file2 = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null) : file2.getUrl();
        return document.getText();
    }

    @Override
    public int getTextLength() {
        VirtualFile file2 = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null) : file2.getUrl();
        return document.getTextLength();
    }

    private static Exception wrapException(ClsElementImpl.InvalidMirrorException e, VirtualFile file2) {
        PluginId pluginId;
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file2);
        if (decompiler instanceof ClassFileDecompilers.Light && (pluginId = PluginManagerCore.getPluginByClassName(decompiler.getClass().getName())) != null) {
            return new PluginException(e, pluginId);
        }
        return e;
    }

    @Override
    public PsiFile getDecompiledPsiFile() {
        return (PsiFile)this.getMirror();
    }

    @Nullable
    public PsiFile getCachedMirror() {
        TreeElement mirrorTreeElement = SoftReference.dereference(this.myMirrorFileElement);
        return mirrorTreeElement == null ? null : (PsiFile)mirrorTreeElement.getPsi();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsFileImpl.$$$reportNull$$$0(21);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile(this);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    @Override
    public final TextRange getTextRange() {
        return TextRange.create(0, this.getTextLength());
    }

    @Override
    public final int getStartOffsetInParent() {
        return 0;
    }

    @Override
    public final PsiElement findElementAt(int offset2) {
        return this.getMirror().findElementAt(offset2);
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        return this.getMirror().findReferenceAt(offset2);
    }

    @Override
    public final int getTextOffset() {
        return 0;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getMirror().textToCharArray();
        if (cArray == null) {
            ClsFileImpl.$$$reportNull$$$0(22);
        }
        return cArray;
    }

    @NotNull
    public PsiClassHolderFileStub<?> getStub() {
        PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)this.getStubTree().getRoot();
        if (psiClassHolderFileStub == null) {
            ClsFileImpl.$$$reportNull$$$0(23);
        }
        return psiClassHolderFileStub;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            ClsFileImpl.$$$reportNull$$$0(24);
        }
        if (state2 == null) {
            ClsFileImpl.$$$reportNull$$$0(25);
        }
        if (place == null) {
            ClsFileImpl.$$$reportNull$$$0(26);
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor2.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes2;
            for (PsiClass aClass2 : classes2 = this.getClasses()) {
                if (processor2.execute(aClass2, state2)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            StubTree stubTree2 = stubTree;
            if (stubTree2 == null) {
                ClsFileImpl.$$$reportNull$$$0(27);
            }
            return stubTree2;
        }
        StubTree newStubTree = (StubTree)StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile(), this);
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file in index: " + this.getVirtualFile().getPresentableUrl());
            }
            newStubTree = new StubTree(new PsiJavaFileStubImpl("corrupted_class_files", true));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                StubTree stubTree3 = stubTree;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (stubTree3 == null) {
                    ClsFileImpl.$$$reportNull$$$0(28);
                }
                return stubTree3;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi(this);
            this.myStub = new SoftReference<StubTree>(stubTree);
        }
        StubTree stubTree4 = stubTree;
        if (stubTree4 == null) {
            ClsFileImpl.$$$reportNull$$$0(29);
        }
        return stubTree4;
    }

    @Override
    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubbedSpine stubbedSpine = this.getStubTree().getSpine();
        if (stubbedSpine == null) {
            ClsFileImpl.$$$reportNull$$$0(30);
        }
        return stubbedSpine;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.getCachedMirror() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("cls onContentReload");
            }
        }
        object = this.myMirrorLock;
        synchronized (object) {
            this.putUserData(CLS_DOCUMENT_LINK_KEY, null);
            this.myMirrorFileElement = null;
            this.myPackageStatement = null;
        }
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info2) {
        if (info2 == null) {
            ClsFileImpl.$$$reportNull$$$0(31);
        }
        PsiFileImpl.putInfo(this, info2);
    }

    @NotNull
    public static CharSequence decompile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClsFileImpl.$$$reportNull$$$0(32);
        }
        PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
        ClsFileImpl clsFile = new ClsFileImpl(new ClassFileViewProvider(manager, file2), true);
        StringBuilder buffer = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(() -> clsFile.appendMirrorText(buffer));
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            ClsFileImpl.$$$reportNull$$$0(33);
        }
        return stringBuilder;
    }

    @Nullable
    public static PsiJavaFileStub buildFileStub(@NotNull VirtualFile file2, @NotNull byte[] bytes) throws ClsFormatException {
        if (file2 == null) {
            ClsFileImpl.$$$reportNull$$$0(34);
        }
        if (bytes == null) {
            ClsFileImpl.$$$reportNull$$$0(35);
        }
        try {
            block11: {
                LanguageLevel level;
                if (ClassFileViewProvider.isInnerClass(file2, bytes)) {
                    return null;
                }
                ClassReader reader = new ClassReader(bytes);
                String className2 = file2.getNameWithoutExtension();
                String internalName = reader.getClassName();
                boolean module2 = internalName.equals("module-info") && BitUtil.isSet(reader.getAccess(), 32768);
                JavaSdkVersion jdkVersion = ClsParsingUtil.getJdkVersionByBytecode(reader.readShort(6));
                LanguageLevel languageLevel = level = jdkVersion != null ? jdkVersion.getMaxLanguageLevel() : null;
                if (module2) {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, "", level, true);
                    ModuleStubBuildingVisitor visitor2 = new ModuleStubBuildingVisitor(stub);
                    reader.accept(visitor2, EMPTY_ATTRIBUTES, 4);
                    if (visitor2.getResult() != null) {
                        return stub;
                    }
                } else {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, ClsFileImpl.getPackageName(internalName), level, true);
                    try {
                        FileContentPair source = new FileContentPair(file2, bytes);
                        StubBuildingVisitor<FileContentPair> visitor3 = new StubBuildingVisitor<FileContentPair>(source, STRATEGY, stub, 0, className2);
                        reader.accept(visitor3, EMPTY_ATTRIBUTES, 4);
                        if (visitor3.getResult() != null) {
                            return stub;
                        }
                    }
                    catch (OutOfOrderInnerClassException e) {
                        if (!LOG.isTraceEnabled()) break block11;
                        LOG.trace(file2.getPath());
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ClsFormatException(file2.getPath() + ": " + e.getMessage(), e);
        }
    }

    private static String getPackageName(String internalName) {
        int p = internalName.lastIndexOf(47);
        return p > 0 ? internalName.substring(0, p).replace('/', '.') : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubTree";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "decompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setFileMirror";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "decompile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildFileStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FileContentPair
    extends Pair<VirtualFile, byte[]> {
        FileContentPair(@NotNull VirtualFile file2, @NotNull byte[] content) {
            if (file2 == null) {
                FileContentPair.$$$reportNull$$$0(0);
            }
            if (content == null) {
                FileContentPair.$$$reportNull$$$0(1);
            }
            super(file2, content);
        }

        @NotNull
        public byte[] getContent() {
            byte[] byArray = (byte[])this.second;
            if (byArray == null) {
                FileContentPair.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        @Override
        public String toString() {
            return ((VirtualFile)this.first).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl$FileContentPair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl$FileContentPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

