/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.provider.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.runner.DefaultBuildController;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class ClientProvidedBuildActionRunner
implements BuildActionRunner {
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        if (!(action instanceof ClientProvidedBuildAction)) {
            return BuildActionRunner.Result.nothing();
        }
        GradleInternal gradle = buildController.getGradle();
        gradle.getStartParameter().setConfigureOnDemand(false);
        ClientProvidedBuildAction clientProvidedBuildAction = (ClientProvidedBuildAction)action;
        PayloadSerializer payloadSerializer = this.getPayloadSerializer(gradle);
        Object clientAction = payloadSerializer.deserialize(clientProvidedBuildAction.getAction());
        RuntimeException buildFailure = null;
        RuntimeException clientFailure = null;
        ResultBuildingListener listener = new ResultBuildingListener(gradle, clientAction);
        try {
            gradle.addBuildListener((BuildListener)listener);
            if (clientProvidedBuildAction.isRunTasks()) {
                buildController.run();
            } else {
                buildController.configure();
            }
        }
        catch (RuntimeException e) {
            buildFailure = e;
            clientFailure = e;
        }
        if (listener.actionFailure != null) {
            clientFailure = new InternalBuildActionFailureException((Throwable)listener.actionFailure);
        }
        if (buildFailure != null) {
            return BuildActionRunner.Result.failed((Throwable)buildFailure, (RuntimeException)clientFailure);
        }
        return BuildActionRunner.Result.of((Object)listener.result);
    }

    private void forceFullConfiguration(GradleInternal gradle) {
        ((ProjectConfigurer)gradle.getServices().get(ProjectConfigurer.class)).configureHierarchyFully(gradle.getRootProject());
        for (IncludedBuild includedBuild : gradle.getIncludedBuilds()) {
            GradleInternal build = ((IncludedBuildState)includedBuild).getConfiguredBuild();
            this.forceFullConfiguration(build);
        }
    }

    private PayloadSerializer getPayloadSerializer(GradleInternal gradle) {
        return (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
    }

    private class ResultBuildingListener
    extends InternalBuildAdapter {
        private final GradleInternal gradle;
        private final Object clientAction;
        Object result;
        RuntimeException actionFailure;

        ResultBuildingListener(GradleInternal gradle, Object clientAction) {
            this.gradle = gradle;
            this.clientAction = clientAction;
        }

        public void projectsEvaluated(Gradle gradle) {
            ClientProvidedBuildActionRunner.this.forceFullConfiguration((GradleInternal)gradle);
        }

        public void buildFinished(BuildResult result) {
            if (result.getFailure() != null) {
                return;
            }
            this.buildResult(this.clientAction, this.gradle);
        }

        private void buildResult(Object clientAction, GradleInternal gradle) {
            DefaultBuildController internalBuildController = new DefaultBuildController(gradle);
            try {
                this.result = clientAction instanceof InternalBuildActionVersion2 ? ((InternalBuildActionVersion2)clientAction).execute((InternalBuildControllerVersion2)internalBuildController) : ((InternalBuildAction)clientAction).execute((InternalBuildController)internalBuildController);
            }
            catch (RuntimeException e) {
                this.actionFailure = e;
                throw e;
            }
        }
    }
}

