(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/logger#current-logger (make-parameter '#f))
  (define std/logger#start-logger!__%
    (lambda (_output21894_)
      (let ((_$e21896_ (std/logger#current-logger)))
        (if _$e21896_
            (values _$e21896_)
            (let ((_g21923_
                   (if (output-port? _output21894_)
                       (values _output21894_ '#f)
                       (if (string? _output21894_)
                           (values (open-output-file
                                    (cons 'path:
                                          (cons _output21894_
                                                (cons 'append:
                                                      (cons '#t '())))))
                                   '#t)
                           (error '"Bad output; expected filename or port"
                                  _output21894_)))))
              (begin
                (let ((_g21924_
                       (if (##values? _g21923_) (##vector-length _g21923_) 1)))
                  (if (not (##fx= _g21924_ 2))
                      (error "Context expects 2 values" _g21924_)))
                (let ((_port21899_ (##vector-ref _g21923_ 0))
                      (_own-port?21900_ (##vector-ref _g21923_ 1)))
                  (let ((_srv21902_
                         (gerbil/gambit/threads#spawn/name
                          'logger
                          std/logger#logger-server
                          _port21899_
                          _own-port?21900_)))
                    (std/logger#current-logger _srv21902_)
                    _srv21902_))))))))
  (define std/logger#start-logger!__0
    (lambda ()
      (let ((_output21909_ (current-error-port)))
        (std/logger#start-logger!__% _output21909_))))
  (define std/logger#start-logger!
    (lambda _g21926_
      (let ((_g21925_ (length _g21926_)))
        (cond ((##fx= _g21925_ 0) (apply std/logger#start-logger!__0 _g21926_))
              ((##fx= _g21925_ 1) (apply std/logger#start-logger!__% _g21926_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/logger#start-logger!
                _g21926_))))))
  (define std/logger#!log-message::t
    (make-struct-type
     'std/logger#!log-message::t
     '#f
     '3
     '!log-message
     '()
     '#f
     '(source level e)))
  (define std/logger#!log-message?
    (make-struct-predicate std/logger#!log-message::t))
  (define std/logger#make-!log-message
    (lambda _$args21890_
      (apply make-struct-instance std/logger#!log-message::t _$args21890_)))
  (define std/logger#!log-message-source
    (make-struct-field-accessor std/logger#!log-message::t '0))
  (define std/logger#!log-message-level
    (make-struct-field-accessor std/logger#!log-message::t '1))
  (define std/logger#!log-message-e
    (make-struct-field-accessor std/logger#!log-message::t '2))
  (define std/logger#!log-message-source-set!
    (make-struct-field-mutator std/logger#!log-message::t '0))
  (define std/logger#!log-message-level-set!
    (make-struct-field-mutator std/logger#!log-message::t '1))
  (define std/logger#!log-message-e-set!
    (make-struct-field-mutator std/logger#!log-message::t '2))
  (define std/logger#logger-server
    (lambda (_port21831_ _own-port?21832_)
      (letrec ((_loop21834_
                (lambda ()
                  (let* ((_g2183821849_ (thread-receive))
                         (_else2184121857_ (lambda () (_loop21834_))))
                    (let ((_K2184421872_
                           (lambda (_message21868_ _level21869_ _source21870_)
                             (std/format#fprintf
                              _port21831_
                              '"~a [~a] ~a: ~a~n"
                              (std/srfi/19#date->string
                               (std/srfi/19#current-date)
                               '"~4")
                              _level21869_
                              _source21870_
                              _message21868_)
                             (force-output _port21831_)
                             (_loop21834_)))
                          (_K2184321862_ (lambda () '#!void)))
                      (let ((_try-match2184021865_
                             (lambda ()
                               (if (##eq? _g2183821849_ 'shutdown)
                                   '#!void
                                   (_loop21834_)))))
                        (if (##structure-instance-of?
                             _g2183821849_
                             'std/logger#!log-message::t)
                            (let* ((_e2184521875_
                                    (##vector-ref _g2183821849_ '1))
                                   (_e2184621880_
                                    (##vector-ref _g2183821849_ '2))
                                   (_e2184721885_
                                    (##vector-ref _g2183821849_ '3)))
                              (let ((_source21878_ _e2184521875_)
                                    (_level21883_ _e2184621880_)
                                    (_message21888_ _e2184721885_))
                                (_K2184421872_
                                 _message21888_
                                 _level21883_
                                 _source21878_)))
                            (_try-match2184021865_))))))))
        (with-unwind-protect
         (lambda () (_loop21834_))
         (lambda () (if _own-port?21832_ (close-port _port21831_) '#!void))))))
  (define std/logger#debug
    (lambda (_fmt21828_ . _args21829_)
      (std/logger#log-message
       'debug
       (apply std/format#format _fmt21828_ _args21829_))))
  (define std/logger#warning
    (lambda (_fmt21825_ . _args21826_)
      (std/logger#log-message
       'warning
       (apply std/format#format _fmt21825_ _args21826_))))
  (define std/logger#log-error
    (lambda (_what21820_ _exn21821_)
      (let ((_outp21823_ (open-output-string)))
        (std/format#fprintf _outp21823_ '"~a: " _what21820_)
        (display-exception _exn21821_ _outp21823_)
        (std/logger#log-message 'error (get-output-string _outp21823_)))))
  (define std/logger#log-message
    (lambda (_level21811_ _msg21812_)
      (let ((_logger2181321815_ (std/logger#current-logger)))
        (if _logger2181321815_
            (let ((_logger21818_ _logger2181321815_))
              (thread-send
               _logger21818_
               (##structure
                std/logger#!log-message::t
                (current-thread)
                _level21811_
                _msg21812_)))
            '#f)))))
