/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.ops.OPSHandler30;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.ValidatorMap;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.List;

public class OPSChecker
implements ContentChecker,
DocumentValidator {
    private static final ValidatorMap validatorMap = ValidatorMap.builder().putAll(Predicates.and(ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2)), XMLValidators.XHTML_20_NVDL, XMLValidators.XHTML_20_SCH, XMLValidators.IDUNIQUE_20_SCH).putAll(Predicates.and(ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.XHTML_30_RNC, XMLValidators.XHTML_30_SCH).putAll(Predicates.and(ValidationContext.ValidationContextPredicates.mimetype("image/svg+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2)), XMLValidators.SVG_20_RNG, XMLValidators.IDUNIQUE_20_SCH).putAll(Predicates.and(ValidationContext.ValidationContextPredicates.mimetype("image/svg+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.SVG_30_NVDL).putAll(Predicates.and(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.DICT), ValidationContext.ValidationContextPredicates.hasPubType("dictionary")), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.XHTML_DICT_SCH).putAll(Predicates.and(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.EDUPUB), ValidationContext.ValidationContextPredicates.hasPubType("edupub")), Predicates.not(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.FIXED_LAYOUT))), Predicates.not(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.NON_LINEAR))), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.XHTML_EDUPUB_STRUCTURE_SCH, XMLValidators.XHTML_EDUPUB_SEMANTICS_SCH, XMLValidators.XHTML_IDX_SCH).putAll(Predicates.and(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.IDX), ValidationContext.ValidationContextPredicates.hasPubType("index"), ValidationContext.ValidationContextPredicates.hasProp(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.INDEX)), ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.IN_INDEX_COLLECTION))), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.XHTML_IDX_SCH, XMLValidators.XHTML_IDX_INDEX_SCH).put(ValidationContext.ValidationContextPredicates.hasProp(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.DATA_NAV)), XMLValidators.XHTML_DATANAV_SCH).build();
    private final ValidationContext context;
    private final Report report;
    private final String path;

    public OPSChecker(ValidationContext context) {
        this.context = context;
        this.path = context.path;
        this.report = context.report;
    }

    @Override
    public void runChecks() {
        OCFPackage ocf = this.context.ocf.get();
        if (!ocf.hasEntry(this.path)) {
            this.report.message(MessageId.RSC_001, EPUBLocation.create(ocf.getName()), this.path);
        } else if (!ocf.canDecrypt(this.path)) {
            this.report.message(MessageId.RSC_004, EPUBLocation.create(ocf.getName()), this.path);
        } else {
            this.validate();
        }
    }

    @Override
    public boolean validate() {
        int fatalErrorsSoFar = this.report.getFatalErrorCount();
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        List<XMLValidator> validators = validatorMap.getValidators(this.context);
        try {
            this.validate(validators);
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.create(this.path), this.path);
        }
        return fatalErrorsSoFar == this.report.getFatalErrorCount() && errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }

    void validate(List<XMLValidator> validators) throws IOException {
        XMLParser opsParser = new XMLParser(this.context);
        OPSHandler opsHandler = this.context.version == EPUBVersion.VERSION_2 ? new OPSHandler(this.context, opsParser) : new OPSHandler30(this.context, opsParser);
        opsParser.addXMLHandler(opsHandler);
        for (XMLValidator validator : validators) {
            opsParser.addValidator(validator);
        }
        opsParser.process();
    }
}

