/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.OCFData;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OCFHandler
implements OCFData,
XMLHandler {
    private final Map<String, List<String>> entries = new HashMap<String, List<String>>();
    private final XMLParser parser;
    private String mappingDoc = null;
    private boolean checkedUnsupportedXmlVersion = false;

    OCFHandler(XMLParser parser) {
        this.parser = parser;
    }

    @Override
    public List<String> getEntries(String mediatype) {
        if (this.entries.containsKey(mediatype)) {
            return Collections.unmodifiableList(this.entries.get(mediatype));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getEntries() {
        LinkedList<String> result = new LinkedList<String>();
        for (List<String> paths : this.entries.values()) {
            result.addAll(paths);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Optional<String> getMapping() {
        return Optional.fromNullable(this.mappingDoc);
    }

    @Override
    public void startElement() {
        XMLElement e;
        String ns;
        if (!this.checkedUnsupportedXmlVersion) {
            HandlerUtil.checkXMLVersion(this.parser);
            this.checkedUnsupportedXmlVersion = true;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:container".equals(ns = (e = this.parser.getCurrentElement()).getNamespace())) {
            if ("rootfile".equals(e.getName())) {
                String mediaType = e.getAttribute("media-type") != null ? e.getAttribute("media-type").trim() : "unknown";
                String fullPath = e.getAttribute("full-path");
                if (!this.entries.containsKey(mediaType)) {
                    this.entries.put(mediaType, new LinkedList());
                }
                this.entries.get(mediaType).add(fullPath);
            } else if ("link".equals(e.getName()) && "mapping".equals(Strings.nullToEmpty(e.getAttribute("rel")).trim())) {
                this.mappingDoc = e.getAttribute("href");
            }
        }
    }

    @Override
    public void endElement() {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }
}

