/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc.css;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.css.CSSSelector;
import com.adobe.epubcheck.ctc.css.CSSSelectorAttribute;
import com.adobe.epubcheck.ctc.css.CSSSelectorCollection;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.util.LocationImpl;
import com.adobe.epubcheck.util.TextSearchDictionaryEntry;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import org.idpf.epubcheck.util.css.CssContentHandler;
import org.idpf.epubcheck.util.css.CssErrorHandler;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssGrammar;
import org.idpf.epubcheck.util.css.CssLocation;

public class EpubCSSCheckCSSHandler
implements CssContentHandler,
CssErrorHandler {
    String path;
    Report report;
    boolean isGlobalFixedFormat;
    boolean hasIndividualFixedFormatDocuments;
    int scopeId;
    boolean isBody;
    boolean inKeyFrames;
    CSSSelectorCollection currentFileSelectorCollection;
    CSSSelectorCollection inProgressSelectorCollection;
    final Vector<TextSearchDictionaryEntry> declarationComponentItems = new Vector();
    final Vector<TextSearchDictionaryEntry> functionComponentItems = new Vector();
    final Vector<TextSearchDictionaryEntry> atRuleComponentItems = new Vector();
    int startingLineNumber;
    int startingColumnNumber;
    boolean inFontFace;
    boolean hasFontFaceDeclarations;
    CssGrammar.CssAtRule atRule;
    HashMap<String, ClassUsage> classMap = new LinkedHashMap<String, ClassUsage>();
    static final Pattern keyframesPattern = Pattern.compile("@((keyframes)|(-moz-keyframes)|(-webkit-keyframes)|(-o-keyframes))");
    HashSet<String> fontSizes;
    HashSet<String> fontVariants;
    HashSet<String> fontStyles;
    HashSet<String> fontWeightStrings;
    HashSet<String> validSystemFontNames;
    static final Pattern invalidTokenStringFinder = Pattern.compile("Token '[0-9]+%' not allowed here");

    public HashMap<String, ClassUsage> getClassMap() {
        return this.classMap;
    }

    public boolean IncrementGlobalCssClassCount(String attrValue) {
        ClassUsage val = this.getClassMap().get(attrValue);
        if (val != null) {
            ++val.Count;
            return true;
        }
        return false;
    }

    public void CheckUnusedCSSClassSelectors(Report report) {
        HashMap<String, ClassUsage> map = this.getClassMap();
        for (ClassUsage cu : map.values()) {
            if (cu.Count != 0) continue;
            assert (cu.Name != null && !cu.Name.isEmpty());
            report.message(MessageId.CSS_024, this.getCorrectedEPUBLocation(cu.FileName, cu.Location.getLineNumber(), cu.Location.getColumnNumber(), cu.Name), new Object[0]);
        }
    }

    int correctedLineNumber(int lineNumber) {
        return this.startingLineNumber + lineNumber;
    }

    int correctedColumnNumber(int lineNumber, int columnNumber) {
        if (lineNumber != 0) {
            return columnNumber;
        }
        return this.startingColumnNumber + columnNumber;
    }

    public EpubCSSCheckCSSHandler(Report report, boolean isGlobalFixedFormat, boolean hasIndividualFixedFormatDocuments) {
        this.startingLineNumber = 0;
        this.startingColumnNumber = 0;
        this.isGlobalFixedFormat = isGlobalFixedFormat;
        this.hasIndividualFixedFormatDocuments = hasIndividualFixedFormatDocuments;
        this.setReport(report);
        this.setScopeId(0);
        this.buildCssSearchDictionaries();
    }

    public EpubCSSCheckCSSHandler(Report report, int startingLineNumber, int startingColumnNumber, boolean isGlobalFixedFormat, boolean hasIndividualFixedFormatDocuments) {
        this.startingLineNumber = startingLineNumber - 1;
        this.startingColumnNumber = startingColumnNumber;
        this.isGlobalFixedFormat = isGlobalFixedFormat;
        this.hasIndividualFixedFormatDocuments = hasIndividualFixedFormatDocuments;
        this.setReport(report);
        this.setScopeId(0);
        this.buildCssSearchDictionaries();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    Report getReport() {
        return this.report;
    }

    void setReport(Report report) {
        this.report = report;
    }

    void setScopeId(int scopeId) {
        this.scopeId = scopeId;
    }

    void buildCssSearchDictionaries() {
        String description = "rotateX()";
        String value = "rotatex";
        TextSearchDictionaryEntry de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.functionComponentItems.add(de);
        description = "rotateY()";
        value = "rotatey";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.functionComponentItems.add(de);
        description = "columns";
        value = "columns";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.declarationComponentItems.add(de);
        description = "column-count";
        value = "column-count";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.declarationComponentItems.add(de);
        description = "column-gap";
        value = "column-gap";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.declarationComponentItems.add(de);
        description = "column-rule";
        value = "column-rule";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.declarationComponentItems.add(de);
        description = "keyframes";
        value = "keyframes";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.atRuleComponentItems.add(de);
        description = "transition";
        value = "transition";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.declarationComponentItems.add(de);
        description = "box-sizing";
        value = "box-sizing";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.declarationComponentItems.add(de);
    }

    @Override
    public void startDocument() {
        this.currentFileSelectorCollection = new CSSSelectorCollection(this.path, new LocationImpl(-1, -1, -1, this.path, this.path), this.scopeId);
    }

    @Override
    public void endDocument() {
        this.currentFileSelectorCollection = null;
        ++this.scopeId;
    }

    @Override
    public void startAtRule(CssGrammar.CssAtRule atRule) {
        this.atRule = atRule;
        if (atRule.getName() != Optional.absent()) {
            String ruleName = ((String)atRule.getName().get()).toLowerCase(Locale.ROOT);
            CssLocation location = atRule.getLocation();
            if (ruleName.startsWith("@media")) {
                this.getReport().message(MessageId.CSS_023, this.getCorrectedEPUBLocation(this.path, location.getLine(), location.getColumn(), atRule.toCssString()), new Object[0]);
            } else if (keyframesPattern.matcher(ruleName).matches()) {
                this.inKeyFrames = true;
            } else if (ruleName.equals("@font-face")) {
                this.inFontFace = true;
            }
            this.searchInsideValue(ruleName, atRule.getLocation().getLine(), location.getColumn(), this.atRuleComponentItems, this.path, atRule.toCssString());
        }
    }

    EPUBLocation getCorrectedEPUBLocation(String fileName, int lineNumber, int columnNumber, String context) {
        lineNumber = this.correctedLineNumber(lineNumber);
        columnNumber = this.correctedColumnNumber(lineNumber, columnNumber);
        return EPUBLocation.create(fileName, lineNumber, columnNumber, context);
    }

    @Override
    public void endAtRule(String ruleName) {
        if (ruleName.equals("@font-face") && !this.hasFontFaceDeclarations) {
            this.getReport().message(MessageId.CSS_019, this.getCorrectedEPUBLocation(this.path, this.atRule.getLocation().getLine(), this.atRule.getLocation().getColumn(), this.atRule.toCssString()), this.atRule.toCssString());
        }
        this.inKeyFrames = false;
        this.inFontFace = false;
        this.hasFontFaceDeclarations = false;
        this.atRule = null;
    }

    @Override
    public void selectors(List<CssGrammar.CssSelector> selectors) {
        this.inProgressSelectorCollection = new CSSSelectorCollection(this.path, this.getCorrectedLocationFromCssLocation(selectors.get(0).getLocation()), this.scopeId);
        LinkedList<CssGrammar.CssConstruct> selectorQueue = new LinkedList<CssGrammar.CssConstruct>();
        this.isBody = EpubCSSCheckCSSHandler.getIsBody(selectors, selectorQueue);
        block12: while (!selectorQueue.isEmpty()) {
            CssGrammar.CssConstruct construct = (CssGrammar.CssConstruct)selectorQueue.remove();
            CssGrammar.CssConstruct.Type type = construct.getType();
            switch (type) {
                case CLASSNAME: {
                    CssGrammar.CssClassName className = (CssGrammar.CssClassName)construct;
                    Object location = this.getCorrectedLocationFromCssLocation(className.getLocation());
                    CSSSelector newSelector = new CSSSelector(className.toCssString(), (Location)location, true);
                    this.inProgressSelectorCollection.addSelector(newSelector);
                    this.addClassSelector(newSelector, this.path, (Location)location);
                    break;
                }
                case STRING: 
                case KEYWORD: 
                case COMBINATOR: {
                    break;
                }
                case ATTRIBUTE_MATCH: {
                    CssGrammar.CssAttributeMatchSelector attributeMatchSelector = (CssGrammar.CssAttributeMatchSelector)construct;
                    Object location = this.getCorrectedLocationFromCssLocation(attributeMatchSelector.getLocation());
                    CSSSelector newSelector = new CSSSelector(attributeMatchSelector.toCssString(), (Location)location, false);
                    this.inProgressSelectorCollection.addSelector(newSelector);
                    break;
                }
                case HASHNAME: {
                    CssGrammar.CssHashName hashName = (CssGrammar.CssHashName)construct;
                    Object location = this.getCorrectedLocationFromCssLocation(hashName.getLocation());
                    CSSSelector newSelector = new CSSSelector(hashName.toCssString(), (Location)location, false);
                    this.inProgressSelectorCollection.addSelector(newSelector);
                    break;
                }
                case ATRULE: 
                case QUANTITY: 
                case URANGE: 
                case URI: 
                case SYMBOL: 
                case FUNCTION: 
                case DECLARATION: {
                    break;
                }
                case PSEUDO: {
                    CssGrammar.CssPseudoSelector psuedoSelector = (CssGrammar.CssPseudoSelector)construct;
                    Object location = this.getCorrectedLocationFromCssLocation(psuedoSelector.getLocation());
                    CSSSelector newSelector = new CSSSelector(psuedoSelector.toCssString(), (Location)location, false);
                    this.inProgressSelectorCollection.addSelector(newSelector);
                    break;
                }
                case TYPE_SELECTOR: {
                    CssGrammar.CssTypeSelector typeSelector = (CssGrammar.CssTypeSelector)construct;
                    Object location = this.getCorrectedLocationFromCssLocation(typeSelector.getLocation());
                    CSSSelector newSelector = new CSSSelector(typeSelector.toCssString(), (Location)location, false);
                    this.inProgressSelectorCollection.addSelector(newSelector);
                    break;
                }
                case SELECTOR: {
                    CssGrammar.CssSelector selector = (CssGrammar.CssSelector)construct;
                    for (CssGrammar.CssConstruct c : selector.getComponents()) {
                        selectorQueue.add(c);
                    }
                    continue block12;
                }
                case SIMPLE_SELECTOR_SEQ: {
                    CssGrammar.CssSimpleSelectorSequence sequence = (CssGrammar.CssSimpleSelectorSequence)construct;
                    for (CssGrammar.CssConstruct c : sequence.getComponents()) {
                        selectorQueue.add(c);
                    }
                    continue block12;
                }
                case ATTRIBUTE_SELECTOR: {
                    CssGrammar.CssAttributeSelector attributeSelector = (CssGrammar.CssAttributeSelector)construct;
                    Object location = this.getCorrectedLocationFromCssLocation(attributeSelector.getLocation());
                    CSSSelector newSelector = new CSSSelector(attributeSelector.toCssString(), (Location)location, false);
                    this.inProgressSelectorCollection.addSelector(newSelector);
                    break;
                }
            }
        }
    }

    static boolean getIsBody(List<CssGrammar.CssSelector> selectors, Queue<CssGrammar.CssConstruct> selectorQueue) {
        boolean isBody = false;
        for (CssGrammar.CssSelector selector : selectors) {
            String selectorName;
            selectorQueue.add(selector);
            if (isBody || !"body".equalsIgnoreCase(selectorName = selector.toCssString())) continue;
            isBody = true;
        }
        return isBody;
    }

    void addClassSelector(CSSSelector selector, String path, Location location) {
        if (selector.isClass()) {
            String name = selector.getName();
            ClassUsage c = this.getClassMap().get(name);
            if (c == null) {
                c = new ClassUsage();
                c.Count = 0;
                c.FileName = path;
                c.Location = location;
                c.Name = selector.getName();
                this.getClassMap().put(name, c);
            }
        }
    }

    Location getCorrectedLocationFromCssLocation(CssLocation location) {
        return new LocationImpl(this.correctedLineNumber(location.getLine()), this.correctedColumnNumber(location.getLine(), location.getColumn()), location.getCharOffset(), location.getSystemID(), location.getSystemID());
    }

    @Override
    public void endSelectors(List<CssGrammar.CssSelector> selectors) {
        for (CSSSelector selector : this.inProgressSelectorCollection.getSelectors().values()) {
            this.currentFileSelectorCollection.addSelector(selector);
        }
        this.inProgressSelectorCollection = null;
        this.isBody = false;
    }

    @Override
    public void declaration(CssGrammar.CssDeclaration declaration) {
        if (declaration.getName() != Optional.absent()) {
            String text = (String)declaration.getName().get();
            this.searchInsideValue(text, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), this.declarationComponentItems, this.path, declaration.toCssString());
            this.checkTermsAndValues(declaration);
            boolean isImportant = this.CheckImportant(declaration);
            boolean added = false;
            boolean isFontSize = "font-size".equalsIgnoreCase(text);
            boolean isFont = "font".equalsIgnoreCase(text);
            StringBuilder sb = new StringBuilder();
            if (isFont) {
                this.CheckFont(declaration);
            }
            if (this.isBody) {
                this.CheckBody(declaration);
            }
            for (CssGrammar.CssConstruct construct : declaration.getComponents()) {
                String searchText;
                Vector<TextSearchDictionaryEntry> searchItems;
                if (isFontSize) {
                    this.CheckFontSize(construct, declaration);
                }
                switch (construct.getType()) {
                    case FUNCTION: {
                        CssGrammar.CssFunction function = (CssGrammar.CssFunction)construct;
                        searchItems = this.functionComponentItems;
                        searchText = function.getName().isPresent() ? (String)function.getName().get() : null;
                        break;
                    }
                    default: {
                        searchItems = this.declarationComponentItems;
                        searchText = construct.toCssString();
                        if (this.inProgressSelectorCollection == null || searchText == null) break;
                        if (added) {
                            sb.append(" ");
                        }
                        sb.append(searchText);
                        added = true;
                    }
                }
                if (searchText == null) continue;
                this.searchInsideValue(searchText, construct.getLocation().getLine(), construct.getLocation().getColumn(), searchItems, this.path, declaration.toCssString());
            }
            if (this.inProgressSelectorCollection != null) {
                String value = sb.toString();
                for (CSSSelector selector : this.inProgressSelectorCollection.getSelectors().values()) {
                    CSSSelectorAttribute attribute = new CSSSelectorAttribute(text, value, isImportant, selector);
                    selector.addAttribute(attribute);
                }
            }
            if (this.inFontFace) {
                this.hasFontFaceDeclarations = true;
            }
        }
    }

    void checkTermsAndValues(CssGrammar.CssDeclaration declaration) {
        if ((!this.isGlobalFixedFormat || this.hasIndividualFixedFormatDocuments) && "position".compareToIgnoreCase((String)declaration.getName().get()) == 0) {
            for (CssGrammar.CssConstruct construct : declaration.getComponents()) {
                if (construct.getType() != CssGrammar.CssConstruct.Type.KEYWORD || "absolute".compareToIgnoreCase(construct.toCssString()) != 0) continue;
                this.getReport().message(MessageId.CSS_017, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), declaration.getName().get());
                break;
            }
        }
    }

    boolean CheckImportant(CssGrammar.CssDeclaration declaration) {
        boolean isImportant = declaration.getImportant();
        if (isImportant) {
            this.getReport().message(MessageId.CSS_013, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), new Object[0]);
        }
        return isImportant;
    }

    void CheckBody(CssGrammar.CssDeclaration declaration) {
        String declarationName = declaration.toCssString().toLowerCase(Locale.ROOT);
        if (declarationName.startsWith("margin-") || declarationName.equals("margin")) {
            this.getReport().message(MessageId.CSS_022, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), declarationName);
        }
    }

    void CheckFontSize(CssGrammar.CssConstruct construct, CssGrammar.CssDeclaration declaration) {
        MessageId id = this.hasIndividualFixedFormatDocuments ? MessageId.ACC_016 : MessageId.ACC_014;
        block0 : switch (construct.getType()) {
            case KEYWORD: {
                if (this.isGlobalFixedFormat && !this.hasIndividualFixedFormatDocuments) break;
                String value = construct.toCssString().toLowerCase(Locale.ROOT);
                if (!this.isFontSize(construct)) {
                    this.getReport().message(MessageId.CSS_020, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), construct.toCssString());
                    break;
                }
                if ("smaller".compareTo(value) == 0 || "larger".compareTo(value) == 0 || "inherit".compareTo(value) == 0) break;
                this.getReport().message(id, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), construct.toCssString());
                break;
            }
            case QUANTITY: {
                if (this.isGlobalFixedFormat && !this.hasIndividualFixedFormatDocuments) break;
                CssGrammar.CssQuantity quantity = (CssGrammar.CssQuantity)construct;
                switch (quantity.getUnit()) {
                    case EMS: 
                    case EXS: 
                    case REMS: 
                    case PERCENTAGE: {
                        break;
                    }
                    case LENGTH: {
                        this.getReport().message(id, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), construct.toCssString());
                        break;
                    }
                    case INTEGER: {
                        if (quantity.toCssString().equals("0")) break block0;
                        this.getReport().message(MessageId.CSS_020, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), construct.toCssString());
                        break;
                    }
                    default: {
                        this.getReport().message(MessageId.CSS_020, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), construct.toCssString());
                        break;
                    }
                }
                break;
            }
        }
    }

    void CheckFont(CssGrammar.CssDeclaration declaration) {
        boolean assignedFontStyle = false;
        boolean assignedFontVariant = false;
        boolean assignedFontWeight = false;
        int i = 0;
        List components = declaration.getComponents();
        if (!this.matchesSystemFont(declaration)) {
            while (i < components.size()) {
                String value;
                CssGrammar.CssConstruct construct = (CssGrammar.CssConstruct)components.get(i);
                if (!assignedFontStyle && this.isFontStyle(construct)) {
                    assignedFontStyle = true;
                    ++i;
                    continue;
                }
                if (!assignedFontVariant && this.isFontVariant(construct)) {
                    assignedFontVariant = true;
                    ++i;
                    continue;
                }
                if (!assignedFontWeight && this.isFontWeight(construct)) {
                    assignedFontWeight = true;
                    ++i;
                    continue;
                }
                if (!(assignedFontStyle && assignedFontVariant && assignedFontWeight || !this.isNormal(value = construct.toCssString()) && !this.isInherit(value))) {
                    if (!assignedFontStyle) {
                        assignedFontStyle = true;
                        ++i;
                        continue;
                    }
                    if (!assignedFontVariant) {
                        assignedFontVariant = true;
                        ++i;
                        continue;
                    }
                    assignedFontWeight = true;
                    ++i;
                    continue;
                }
                if (this.isFontSize(construct)) {
                    this.CheckFontSize(construct, declaration);
                    if (i <= components.size() - 2 && (construct = (CssGrammar.CssConstruct)components.get(++i)).getType() == CssGrammar.CssConstruct.Type.SYMBOL && construct.toCssString().equals("/")) {
                        construct = (CssGrammar.CssConstruct)components.get(++i);
                        this.CheckLineHeight(construct, declaration);
                    }
                    return;
                }
                this.getReport().message(MessageId.CSS_020, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), construct.toCssString());
                return;
            }
        }
    }

    boolean isFontSize(CssGrammar.CssConstruct construct) {
        if (null == this.fontSizes) {
            String[] fontSizeStrings = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "larger", "smaller", "inherit"};
            this.fontSizes = this.getHashSetFromStrings(fontSizeStrings);
        }
        if (this.valueMatchesLowercaseLegalValues(construct, this.fontSizes)) {
            return true;
        }
        if (construct.getType() == CssGrammar.CssConstruct.Type.QUANTITY) {
            CssGrammar.CssQuantity quantity = (CssGrammar.CssQuantity)construct;
            CssGrammar.CssQuantity.Unit unit = quantity.getUnit();
            switch (unit) {
                case EMS: 
                case EXS: 
                case PERCENTAGE: 
                case LENGTH: {
                    return true;
                }
                case INTEGER: {
                    if (!"0".equals(quantity.toCssString())) break;
                    return true;
                }
            }
        }
        return false;
    }

    void CheckLineHeight(CssGrammar.CssConstruct construct, CssGrammar.CssDeclaration declaration) {
        if (!this.isGlobalFixedFormat || this.hasIndividualFixedFormatDocuments) {
            MessageId id;
            MessageId messageId = id = this.hasIndividualFixedFormatDocuments ? MessageId.ACC_017 : MessageId.ACC_015;
            if (construct.getType() == CssGrammar.CssConstruct.Type.QUANTITY) {
                CssGrammar.CssQuantity quantity = (CssGrammar.CssQuantity)construct;
                CssGrammar.CssQuantity.Unit unit = quantity.getUnit();
                switch (unit) {
                    case EMS: 
                    case PERCENTAGE: {
                        break;
                    }
                    case NUMBER: {
                        break;
                    }
                    case LENGTH: {
                        this.getReport().message(id, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), new Object[0]);
                    }
                }
            }
        }
    }

    boolean isFontVariant(CssGrammar.CssConstruct construct) {
        if (null == this.fontVariants) {
            String[] fontVariantsStrings = new String[]{"small-caps"};
            this.fontVariants = this.getHashSetFromStrings(fontVariantsStrings);
        }
        return this.valueMatchesLowercaseLegalValues(construct, this.fontVariants);
    }

    boolean isFontStyle(CssGrammar.CssConstruct construct) {
        if (null == this.fontStyles) {
            String[] fontStylesStrings = new String[]{"italic", "oblique"};
            this.fontStyles = this.getHashSetFromStrings(fontStylesStrings);
        }
        return this.valueMatchesLowercaseLegalValues(construct, this.fontStyles);
    }

    boolean isNormal(String value) {
        return "normal".compareToIgnoreCase(value) == 0;
    }

    boolean isInherit(String value) {
        return "inherit".compareToIgnoreCase(value) == 0;
    }

    boolean isFontWeightString(String value) {
        if (this.fontWeightStrings == null) {
            String[] fontWeights = new String[]{"bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900"};
            this.fontWeightStrings = this.getHashSetFromStrings(fontWeights);
        }
        return this.valueMatchesLowercaseLegalValues(value, this.fontWeightStrings);
    }

    HashSet<String> getHashSetFromStrings(String[] strings) {
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, strings);
        return hashSet;
    }

    boolean valueMatchesLowercaseLegalValues(CssGrammar.CssConstruct construct, HashSet<String> legalValues) {
        return this.valueMatchesLowercaseLegalValues(construct.toCssString(), legalValues);
    }

    boolean valueMatchesLowercaseLegalValues(String value, HashSet<String> legalValues) {
        if (null == value || value.isEmpty()) {
            return false;
        }
        return legalValues.contains(value.toLowerCase(Locale.ROOT));
    }

    boolean isFontWeight(CssGrammar.CssConstruct construct) {
        switch (construct.getType()) {
            case STRING: 
            case KEYWORD: {
                return this.isFontWeightString(construct.toCssString());
            }
            case QUANTITY: {
                CssGrammar.CssQuantity quantity = (CssGrammar.CssQuantity)construct;
                if (quantity.getUnit() != CssGrammar.CssQuantity.Unit.INTEGER) break;
                return this.isFontWeightString(quantity.toCssString());
            }
        }
        return false;
    }

    boolean matchesSystemFont(CssGrammar.CssDeclaration declaration) {
        List components = declaration.getComponents();
        if (components.size() == 1 && ((CssGrammar.CssConstruct)components.get(0)).getType() == CssGrammar.CssConstruct.Type.KEYWORD) {
            String name = ((CssGrammar.CssConstruct)components.get(0)).toCssString();
            if (!this.isValidSystemFontName(name)) {
                this.getReport().message(MessageId.CSS_021, this.getCorrectedEPUBLocation(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), declaration.toCssString()), new Object[0]);
            }
            return true;
        }
        return false;
    }

    boolean isValidSystemFontName(String name) {
        if (this.validSystemFontNames == null) {
            String[] validSystemFontNamesStrings = new String[]{"caption", "icon", "menu", "message-box", "small-caption", "status-bar", "fantasy", "inherit"};
            this.validSystemFontNames = this.getHashSetFromStrings(validSystemFontNamesStrings);
        }
        return this.valueMatchesLowercaseLegalValues(name, this.validSystemFontNames);
    }

    @Override
    public void error(CssExceptions.CssException e) throws CssExceptions.CssException {
    }

    void searchInsideValue(String entry, int line, int column, Vector<TextSearchDictionaryEntry> tds, String file, String context) {
        for (TextSearchDictionaryEntry de : tds) {
            Pattern p = de.getPattern();
            Matcher matcher = p.matcher(entry);
            int position = 0;
            while (matcher.find(position)) {
                position = matcher.end();
                this.report.message(de.getErrorCode(), this.getCorrectedEPUBLocation(file, line, column, context), new Object[0]);
            }
        }
    }

    public class ClassUsage {
        public String Name;
        public Location Location;
        public String FileName;
        public int Count;
    }
}

