/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.security.PublicKeyHandler;
import org.apache.solr.util.CryptoKeys;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIAuthenticationPlugin
extends AuthenticationPlugin
implements HttpClientBuilderPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, PublicKey> keyCache = new ConcurrentHashMap<String, PublicKey>();
    private final PublicKeyHandler publicKeyHandler;
    private final CoreContainer cores;
    private final int MAX_VALIDITY = Integer.parseInt(System.getProperty("pkiauth.ttl", "15000"));
    private final String myNodeName;
    private final HttpHeaderClientInterceptor interceptor = new HttpHeaderClientInterceptor();
    private boolean interceptorRegistered = false;
    public static final String HEADER = "SolrAuth";
    public static final String NODE_IS_USER = "$";
    private static final Principal SU = new BasicUserPrincipal("$");

    public boolean isInterceptorRegistered() {
        return this.interceptorRegistered;
    }

    public PKIAuthenticationPlugin(CoreContainer cores, String nodeName, PublicKeyHandler publicKeyHandler) {
        this.publicKeyHandler = publicKeyHandler;
        this.cores = cores;
        this.myNodeName = nodeName;
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
    }

    @Override
    @SuppressForbidden(reason="Needs currentTimeMillis to compare against time in header")
    public boolean doAuthenticate(ServletRequest request, ServletResponse response, FilterChain filterChain) throws Exception {
        String cipher;
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        if (requestURI.endsWith("/admin/info/key")) {
            this.numPassThrough.inc();
            filterChain.doFilter(request, response);
            return true;
        }
        long receivedTime = System.currentTimeMillis();
        String header = ((HttpServletRequest)request).getHeader(HEADER);
        if (header == null) {
            log.error("No SolrAuth header present");
            this.numMissingCredentials.inc();
            filterChain.doFilter(request, response);
            return true;
        }
        List authInfo = StrUtils.splitWS((String)header, (boolean)false);
        if (authInfo.size() < 2) {
            log.error("Invalid SolrAuth Header {}", (Object)header);
            this.numErrors.mark();
            filterChain.doFilter(request, response);
            return true;
        }
        String nodeName = (String)authInfo.get(0);
        PKIHeaderData decipher = this.decipherHeader(nodeName, cipher = (String)authInfo.get(1));
        if (decipher == null) {
            log.error("Could not decipher a header {} . No principal set", (Object)header);
            this.numMissingCredentials.inc();
            filterChain.doFilter(request, response);
            return true;
        }
        if (receivedTime - decipher.timestamp > (long)this.MAX_VALIDITY) {
            log.error("Invalid key request timestamp: {} , received timestamp: {} , TTL: {}", new Object[]{decipher.timestamp, receivedTime, this.MAX_VALIDITY});
            this.numErrors.mark();
            filterChain.doFilter(request, response);
            return true;
        }
        Principal principal = NODE_IS_USER.equals(decipher.userName) ? SU : new BasicUserPrincipal(decipher.userName);
        this.numAuthenticated.inc();
        filterChain.doFilter((ServletRequest)PKIAuthenticationPlugin.getWrapper((HttpServletRequest)request, principal), response);
        return true;
    }

    private static HttpServletRequestWrapper getWrapper(HttpServletRequest request, final Principal principal) {
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return principal;
            }
        };
    }

    private PKIHeaderData decipherHeader(String nodeName, String cipherBase64) {
        PKIHeaderData header;
        PublicKey key = this.keyCache.get(nodeName);
        if (key == null) {
            log.debug("No key available for node : {} fetching now ", (Object)nodeName);
            key = this.getRemotePublicKey(nodeName);
            log.debug("public key obtained {} ", (Object)key);
        }
        if ((header = PKIAuthenticationPlugin.parseCipher(cipherBase64, key)) == null) {
            log.warn("Failed to decrypt header, trying after refreshing the key ");
            key = this.getRemotePublicKey(nodeName);
            return PKIAuthenticationPlugin.parseCipher(cipherBase64, key);
        }
        return header;
    }

    private static PKIHeaderData parseCipher(String cipher, PublicKey key) {
        byte[] bytes;
        try {
            bytes = CryptoKeys.decryptRSA(Base64.base64ToByteArray((String)cipher), key);
        }
        catch (Exception e) {
            log.error("Decryption failed , key must be wrong", (Throwable)e);
            return null;
        }
        String s = new String(bytes, StandardCharsets.UTF_8).trim();
        String[] ss = s.split(" ");
        if (ss.length < 2) {
            log.warn("Invalid cipher {} deciphered data {}", (Object)cipher, (Object)s);
            return null;
        }
        PKIHeaderData headerData = new PKIHeaderData();
        try {
            headerData.timestamp = Long.parseLong(ss[1]);
            headerData.userName = ss[0];
            log.debug("Successfully decrypted header {} {}", (Object)headerData.userName, (Object)headerData.timestamp);
            return headerData;
        }
        catch (NumberFormatException e) {
            log.warn("Invalid cipher {}", (Object)cipher);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublicKey getRemotePublicKey(String nodename) {
        PublicKey publicKey;
        if (!this.cores.getZkController().getZkStateReader().getClusterState().getLiveNodes().contains(nodename)) {
            return null;
        }
        String url = this.cores.getZkController().getZkStateReader().getBaseUrlForNodeName(nodename);
        HttpEntity entity = null;
        try {
            String uri = url + "/admin/info/key" + "?wt=json&omitHeader=true";
            log.debug("Fetching fresh public key from : {}", (Object)uri);
            HttpResponse rsp = this.cores.getUpdateShardHandler().getDefaultHttpClient().execute((HttpUriRequest)new HttpGet(uri), (HttpContext)HttpClientUtil.createNewHttpClientRequestContext());
            entity = rsp.getEntity();
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
            Map m = (Map)Utils.fromJSON((byte[])bytes);
            String key = (String)m.get("key");
            if (key == null) {
                log.error("No key available from " + url + "/admin/info/key");
                PublicKey publicKey2 = null;
                Utils.consumeFully((HttpEntity)entity);
                return publicKey2;
            }
            log.info("New Key obtained from  node: {} / {}", (Object)nodename, (Object)key);
            PublicKey pubKey = CryptoKeys.deserializeX509PublicKey(key);
            this.keyCache.put(nodename, pubKey);
            publicKey = pubKey;
            Utils.consumeFully((HttpEntity)entity);
        }
        catch (Exception e) {
            log.error("Exception trying to get public key from : " + url, (Throwable)e);
            PublicKey publicKey3 = null;
            return publicKey3;
        }
        finally {
            Utils.consumeFully(entity);
        }
        return publicKey;
    }

    @Override
    public void setup(Http2SolrClient client) {
        HttpListenerFactory.RequestResponseListener listener = new HttpListenerFactory.RequestResponseListener(){

            public void onQueued(Request request) {
                if (PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin() == null) {
                    return;
                }
                if (!PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin().interceptInternodeRequest(request)) {
                    log.debug("{} secures this internode request", (Object)((Object)((Object)this)).getClass().getSimpleName());
                    PKIAuthenticationPlugin.this.generateToken().ifPresent(s -> request.header(PKIAuthenticationPlugin.HEADER, PKIAuthenticationPlugin.this.myNodeName + " " + s));
                } else {
                    log.debug("{} secures this internode request", (Object)PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin().getClass().getSimpleName());
                }
            }
        };
        client.addListenerFactory(() -> listener);
    }

    @Override
    public SolrHttpClientBuilder getHttpClientBuilder(SolrHttpClientBuilder builder) {
        HttpClientUtil.addRequestInterceptor((HttpRequestInterceptor)this.interceptor);
        this.interceptorRegistered = true;
        return builder;
    }

    public boolean needsAuthorization(HttpServletRequest req) {
        return req.getUserPrincipal() != SU;
    }

    @SuppressForbidden(reason="Needs currentTimeMillis to set current time in header")
    private Optional<String> generateToken() {
        String usr;
        SolrRequestInfo reqInfo = this.getRequestInfo();
        if (reqInfo != null) {
            Principal principal = reqInfo.getUserPrincipal();
            if (principal == null) {
                log.debug("principal is null");
                return Optional.empty();
            }
            usr = principal.getName();
        } else {
            if (!this.isSolrThread()) {
                return Optional.empty();
            }
            usr = NODE_IS_USER;
        }
        String s = usr + " " + System.currentTimeMillis();
        byte[] payload = s.getBytes(StandardCharsets.UTF_8);
        byte[] payloadCipher = this.publicKeyHandler.keyPair.encrypt(ByteBuffer.wrap(payload));
        String base64Cipher = Base64.byteArrayToBase64((byte[])payloadCipher);
        return Optional.of(base64Cipher);
    }

    void setHeader(HttpRequest httpRequest) {
        this.generateToken().ifPresent(s -> httpRequest.setHeader(HEADER, this.myNodeName + " " + s));
    }

    boolean isSolrThread() {
        return ExecutorUtil.isSolrServerThread();
    }

    SolrRequestInfo getRequestInfo() {
        return SolrRequestInfo.getRequestInfo();
    }

    @Override
    public void close() throws IOException {
        HttpClientUtil.removeRequestInterceptor((HttpRequestInterceptor)this.interceptor);
        this.interceptorRegistered = false;
    }

    public String getPublicKey() {
        return this.publicKeyHandler.getPublicKey();
    }

    private class HttpHeaderClientInterceptor
    implements HttpRequestInterceptor {
        public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            if (PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin() == null) {
                return;
            }
            if (!PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin().interceptInternodeRequest(httpRequest, httpContext)) {
                log.debug("{} secures this internode request", (Object)this.getClass().getSimpleName());
                PKIAuthenticationPlugin.this.setHeader(httpRequest);
            } else {
                log.debug("{} secures this internode request", (Object)PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin().getClass().getSimpleName());
            }
        }
    }

    public static class PKIHeaderData {
        String userName;
        long timestamp;
    }
}

