/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.deserializer.classfile;

import java.io.UTFDataFormatException;
import java.util.HashMap;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.ConstantPool;
import org.jd.core.v1.model.classfile.Field;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.Annotation;
import org.jd.core.v1.model.classfile.attribute.Annotations;
import org.jd.core.v1.model.classfile.attribute.Attribute;
import org.jd.core.v1.model.classfile.attribute.AttributeAnnotationDefault;
import org.jd.core.v1.model.classfile.attribute.AttributeBootstrapMethods;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.attribute.AttributeConstantValue;
import org.jd.core.v1.model.classfile.attribute.AttributeDeprecated;
import org.jd.core.v1.model.classfile.attribute.AttributeExceptions;
import org.jd.core.v1.model.classfile.attribute.AttributeInnerClasses;
import org.jd.core.v1.model.classfile.attribute.AttributeLineNumberTable;
import org.jd.core.v1.model.classfile.attribute.AttributeLocalVariableTable;
import org.jd.core.v1.model.classfile.attribute.AttributeLocalVariableTypeTable;
import org.jd.core.v1.model.classfile.attribute.AttributeMethodParameters;
import org.jd.core.v1.model.classfile.attribute.AttributeModule;
import org.jd.core.v1.model.classfile.attribute.AttributeModuleMainClass;
import org.jd.core.v1.model.classfile.attribute.AttributeModulePackages;
import org.jd.core.v1.model.classfile.attribute.AttributeParameterAnnotations;
import org.jd.core.v1.model.classfile.attribute.AttributeSignature;
import org.jd.core.v1.model.classfile.attribute.AttributeSourceFile;
import org.jd.core.v1.model.classfile.attribute.AttributeSynthetic;
import org.jd.core.v1.model.classfile.attribute.BootstrapMethod;
import org.jd.core.v1.model.classfile.attribute.CodeException;
import org.jd.core.v1.model.classfile.attribute.ElementValue;
import org.jd.core.v1.model.classfile.attribute.ElementValueAnnotationValue;
import org.jd.core.v1.model.classfile.attribute.ElementValueArrayValue;
import org.jd.core.v1.model.classfile.attribute.ElementValueClassInfo;
import org.jd.core.v1.model.classfile.attribute.ElementValueEnumConstValue;
import org.jd.core.v1.model.classfile.attribute.ElementValuePair;
import org.jd.core.v1.model.classfile.attribute.ElementValuePrimitiveType;
import org.jd.core.v1.model.classfile.attribute.InnerClass;
import org.jd.core.v1.model.classfile.attribute.LineNumber;
import org.jd.core.v1.model.classfile.attribute.LocalVariable;
import org.jd.core.v1.model.classfile.attribute.LocalVariableType;
import org.jd.core.v1.model.classfile.attribute.MethodParameter;
import org.jd.core.v1.model.classfile.attribute.ModuleInfo;
import org.jd.core.v1.model.classfile.attribute.PackageInfo;
import org.jd.core.v1.model.classfile.attribute.ServiceInfo;
import org.jd.core.v1.model.classfile.attribute.UnknownAttribute;
import org.jd.core.v1.model.classfile.constant.Constant;
import org.jd.core.v1.model.classfile.constant.ConstantClass;
import org.jd.core.v1.model.classfile.constant.ConstantDouble;
import org.jd.core.v1.model.classfile.constant.ConstantFloat;
import org.jd.core.v1.model.classfile.constant.ConstantInteger;
import org.jd.core.v1.model.classfile.constant.ConstantLong;
import org.jd.core.v1.model.classfile.constant.ConstantMemberRef;
import org.jd.core.v1.model.classfile.constant.ConstantMethodHandle;
import org.jd.core.v1.model.classfile.constant.ConstantMethodType;
import org.jd.core.v1.model.classfile.constant.ConstantNameAndType;
import org.jd.core.v1.model.classfile.constant.ConstantString;
import org.jd.core.v1.model.classfile.constant.ConstantUtf8;
import org.jd.core.v1.model.classfile.constant.ConstantValue;
import org.jd.core.v1.service.deserializer.classfile.ClassFileFormatException;
import org.jd.core.v1.service.deserializer.classfile.ClassFileReader;
import org.jd.core.v1.util.DefaultList;

public class ClassFileDeserializer {
    public ClassFile loadClassFile(Loader loader, String internalTypeName) throws Exception {
        return this.innerLoadClassFile(loader, internalTypeName);
    }

    public ClassFile innerLoadClassFile(Loader loader, String internalTypeName) throws Exception {
        byte[] data = loader.load(internalTypeName);
        if (data == null) {
            return null;
        }
        ClassFileReader reader = new ClassFileReader(data);
        ClassFile classFile = this.loadClassFile(reader);
        AttributeInnerClasses aic = (AttributeInnerClasses)classFile.getAttribute("InnerClasses");
        if (aic != null) {
            DefaultList<ClassFile> innerClassFiles = new DefaultList<ClassFile>();
            String innerTypePrefix = internalTypeName + '$';
            for (InnerClass ic : aic.getInnerClasses()) {
                if (internalTypeName.equals(ic.getInnerTypeName()) || !internalTypeName.equals(ic.getOuterTypeName()) && !ic.getInnerTypeName().startsWith(innerTypePrefix)) continue;
                ClassFile innerClassFile = this.innerLoadClassFile(loader, ic.getInnerTypeName());
                int flags = ic.getInnerAccessFlags();
                int length = ic.getInnerTypeName().startsWith(innerTypePrefix) ? internalTypeName.length() + 1 : ic.getInnerTypeName().indexOf(36) + 1;
                if (Character.isDigit(ic.getInnerTypeName().charAt(length))) {
                    flags |= 0x1000;
                }
                if (innerClassFile == null) {
                    innerClassFile = new ClassFile(classFile.getMajorVersion(), classFile.getMinorVersion(), 0, internalTypeName, "java/lang/Object", null, null, null, null);
                }
                innerClassFile.setOuterClassFile(classFile);
                innerClassFile.setAccessFlags(flags);
                innerClassFiles.add(innerClassFile);
            }
            if (!innerClassFiles.isEmpty()) {
                classFile.setInnerClassFiles(innerClassFiles);
            }
        }
        return classFile;
    }

    protected ClassFile loadClassFile(ClassFileReader reader) throws UTFDataFormatException {
        int magic = reader.readInt();
        if (magic != -889275714) {
            throw new ClassFileFormatException("Invalid CLASS file");
        }
        int minorVersion = reader.readUnsignedShort();
        int majorVersion = reader.readUnsignedShort();
        ConstantPool constants = new ConstantPool(this.loadConstants(reader));
        int accessFlags = reader.readUnsignedShort();
        int thisClassIndex = reader.readUnsignedShort();
        int superClassIndex = reader.readUnsignedShort();
        String internalTypeName = constants.getConstantTypeName(thisClassIndex);
        String superTypeName = superClassIndex == 0 ? null : constants.getConstantTypeName(superClassIndex);
        String[] interfaceTypeNames = this.loadInterfaces(reader, constants);
        Field[] fields = this.loadFields(reader, constants);
        Method[] methods = this.loadMethods(reader, constants);
        HashMap<String, Attribute> attributes = this.loadAttributes(reader, constants);
        return new ClassFile(majorVersion, minorVersion, accessFlags, internalTypeName, superTypeName, interfaceTypeNames, fields, methods, attributes);
    }

    protected Constant[] loadConstants(ClassFileReader reader) throws UTFDataFormatException {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Constant[] constants = new Constant[count];
        block13: for (int i = 1; i < count; ++i) {
            byte tag = reader.readByte();
            switch (tag) {
                case 1: {
                    constants[i] = new ConstantUtf8(reader.readUTF8());
                    continue block13;
                }
                case 3: {
                    constants[i] = new ConstantInteger(reader.readInt());
                    continue block13;
                }
                case 4: {
                    constants[i] = new ConstantFloat(reader.readFloat());
                    continue block13;
                }
                case 5: {
                    constants[i++] = new ConstantLong(reader.readLong());
                    continue block13;
                }
                case 6: {
                    constants[i++] = new ConstantDouble(reader.readDouble());
                    continue block13;
                }
                case 7: 
                case 19: 
                case 20: {
                    constants[i] = new ConstantClass(reader.readUnsignedShort());
                    continue block13;
                }
                case 8: {
                    constants[i] = new ConstantString(reader.readUnsignedShort());
                    continue block13;
                }
                case 9: 
                case 10: 
                case 11: 
                case 17: 
                case 18: {
                    constants[i] = new ConstantMemberRef(reader.readUnsignedShort(), reader.readUnsignedShort());
                    continue block13;
                }
                case 12: {
                    constants[i] = new ConstantNameAndType(reader.readUnsignedShort(), reader.readUnsignedShort());
                    continue block13;
                }
                case 15: {
                    constants[i] = new ConstantMethodHandle(reader.readByte(), reader.readUnsignedShort());
                    continue block13;
                }
                case 16: {
                    constants[i] = new ConstantMethodType(reader.readUnsignedShort());
                    continue block13;
                }
                default: {
                    throw new ClassFileFormatException("Invalid constant pool entry");
                }
            }
        }
        return constants;
    }

    protected String[] loadInterfaces(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        String[] interfaceTypeNames = new String[count];
        for (int i = 0; i < count; ++i) {
            int index = reader.readUnsignedShort();
            interfaceTypeNames[i] = constants.getConstantTypeName(index);
        }
        return interfaceTypeNames;
    }

    protected Field[] loadFields(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Field[] fields = new Field[count];
        for (int i = 0; i < count; ++i) {
            int accessFlags = reader.readUnsignedShort();
            int nameIndex = reader.readUnsignedShort();
            int signatureIndex = reader.readUnsignedShort();
            HashMap<String, Attribute> attributes = this.loadAttributes(reader, constants);
            String name = constants.getConstantUtf8(nameIndex);
            String signature = constants.getConstantUtf8(signatureIndex);
            fields[i] = new Field(accessFlags, name, signature, attributes);
        }
        return fields;
    }

    protected Method[] loadMethods(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Method[] methods = new Method[count];
        for (int i = 0; i < count; ++i) {
            int accessFlags = reader.readUnsignedShort();
            int nameIndex = reader.readUnsignedShort();
            int signatureIndex = reader.readUnsignedShort();
            HashMap<String, Attribute> attributes = this.loadAttributes(reader, constants);
            String name = constants.getConstantUtf8(nameIndex);
            String signature = constants.getConstantUtf8(signatureIndex);
            methods[i] = new Method(accessFlags, name, signature, attributes, constants);
        }
        return methods;
    }

    protected HashMap<String, Attribute> loadAttributes(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        block44: for (int i = 0; i < count; ++i) {
            int attributeNameIndex = reader.readUnsignedShort();
            int attributeLength = reader.readInt();
            Object constant = constants.getConstant(attributeNameIndex);
            if (((Constant)constant).getTag() == 1) {
                String name;
                switch (name = ((ConstantUtf8)constant).getValue()) {
                    case "AnnotationDefault": {
                        attributes.put(name, new AttributeAnnotationDefault(this.loadElementValue(reader, constants)));
                        break;
                    }
                    case "BootstrapMethods": {
                        attributes.put(name, new AttributeBootstrapMethods(this.loadBootstrapMethods(reader)));
                        break;
                    }
                    case "Code": {
                        attributes.put(name, new AttributeCode(reader.readUnsignedShort(), reader.readUnsignedShort(), this.loadCode(reader), this.loadCodeExceptions(reader), this.loadAttributes(reader, constants)));
                        break;
                    }
                    case "ConstantValue": {
                        if (attributeLength != 2) {
                            throw new ClassFileFormatException("Invalid attribute length");
                        }
                        attributes.put(name, new AttributeConstantValue(this.loadConstantValue(reader, constants)));
                        break;
                    }
                    case "Deprecated": {
                        if (attributeLength != 0) {
                            throw new ClassFileFormatException("Invalid attribute length");
                        }
                        attributes.put(name, new AttributeDeprecated());
                        break;
                    }
                    case "Exceptions": {
                        attributes.put(name, new AttributeExceptions(this.loadExceptionTypeNames(reader, constants)));
                        break;
                    }
                    case "InnerClasses": {
                        attributes.put(name, new AttributeInnerClasses(this.loadInnerClasses(reader, constants)));
                        break;
                    }
                    case "LocalVariableTable": {
                        LocalVariable[] localVariables = this.loadLocalVariables(reader, constants);
                        if (localVariables == null) continue block44;
                        attributes.put(name, new AttributeLocalVariableTable(localVariables));
                        break;
                    }
                    case "LocalVariableTypeTable": {
                        attributes.put(name, new AttributeLocalVariableTypeTable(this.loadLocalVariableTypes(reader, constants)));
                        break;
                    }
                    case "LineNumberTable": {
                        attributes.put(name, new AttributeLineNumberTable(this.loadLineNumbers(reader)));
                        break;
                    }
                    case "MethodParameters": {
                        attributes.put(name, new AttributeMethodParameters(this.loadParameters(reader, constants)));
                        break;
                    }
                    case "Module": {
                        attributes.put(name, new AttributeModule(constants.getConstantTypeName(reader.readUnsignedShort()), reader.readUnsignedShort(), constants.getConstantUtf8(reader.readUnsignedShort()), this.loadModuleInfos(reader, constants), this.loadPackageInfos(reader, constants), this.loadPackageInfos(reader, constants), this.loadConstantClassNames(reader, constants), this.loadServiceInfos(reader, constants)));
                        break;
                    }
                    case "ModulePackages": {
                        attributes.put(name, new AttributeModulePackages(this.loadConstantClassNames(reader, constants)));
                        break;
                    }
                    case "ModuleMainClass": {
                        attributes.put(name, new AttributeModuleMainClass((ConstantClass)constants.getConstant(reader.readUnsignedShort())));
                        break;
                    }
                    case "RuntimeInvisibleAnnotations": 
                    case "RuntimeVisibleAnnotations": {
                        Annotation[] annotations = this.loadAnnotations(reader, constants);
                        if (annotations == null) continue block44;
                        attributes.put(name, new Annotations(annotations));
                        break;
                    }
                    case "RuntimeInvisibleParameterAnnotations": 
                    case "RuntimeVisibleParameterAnnotations": {
                        attributes.put(name, new AttributeParameterAnnotations(this.loadParameterAnnotations(reader, constants)));
                        break;
                    }
                    case "Signature": {
                        if (attributeLength != 2) {
                            throw new ClassFileFormatException("Invalid attribute length");
                        }
                        attributes.put(name, new AttributeSignature(constants.getConstantUtf8(reader.readUnsignedShort())));
                        break;
                    }
                    case "SourceFile": {
                        if (attributeLength != 2) {
                            throw new ClassFileFormatException("Invalid attribute length");
                        }
                        attributes.put(name, new AttributeSourceFile(constants.getConstantUtf8(reader.readUnsignedShort())));
                        break;
                    }
                    case "Synthetic": {
                        if (attributeLength != 0) {
                            throw new ClassFileFormatException("Invalid attribute length");
                        }
                        attributes.put(name, new AttributeSynthetic());
                        break;
                    }
                    default: {
                        attributes.put(name, new UnknownAttribute());
                        reader.skip(attributeLength);
                        break;
                    }
                }
                continue;
            }
            throw new ClassFileFormatException("Invalid attributes");
        }
        return attributes;
    }

    protected ElementValue loadElementValue(ClassFileReader reader, ConstantPool constants) {
        byte type = reader.readByte();
        switch (type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                int constValueIndex = reader.readUnsignedShort();
                ConstantValue constValue = (ConstantValue)constants.getConstant(constValueIndex);
                return new ElementValuePrimitiveType(type, constValue);
            }
            case 101: {
                int typeNameIndex = reader.readUnsignedShort();
                String typeName = constants.getConstantUtf8(typeNameIndex);
                int constNameIndex = reader.readUnsignedShort();
                String constName = constants.getConstantUtf8(constNameIndex);
                return new ElementValueEnumConstValue(typeName, constName);
            }
            case 99: {
                int classInfoIndex = reader.readUnsignedShort();
                String classInfo = constants.getConstantUtf8(classInfoIndex);
                return new ElementValueClassInfo(classInfo);
            }
            case 64: {
                int typeIndex = reader.readUnsignedShort();
                String typeName = constants.getConstantUtf8(typeIndex);
                return new ElementValueAnnotationValue(new Annotation(typeName, this.loadElementValuePairs(reader, constants)));
            }
            case 91: {
                return new ElementValueArrayValue(this.loadElementValues(reader, constants));
            }
        }
        throw new ClassFileFormatException("Invalid element value type: " + type);
    }

    protected ElementValuePair[] loadElementValuePairs(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        ElementValuePair[] pairs = new ElementValuePair[count];
        for (int i = 0; i < count; ++i) {
            int elementNameIndex = reader.readUnsignedShort();
            String elementName = constants.getConstantUtf8(elementNameIndex);
            pairs[i] = new ElementValuePair(elementName, this.loadElementValue(reader, constants));
        }
        return pairs;
    }

    protected ElementValue[] loadElementValues(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        ElementValue[] values = new ElementValue[count];
        for (int i = 0; i < count; ++i) {
            values[i] = this.loadElementValue(reader, constants);
        }
        return values;
    }

    protected BootstrapMethod[] loadBootstrapMethods(ClassFileReader reader) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        BootstrapMethod[] values = new BootstrapMethod[count];
        for (int i = 0; i < count; ++i) {
            int[] bootstrapArguments;
            int bootstrapMethodRef = reader.readUnsignedShort();
            int numBootstrapArguments = reader.readUnsignedShort();
            if (numBootstrapArguments == 0) {
                bootstrapArguments = null;
            } else {
                bootstrapArguments = new int[numBootstrapArguments];
                for (int j = 0; j < numBootstrapArguments; ++j) {
                    bootstrapArguments[j] = reader.readUnsignedShort();
                }
            }
            values[i] = new BootstrapMethod(bootstrapMethodRef, bootstrapArguments);
        }
        return values;
    }

    protected byte[] loadCode(ClassFileReader reader) {
        int code_length = reader.readInt();
        if (code_length == 0) {
            return null;
        }
        byte[] code = new byte[code_length];
        reader.readFully(code);
        return code;
    }

    protected CodeException[] loadCodeExceptions(ClassFileReader reader) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        CodeException[] codeExceptions = new CodeException[count];
        for (int i = 0; i < count; ++i) {
            codeExceptions[i] = new CodeException(i, reader.readUnsignedShort(), reader.readUnsignedShort(), reader.readUnsignedShort(), reader.readUnsignedShort());
        }
        return codeExceptions;
    }

    protected ConstantValue loadConstantValue(ClassFileReader reader, ConstantPool constants) {
        int constantValueIndex = reader.readUnsignedShort();
        return constants.getConstantValue(constantValueIndex);
    }

    protected String[] loadExceptionTypeNames(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        String[] exceptionTypeNames = new String[count];
        for (int i = 0; i < count; ++i) {
            int exceptionClassIndex = reader.readUnsignedShort();
            exceptionTypeNames[i] = constants.getConstantTypeName(exceptionClassIndex);
        }
        return exceptionTypeNames;
    }

    protected InnerClass[] loadInnerClasses(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        InnerClass[] innerClasses = new InnerClass[count];
        for (int i = 0; i < count; ++i) {
            int innerTypeIndex = reader.readUnsignedShort();
            int outerTypeIndex = reader.readUnsignedShort();
            int innerNameIndex = reader.readUnsignedShort();
            int innerAccessFlags = reader.readUnsignedShort();
            String innerTypeName = constants.getConstantTypeName(innerTypeIndex);
            String outerTypeName = outerTypeIndex == 0 ? null : constants.getConstantTypeName(outerTypeIndex);
            String innerName = innerNameIndex == 0 ? null : constants.getConstantUtf8(innerNameIndex);
            innerClasses[i] = new InnerClass(innerTypeName, outerTypeName, innerName, innerAccessFlags);
        }
        return innerClasses;
    }

    protected LocalVariable[] loadLocalVariables(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        LocalVariable[] localVariables = new LocalVariable[count];
        for (int i = 0; i < count; ++i) {
            int startPc = reader.readUnsignedShort();
            int length = reader.readUnsignedShort();
            int nameIndex = reader.readUnsignedShort();
            int descriptorIndex = reader.readUnsignedShort();
            int index = reader.readUnsignedShort();
            String name = constants.getConstantUtf8(nameIndex);
            String descriptor = constants.getConstantUtf8(descriptorIndex);
            localVariables[i] = new LocalVariable(startPc, length, name, descriptor, index);
        }
        return localVariables;
    }

    protected LocalVariableType[] loadLocalVariableTypes(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        LocalVariableType[] localVariables = new LocalVariableType[count];
        for (int i = 0; i < count; ++i) {
            int startPc = reader.readUnsignedShort();
            int length = reader.readUnsignedShort();
            int nameIndex = reader.readUnsignedShort();
            int descriptorIndex = reader.readUnsignedShort();
            int index = reader.readUnsignedShort();
            String name = constants.getConstantUtf8(nameIndex);
            String descriptor = constants.getConstantUtf8(descriptorIndex);
            localVariables[i] = new LocalVariableType(startPc, length, name, descriptor, index);
        }
        return localVariables;
    }

    protected LineNumber[] loadLineNumbers(ClassFileReader reader) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        LineNumber[] lineNumbers = new LineNumber[count];
        for (int i = 0; i < count; ++i) {
            lineNumbers[i] = new LineNumber(reader.readUnsignedShort(), reader.readUnsignedShort());
        }
        return lineNumbers;
    }

    protected MethodParameter[] loadParameters(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedByte();
        if (count == 0) {
            return null;
        }
        MethodParameter[] parameters = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            int nameIndex = reader.readUnsignedShort();
            String name = constants.getConstantUtf8(nameIndex);
            parameters[i] = new MethodParameter(name, reader.readUnsignedShort());
        }
        return parameters;
    }

    protected ModuleInfo[] loadModuleInfos(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        ModuleInfo[] moduleInfos = new ModuleInfo[count];
        for (int i = 0; i < count; ++i) {
            int moduleInfoIndex = reader.readUnsignedShort();
            int moduleFlag = reader.readUnsignedShort();
            int moduleVersionIndex = reader.readUnsignedShort();
            String moduleInfoName = constants.getConstantTypeName(moduleInfoIndex);
            String moduleVersion = moduleVersionIndex == 0 ? null : constants.getConstantUtf8(moduleVersionIndex);
            moduleInfos[i] = new ModuleInfo(moduleInfoName, moduleFlag, moduleVersion);
        }
        return moduleInfos;
    }

    protected PackageInfo[] loadPackageInfos(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        PackageInfo[] packageInfos = new PackageInfo[count];
        for (int i = 0; i < count; ++i) {
            int packageInfoIndex = reader.readUnsignedShort();
            int packageFlag = reader.readUnsignedShort();
            String packageInfoName = constants.getConstantTypeName(packageInfoIndex);
            packageInfos[i] = new PackageInfo(packageInfoName, packageFlag, this.loadConstantClassNames(reader, constants));
        }
        return packageInfos;
    }

    protected String[] loadConstantClassNames(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = constants.getConstantTypeName(reader.readUnsignedShort());
        }
        return names;
    }

    protected ServiceInfo[] loadServiceInfos(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        ServiceInfo[] services = new ServiceInfo[count];
        for (int i = 0; i < count; ++i) {
            services[i] = new ServiceInfo(constants.getConstantTypeName(reader.readUnsignedShort()), this.loadConstantClassNames(reader, constants));
        }
        return services;
    }

    protected Annotation[] loadAnnotations(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Annotation[] annotations = new Annotation[count];
        for (int i = 0; i < count; ++i) {
            int typeIndex = reader.readUnsignedShort();
            String typeName = constants.getConstantUtf8(typeIndex);
            annotations[i] = new Annotation(typeName, this.loadElementValuePairs(reader, constants));
        }
        return annotations;
    }

    protected Annotations[] loadParameterAnnotations(ClassFileReader reader, ConstantPool constants) {
        int count = reader.readUnsignedByte();
        if (count == 0) {
            return null;
        }
        Annotations[] parameterAnnotations = new Annotations[count];
        for (int i = 0; i < count; ++i) {
            Annotation[] annotations = this.loadAnnotations(reader, constants);
            if (annotations == null) continue;
            parameterAnnotations[i] = new Annotations(annotations);
        }
        return parameterAnnotations;
    }
}

