/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.CommentStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileBreakContinueStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileMonitorEnterStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileMonitorExitStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileTryStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ByteCodeParser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LoopStatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ObjectTypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureParser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SwitchStatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SynchronizedStatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TryWithResourcesStatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.WatchDog;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.MergeTryWithResourcesStatementVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RemoveBinaryOpReturnStatementsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RemoveFinallyStatementsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.UpdateIntegerConstantTypeVisitor;
import org.jd.core.v1.util.DefaultList;
import org.jd.core.v1.util.DefaultStack;

public class StatementMaker {
    protected static final SwitchCaseComparator SWITCH_CASE_COMPARATOR = new SwitchCaseComparator();
    protected static final NullExpression FINALLY_EXCEPTION_EXPRESSION = new NullExpression(new ObjectType("java/lang/Exception", "java.lang.Exception", "Exception"));
    protected static final MergeTryWithResourcesStatementVisitor MERGE_TRY_WITH_RESOURCES_STATEMENT_VISITOR = new MergeTryWithResourcesStatementVisitor();
    protected ObjectTypeMaker objectTypeMaker;
    protected SignatureParser signatureParser;
    protected LocalVariableMaker localVariableMaker;
    protected ByteCodeParser byteCodeParser;
    protected int majorVersion;
    protected String internalTypeName;
    protected ClassFileBodyDeclaration bodyDeclaration;
    protected DefaultStack<Expression> stack = new DefaultStack();
    protected RemoveFinallyStatementsVisitor removeFinallyStatementsVisitor;
    protected RemoveBinaryOpReturnStatementsVisitor removeBinaryOpReturnStatementsVisitor;
    protected final UpdateIntegerConstantTypeVisitor updateIntegerConstantTypeVisitor;
    protected SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    protected MemberVisitor memberVisitor = new MemberVisitor();
    protected boolean removeFinallyStatementsFlag = false;
    protected boolean mergeTryWithResourcesStatementFlag = false;

    public StatementMaker(ObjectTypeMaker objectTypeMaker, SignatureParser signatureParser, LocalVariableMaker localVariableMaker, ClassFile classFile, ClassFileBodyDeclaration bodyDeclaration, Type returnedType) {
        this.objectTypeMaker = objectTypeMaker;
        this.signatureParser = signatureParser;
        this.localVariableMaker = localVariableMaker;
        this.majorVersion = classFile.getMajorVersion();
        this.internalTypeName = classFile.getInternalTypeName();
        this.bodyDeclaration = bodyDeclaration;
        this.byteCodeParser = new ByteCodeParser(objectTypeMaker, signatureParser, localVariableMaker, this.internalTypeName, classFile, bodyDeclaration, returnedType);
        this.removeFinallyStatementsVisitor = new RemoveFinallyStatementsVisitor(localVariableMaker);
        this.removeBinaryOpReturnStatementsVisitor = new RemoveBinaryOpReturnStatementsVisitor(localVariableMaker);
        this.updateIntegerConstantTypeVisitor = new UpdateIntegerConstantTypeVisitor(signatureParser, returnedType);
    }

    public Statements make(ControlFlowGraph cfg) {
        Statements statements = new Statements();
        Statements jumps = new Statements();
        WatchDog watchdog = new WatchDog();
        this.localVariableMaker.pushFrame(statements);
        this.makeStatements(watchdog, cfg.getStart(), statements, jumps);
        if (this.removeFinallyStatementsFlag) {
            this.removeFinallyStatementsVisitor.init();
            statements.accept(this.removeFinallyStatementsVisitor);
        }
        if (this.mergeTryWithResourcesStatementFlag) {
            statements.accept(MERGE_TRY_WITH_RESOURCES_STATEMENT_VISITOR);
        }
        statements.accept(this.removeBinaryOpReturnStatementsVisitor);
        if (!statements.isEmpty() && statements.getLast().getClass() == ReturnStatement.class) {
            statements.removeLast();
        }
        this.localVariableMaker.popFrame();
        statements.accept(this.updateIntegerConstantTypeVisitor);
        this.replacePreOperatorWithPostOperator(statements);
        if (!jumps.isEmpty()) {
            this.updateJumpStatements(jumps);
        }
        return statements;
    }

    protected void makeStatements(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        switch (basicBlock.getType()) {
            case 1: {
                watchdog.check(basicBlock, basicBlock.getNext());
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                watchdog.check(basicBlock, basicBlock.getNext());
            }
            case 8: {
                this.parseByteCode(basicBlock, statements);
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                break;
            }
            case 16: {
                statements.add(ReturnStatement.RETURN);
                break;
            }
            case 32: 
            case 0x10000000: {
                this.parseByteCode(basicBlock, statements);
                break;
            }
            case 128: {
                this.parseSwitch(watchdog, basicBlock, statements, jumps);
                break;
            }
            case 256: {
                statements.add(BreakStatement.BREAK);
                break;
            }
            case 1024: {
                this.parseTry(watchdog, basicBlock, statements, jumps, false, false);
                break;
            }
            case 2048: {
                this.parseTry(watchdog, basicBlock, statements, jumps, true, false);
                break;
            }
            case 4096: {
                this.parseTry(watchdog, basicBlock, statements, jumps, false, true);
                break;
            }
            case 8192: {
                this.parseJSR(watchdog, basicBlock, statements, jumps);
                break;
            }
            case 16384: {
                this.parseByteCode(basicBlock, statements);
                break;
            }
            case 65536: {
                this.parseIf(watchdog, basicBlock, statements, jumps);
                break;
            }
            case 131072: {
                watchdog.check(basicBlock, basicBlock.getCondition());
                this.makeStatements(watchdog, basicBlock.getCondition(), statements, jumps);
                Expression condition = this.stack.pop();
                DefaultStack<Expression> backup = new DefaultStack<Expression>(this.stack);
                watchdog.check(basicBlock, basicBlock.getSub1());
                Statements<Statement> subStatements = this.makeSubStatements(watchdog, basicBlock.getSub1(), statements, jumps);
                if (!basicBlock.getSub2().matchType(0x3800000) && this.stack.size() != backup.size()) {
                    this.stack.copy(backup);
                }
                watchdog.check(basicBlock, basicBlock.getSub2());
                Statements<Statement> elseStatements = this.makeSubStatements(watchdog, basicBlock.getSub2(), statements, jumps);
                statements.add(new IfElseStatement(condition, subStatements, elseStatements));
                watchdog.check(basicBlock, basicBlock.getNext());
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                break;
            }
            case 262144: {
                this.parseByteCode(basicBlock, statements);
                break;
            }
            case 524288: {
                watchdog.check(basicBlock, basicBlock.getSub1());
                Expression exp1 = this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps);
                watchdog.check(basicBlock, basicBlock.getSub2());
                Expression exp2 = this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps);
                this.stack.push(new BinaryOperatorExpression(basicBlock.getFirstLineNumber(), PrimitiveType.TYPE_BOOLEAN, exp1, "||", exp2, 14));
                break;
            }
            case 0x100000: {
                watchdog.check(basicBlock, basicBlock.getSub1());
                Expression exp1 = this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps);
                watchdog.check(basicBlock, basicBlock.getSub2());
                Expression exp2 = this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps);
                this.stack.push(new BinaryOperatorExpression(basicBlock.getFirstLineNumber(), PrimitiveType.TYPE_BOOLEAN, exp1, "&&", exp2, 13));
                break;
            }
            case 0x200000: {
                watchdog.check(basicBlock, basicBlock.getCondition());
                this.makeStatements(watchdog, basicBlock.getCondition(), statements, jumps);
                Expression condition = this.stack.pop();
                DefaultStack<Expression> backup = new DefaultStack<Expression>(this.stack);
                watchdog.check(basicBlock, basicBlock.getSub1());
                Expression exp1 = this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps);
                if (this.stack.size() != backup.size()) {
                    this.stack.copy(backup);
                }
                watchdog.check(basicBlock, basicBlock.getSub2());
                Expression exp2 = this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps);
                this.stack.push(this.parseTernaryOperator(basicBlock.getFirstLineNumber(), condition, exp1, exp2));
                this.parseByteCode(basicBlock, statements);
                break;
            }
            case 0x20000000: {
                watchdog.check(basicBlock, basicBlock.getCondition());
                this.makeStatements(watchdog, basicBlock.getCondition(), statements, jumps);
                Expression condition = this.stack.pop();
                DefaultStack<Expression> backup = new DefaultStack<Expression>(this.stack);
                watchdog.check(basicBlock, basicBlock.getSub1());
                Expression exp1 = this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps);
                if (this.stack.size() != backup.size()) {
                    this.stack.copy(backup);
                }
                watchdog.check(basicBlock, basicBlock.getSub2());
                Expression exp2 = this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps);
                this.stack.push(this.parseTernaryOperator(basicBlock.getFirstLineNumber(), condition, exp1, exp2));
                watchdog.check(basicBlock, basicBlock.getNext());
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                break;
            }
            case 0x400000: {
                this.parseLoop(watchdog, basicBlock, statements, jumps);
                break;
            }
            case 0x800000: 
            case 0x1000000: {
                statements.add(ContinueStatement.CONTINUE);
                break;
            }
            case 0x2000000: {
                statements.add(BreakStatement.BREAK);
                break;
            }
            case 0x40000000: {
                ClassFileBreakContinueStatement jump = new ClassFileBreakContinueStatement(basicBlock.getFromOffset(), basicBlock.getToOffset());
                statements.add(jump);
                jumps.add(jump);
                break;
            }
            case 0x8000000: {
                statements.add(new WhileStatement(BooleanExpression.TRUE, null));
                break;
            }
            default: {
                assert (false) : "Unexpected basic block: " + basicBlock.getTypeName() + ':' + basicBlock.getIndex();
                break;
            }
        }
    }

    protected Statements<Statement> makeSubStatements(WatchDog watchdog, BasicBlock basicBlock, Statements<Statement> statements, Statements jumps, Statements<Statement> updateStatements) {
        Statements<Statement> subStatements = this.makeSubStatements(watchdog, basicBlock, statements, jumps);
        if (updateStatements != null) {
            subStatements.addAll(updateStatements);
        }
        return subStatements;
    }

    protected Statements<Statement> makeSubStatements(WatchDog watchdog, BasicBlock basicBlock, Statements<Statement> statements, Statements jumps) {
        Statements<Statement> subStatements = new Statements<Statement>();
        if (!statements.isEmpty() && ((Statement)statements.getLast()).getClass() == ClassFileMonitorEnterStatement.class) {
            subStatements.add(statements.removeLast());
        }
        this.localVariableMaker.pushFrame(subStatements);
        this.makeStatements(watchdog, basicBlock, subStatements, jumps);
        this.localVariableMaker.popFrame();
        this.replacePreOperatorWithPostOperator(subStatements);
        if (!subStatements.isEmpty() && ((Statement)subStatements.getFirst()).getClass() == ClassFileMonitorEnterStatement.class) {
            statements.add(subStatements.remove(0));
        }
        return subStatements;
    }

    protected Expression makeExpression(WatchDog watchdog, BasicBlock basicBlock, Statements<Statement> statements, Statements jumps) {
        BinaryOperatorExpression boe;
        Expression expr;
        Statement lastStatement;
        int initialStatementCount = statements.size();
        this.makeStatements(watchdog, basicBlock, statements, jumps);
        if (this.stack.isEmpty()) {
            return new StringConstantExpression("JD-Core does not support Kotlin");
        }
        Expression expression = this.stack.pop();
        if (statements.size() > initialStatementCount && (lastStatement = (Statement)statements.getLast()).getClass() == ExpressionStatement.class && (expr = ((ExpressionStatement)lastStatement).getExpression()).getClass() == BinaryOperatorExpression.class && (boe = (BinaryOperatorExpression)expr).getRightExpression() == expression) {
            statements.removeLast();
            expression = boe;
        }
        return expression;
    }

    protected void parseSwitch(WatchDog watchdog, BasicBlock basicBlock, Statements<Statement> statements, Statements jumps) {
        this.parseByteCode(basicBlock, statements);
        DefaultList<BasicBlock.SwitchCase> switchCases = basicBlock.getSwitchCases();
        SwitchStatement switchStatement = (SwitchStatement)statements.getLast();
        Expression condition = switchStatement.getCondition();
        Type conditionType = condition.getType();
        List<SwitchStatement.Block> blocks = switchStatement.getBlocks();
        DefaultStack<Expression> localStack = new DefaultStack<Expression>(this.stack);
        switchCases.sort(SWITCH_CASE_COMPARATOR);
        int len = switchCases.size();
        for (int i = 0; i < len; ++i) {
            int j;
            BasicBlock.SwitchCase sc = (BasicBlock.SwitchCase)switchCases.get(i);
            BasicBlock bb = sc.getBasicBlock();
            for (j = i + 1; j < len && bb == ((BasicBlock.SwitchCase)switchCases.get(j)).getBasicBlock(); ++j) {
            }
            Statements subStatements = new Statements();
            this.stack.copy(localStack);
            this.makeStatements(watchdog, bb, subStatements, jumps);
            this.replacePreOperatorWithPostOperator(subStatements);
            if (sc.isDefaultCase()) {
                blocks.add(new SwitchStatement.LabelBlock(SwitchStatement.DEFAULT_LABEL, subStatements));
                continue;
            }
            if (j == i + 1) {
                SwitchStatement.ExpressionLabel label = new SwitchStatement.ExpressionLabel(new IntegerConstantExpression(conditionType, sc.getValue()));
                blocks.add(new SwitchStatement.LabelBlock(label, subStatements));
                continue;
            }
            DefaultList<SwitchStatement.Label> labels = new DefaultList<SwitchStatement.Label>(j - i);
            while (i < j) {
                labels.add(new SwitchStatement.ExpressionLabel(new IntegerConstantExpression(conditionType, ((BasicBlock.SwitchCase)switchCases.get(i)).getValue())));
                ++i;
            }
            blocks.add(new SwitchStatement.MultiLabelsBlock(labels, subStatements));
            --i;
        }
        int size = statements.size();
        Class<?> conditionClass = condition.getClass();
        if (size > 3 && conditionClass == ClassFileLocalVariableReferenceExpression.class && ((Statement)statements.get(size - 2)).getClass() == SwitchStatement.class) {
            SwitchStatementMaker.makeSwitchString(this.localVariableMaker, statements, switchStatement);
        } else if (this.bodyDeclaration.getInnerTypeDeclarations() != null && conditionClass == ArrayExpression.class) {
            SwitchStatementMaker.makeSwitchEnum(this.bodyDeclaration, switchStatement);
        }
        this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
    }

    protected void parseTry(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps, boolean jsr, boolean eclipse) {
        DefaultList<TryStatement.CatchClause> catchClauses = new DefaultList<TryStatement.CatchClause>();
        Statements<Statement> finallyStatements = null;
        int assertStackSize = this.stack.size();
        Statements<Statement> tryStatements = this.makeSubStatements(watchdog, basicBlock.getSub1(), statements, jumps);
        for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
            assert (this.stack.size() == assertStackSize) : "parseTry : problem with stack";
            if (exceptionHandler.getInternalThrowableName() == null) {
                BinaryOperatorExpression boe;
                Expression expression;
                this.stack.push(FINALLY_EXCEPTION_EXPRESSION);
                finallyStatements = this.makeSubStatements(watchdog, exceptionHandler.getBasicBlock(), statements, jumps);
                if (((Statement)finallyStatements.get(0)).getClass() == ClassFileMonitorExitStatement.class) continue;
                this.removeFinallyStatementsFlag |= !jsr;
                Statement statement = (Statement)finallyStatements.getFirst();
                if (statement.getClass() == ExpressionStatement.class && (expression = ((ExpressionStatement)statement).getExpression()).getClass() == BinaryOperatorExpression.class && (boe = (BinaryOperatorExpression)expression).getLeftExpression().getClass() == ClassFileLocalVariableReferenceExpression.class && (statement = (Statement)finallyStatements.getLast()).getClass() == ThrowStatement.class && (expression = ((ThrowStatement)statement).getExpression()).getClass() == ClassFileLocalVariableReferenceExpression.class) {
                    ClassFileLocalVariableReferenceExpression vre1 = (ClassFileLocalVariableReferenceExpression)expression;
                    ClassFileLocalVariableReferenceExpression vre2 = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
                    if (vre1.getLocalVariable() == vre2.getLocalVariable()) {
                        this.localVariableMaker.removeLocalVariable(vre2.getLocalVariable());
                        finallyStatements.remove(0);
                    }
                }
                finallyStatements.removeLast();
                continue;
            }
            this.stack.push(new NullExpression(this.objectTypeMaker.make(exceptionHandler.getInternalThrowableName())));
            Statements catchStatements = new Statements();
            this.localVariableMaker.pushFrame(catchStatements);
            BasicBlock bb = exceptionHandler.getBasicBlock();
            int lineNumber = bb.getControlFlowGraph().getLineNumber(bb.getFromOffset());
            int index = ByteCodeParser.getExceptionLocalVariableIndex(bb);
            ObjectType ot = this.objectTypeMaker.make(exceptionHandler.getInternalThrowableName());
            int offset = bb.getFromOffset();
            byte[] code = ((AttributeCode)bb.getControlFlowGraph().getMethod().getAttribute("Code")).getCode();
            offset = code[offset] == 58 ? (offset += 2) : ++offset;
            AbstractLocalVariable exception = this.localVariableMaker.getExceptionLocalVariable(index, offset, ot);
            this.makeStatements(watchdog, bb, catchStatements, jumps);
            this.localVariableMaker.popFrame();
            this.removeExceptionReference(catchStatements);
            if (lineNumber != 0) {
                this.searchFirstLineNumberVisitor.init();
                this.searchFirstLineNumberVisitor.visit(catchStatements);
                if (this.searchFirstLineNumberVisitor.getLineNumber() == lineNumber) {
                    lineNumber = 0;
                }
            }
            this.replacePreOperatorWithPostOperator(catchStatements);
            ClassFileTryStatement.CatchClause cc = new ClassFileTryStatement.CatchClause(lineNumber, ot, exception, catchStatements);
            if (exceptionHandler.getOtherInternalThrowableNames() != null) {
                for (String name : exceptionHandler.getOtherInternalThrowableNames()) {
                    cc.addType(this.objectTypeMaker.make(name));
                }
            }
            catchClauses.add(cc);
        }
        Statement statement = null;
        if (finallyStatements != null && finallyStatements.size() > 0 && ((Statement)finallyStatements.get(0)).getClass() == ClassFileMonitorExitStatement.class) {
            statement = SynchronizedStatementMaker.make(this.localVariableMaker, statements, tryStatements);
        } else {
            if (this.majorVersion >= 51) {
                assert (!jsr);
                statement = TryWithResourcesStatementMaker.make(this.localVariableMaker, statements, tryStatements, catchClauses, finallyStatements);
            }
            if (statement == null) {
                statement = new ClassFileTryStatement(tryStatements, catchClauses, finallyStatements, jsr, eclipse);
            } else {
                this.mergeTryWithResourcesStatementFlag = true;
            }
        }
        statements.add(statement);
        this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
    }

    protected void removeExceptionReference(Statements catchStatements) {
        if (catchStatements.size() > 0 && catchStatements.get(0).getClass() == ExpressionStatement.class) {
            ExpressionStatement es = (ExpressionStatement)catchStatements.get(0);
            if (es.getExpression().getClass() == BinaryOperatorExpression.class) {
                BinaryOperatorExpression boe = (BinaryOperatorExpression)es.getExpression();
                if (boe.getLeftExpression().getClass() == ClassFileLocalVariableReferenceExpression.class && boe.getRightExpression().getClass() == NullExpression.class) {
                    catchStatements.remove(0);
                }
            } else if (es.getExpression().getClass() == NullExpression.class) {
                catchStatements.remove(0);
            }
        }
    }

    protected void parseJSR(WatchDog watchdog, BasicBlock basicBlock, Statements<Statement> statements, Statements jumps) {
        int statementCount = statements.size();
        this.parseByteCode(basicBlock, statements);
        this.makeStatements(watchdog, basicBlock.getBranch(), statements, jumps);
        this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
        ExpressionStatement es = (ExpressionStatement)statements.get(statementCount);
        BinaryOperatorExpression boe = (BinaryOperatorExpression)es.getExpression();
        ClassFileLocalVariableReferenceExpression vre = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
        this.localVariableMaker.removeLocalVariable(vre.getLocalVariable());
        statements.remove(statementCount);
    }

    protected void parseIf(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        BasicBlock condition = basicBlock.getCondition();
        if (condition.getType() == 0x100000) {
            condition = condition.getSub1();
        }
        if (ByteCodeParser.isAssertCondition(this.internalTypeName, condition)) {
            BaseExpression parameters;
            Expression e;
            Expression cond;
            if (condition == basicBlock.getCondition()) {
                cond = new BooleanExpression(condition.getFirstLineNumber(), false);
            } else {
                condition = basicBlock.getCondition().getSub2();
                condition.inverseCondition();
                this.makeStatements(watchdog, condition, statements, jumps);
                cond = this.stack.pop();
            }
            Statements<Statement> subStatements = this.makeSubStatements(watchdog, basicBlock.getSub1(), statements, jumps);
            Expression message = null;
            if (subStatements.get(0).getClass() == ThrowStatement.class && (e = ((ThrowStatement)subStatements.get(0)).getExpression()).getClass() == NewExpression.class && (parameters = ((NewExpression)e).getParameters()) != null && !parameters.isList()) {
                message = (Expression)parameters.getFirst();
            }
            statements.add(new AssertStatement(cond, message));
            this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
        } else {
            this.makeStatements(watchdog, basicBlock.getCondition(), statements, jumps);
            Expression cond = this.stack.pop();
            DefaultStack<Expression> backup = new DefaultStack<Expression>(this.stack);
            Statements<Statement> subStatements = this.makeSubStatements(watchdog, basicBlock.getSub1(), statements, jumps);
            if (this.stack.size() != backup.size()) {
                this.stack.copy(backup);
            }
            statements.add(new IfStatement(cond, subStatements));
            int index = statements.size();
            this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
            if (subStatements.size() == 1 && index + 1 == statements.size() && subStatements.get(0).getClass() == ReturnExpressionStatement.class && statements.get(index).getClass() == ReturnExpressionStatement.class) {
                ReturnExpressionStatement cfres1 = (ReturnExpressionStatement)subStatements.get(0);
                if (cond.getLineNumber() >= cfres1.getLineNumber()) {
                    ReturnExpressionStatement cfres2 = (ReturnExpressionStatement)statements.get(index);
                    if (cfres1.getLineNumber() == cfres2.getLineNumber()) {
                        statements.subList(index - 1, statements.size()).clear();
                        statements.add(new ReturnExpressionStatement(new TernaryOperatorExpression(cfres1.getLineNumber(), cond, cfres1.getExpression(), cfres2.getExpression())));
                    }
                }
            }
        }
    }

    protected void parseLoop(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        BasicBlock sub1 = basicBlock.getSub1();
        Statements<Statement> updateStatements = null;
        if (sub1.getType() == 65536 && sub1.getCondition() == BasicBlock.END) {
            updateStatements = this.makeSubStatements(watchdog, sub1.getNext(), statements, jumps);
            sub1 = sub1.getSub1();
        }
        if (sub1.getType() == 65536) {
            BasicBlock ifBB = sub1;
            if (ifBB.getNext() == BasicBlock.LOOP_END) {
                this.makeStatements(watchdog, ifBB.getCondition(), statements, jumps);
                statements.add(LoopStatementMaker.makeLoop(this.localVariableMaker, basicBlock, statements, this.stack.pop(), this.makeSubStatements(watchdog, ifBB.getSub1(), statements, jumps, updateStatements), jumps));
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                return;
            }
            if (ifBB.getSub1() == BasicBlock.LOOP_END) {
                if (ifBB.getNext() == BasicBlock.LOOP_START) {
                    ifBB.getCondition().inverseCondition();
                    Statements subStatements = new Statements();
                    this.makeStatements(watchdog, ifBB.getCondition(), subStatements, jumps);
                    this.replacePreOperatorWithPostOperator(subStatements);
                    statements.add(LoopStatementMaker.makeDoWhileLoop(basicBlock, ifBB, this.stack.pop(), subStatements, jumps));
                } else {
                    ifBB.getCondition().inverseCondition();
                    this.makeStatements(watchdog, ifBB.getCondition(), statements, jumps);
                    statements.add(LoopStatementMaker.makeLoop(this.localVariableMaker, basicBlock, statements, this.stack.pop(), this.makeSubStatements(watchdog, ifBB.getNext(), statements, jumps, updateStatements), jumps));
                }
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                return;
            }
        }
        BasicBlock next = sub1.getNext();
        BasicBlock last = sub1;
        while (next.matchType(876822149) && next.getPredecessors().size() == 1) {
            last = next;
            next = next.getNext();
        }
        if (next == BasicBlock.LOOP_START && last.getType() == 65536 && last.getSub1() == BasicBlock.LOOP_END && this.countStartLoop(sub1) == 1) {
            Statements<Statement> subStatements;
            last.getCondition().inverseCondition();
            last.setType(2);
            if (sub1.getType() == 0x400000 && sub1.getNext() == last && this.countStartLoop(sub1.getSub1()) == 0) {
                StatementMaker.changeEndLoopToStartLoop(new BitSet(), sub1.getSub1());
                subStatements = this.makeSubStatements(watchdog, sub1.getSub1(), statements, jumps, updateStatements);
                assert (subStatements.getLast() == ContinueStatement.CONTINUE);
                subStatements.removeLast();
            } else {
                this.createDoWhileContinue(last);
                subStatements = this.makeSubStatements(watchdog, sub1, statements, jumps, updateStatements);
            }
            this.makeStatements(watchdog, last.getCondition(), subStatements, jumps);
            statements.add(LoopStatementMaker.makeDoWhileLoop(basicBlock, last, this.stack.pop(), subStatements, jumps));
        } else {
            statements.add(LoopStatementMaker.makeLoop(basicBlock, statements, this.makeSubStatements(watchdog, sub1, statements, jumps, updateStatements), jumps));
        }
        this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
    }

    protected int countStartLoop(BasicBlock bb) {
        int count = 0;
        while (bb.matchType(876822149)) {
            switch (bb.getType()) {
                case 128: {
                    for (BasicBlock.SwitchCase switchCase : bb.getSwitchCases()) {
                        count += this.countStartLoop(switchCase.getBasicBlock());
                    }
                    break;
                }
                case 1024: 
                case 2048: 
                case 4096: {
                    count += this.countStartLoop(bb.getSub1());
                    for (BasicBlock.ExceptionHandler exceptionHandler : bb.getExceptionHandlers()) {
                        count += this.countStartLoop(exceptionHandler.getBasicBlock());
                    }
                    break;
                }
                case 131072: 
                case 0x20000000: {
                    count += this.countStartLoop(bb.getSub2());
                }
                case 65536: {
                    count += this.countStartLoop(bb.getSub1());
                }
            }
            bb = bb.getNext();
        }
        if (bb.getType() == 0x800000) {
            ++count;
        }
        return count;
    }

    protected void createDoWhileContinue(BasicBlock last) {
        boolean change;
        do {
            change = false;
            for (BasicBlock predecessor : last.getPredecessors()) {
                BasicBlock l;
                if (predecessor.getType() != 65536 || !(l = predecessor.getSub1()).matchType(876822149)) continue;
                BasicBlock n = l.getNext();
                while (n.matchType(876822149)) {
                    l = n;
                    n = n.getNext();
                }
                if (n != BasicBlock.END) continue;
                predecessor.getCondition().inverseCondition();
                predecessor.setNext(predecessor.getSub1());
                last.getPredecessors().remove(predecessor);
                last.getPredecessors().add(l);
                l.setNext(last);
                predecessor.setSub1(BasicBlock.LOOP_START);
                change = true;
            }
        } while (change);
    }

    protected static void changeEndLoopToStartLoop(BitSet visited, BasicBlock basicBlock) {
        if (!basicBlock.matchType(1266696506) && !visited.get(basicBlock.getIndex())) {
            visited.set(basicBlock.getIndex());
            switch (basicBlock.getType()) {
                case 8192: 
                case 32768: 
                case 262144: {
                    if (basicBlock.getBranch() == BasicBlock.LOOP_END) {
                        basicBlock.setBranch(BasicBlock.LOOP_START);
                    } else {
                        StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getBranch());
                    }
                }
                case 1: 
                case 4: 
                case 0x400000: 
                case 0x4000000: 
                case 0x10000000: {
                    if (basicBlock.getNext() == BasicBlock.LOOP_END) {
                        basicBlock.setNext(BasicBlock.LOOP_START);
                        break;
                    }
                    StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getNext());
                    break;
                }
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: {
                    for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                        if (exceptionHandler.getBasicBlock() == BasicBlock.LOOP_END) {
                            exceptionHandler.setBasicBlock(BasicBlock.LOOP_START);
                            continue;
                        }
                        StatementMaker.changeEndLoopToStartLoop(visited, exceptionHandler.getBasicBlock());
                    }
                    break;
                }
                case 131072: 
                case 0x20000000: {
                    if (basicBlock.getSub2() == BasicBlock.LOOP_END) {
                        basicBlock.setSub2(BasicBlock.LOOP_START);
                    } else {
                        StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getSub2());
                    }
                }
                case 65536: {
                    if (basicBlock.getSub1() == BasicBlock.LOOP_END) {
                        basicBlock.setSub1(BasicBlock.LOOP_START);
                    } else {
                        StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getSub1());
                    }
                    if (basicBlock.getNext() == BasicBlock.LOOP_END) {
                        basicBlock.setNext(BasicBlock.LOOP_START);
                        break;
                    }
                    StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getNext());
                    break;
                }
                case 64: 
                case 128: {
                    for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
                        if (switchCase.getBasicBlock() == BasicBlock.LOOP_END) {
                            switchCase.setBasicBlock(BasicBlock.LOOP_START);
                            continue;
                        }
                        StatementMaker.changeEndLoopToStartLoop(visited, switchCase.getBasicBlock());
                    }
                    break;
                }
            }
        }
    }

    protected Expression parseTernaryOperator(int lineNumber, Expression condition, Expression exp1, Expression exp2) {
        String fieldName;
        FieldReferenceExpression freCond;
        BinaryOperatorExpression boeCond;
        if (exp1.getType() == ObjectType.TYPE_CLASS && exp2.getType() == ObjectType.TYPE_CLASS && condition.getClass() == BinaryOperatorExpression.class && (boeCond = (BinaryOperatorExpression)condition).getLeftExpression().getClass() == FieldReferenceExpression.class && boeCond.getRightExpression().getClass() == NullExpression.class && (freCond = (FieldReferenceExpression)boeCond.getLeftExpression()).getInternalTypeName().equals(this.internalTypeName) && (fieldName = freCond.getName()).startsWith("class$")) {
            MethodInvocationExpression mie;
            BinaryOperatorExpression boe2;
            if (boeCond.getOperator().equals("==") && exp1.getClass() == BinaryOperatorExpression.class && this.checkFieldReference(fieldName, exp2)) {
                MethodInvocationExpression mie2;
                BinaryOperatorExpression boe1 = (BinaryOperatorExpression)exp1;
                if (boe1.getRightExpression().getClass() == MethodInvocationExpression.class && this.checkFieldReference(fieldName, boe1.getLeftExpression()) && (mie2 = (MethodInvocationExpression)boe1.getRightExpression()).getParameters().getClass() == StringConstantExpression.class && mie2.getName().equals("class$") && mie2.getInternalTypeName().equals(this.internalTypeName)) {
                    return this.createObjectTypeReferenceDotClassExpression(lineNumber, fieldName, mie2);
                }
            } else if (boeCond.getOperator().equals("!=") && exp2.getClass() == BinaryOperatorExpression.class && this.checkFieldReference(fieldName, exp1) && (boe2 = (BinaryOperatorExpression)exp2).getRightExpression().getClass() == MethodInvocationExpression.class && this.checkFieldReference(fieldName, boe2.getLeftExpression()) && (mie = (MethodInvocationExpression)boe2.getRightExpression()).getParameters().getClass() == StringConstantExpression.class && mie.getName().equals("class$") && mie.getInternalTypeName().equals(this.internalTypeName)) {
                return this.createObjectTypeReferenceDotClassExpression(lineNumber, fieldName, mie);
            }
        }
        return new TernaryOperatorExpression(lineNumber, condition, exp1, exp2);
    }

    protected boolean checkFieldReference(String fieldName, Expression expression) {
        if (expression.getClass() != FieldReferenceExpression.class) {
            return false;
        }
        FieldReferenceExpression fre = (FieldReferenceExpression)expression;
        return fre.getName().equals(fieldName) && fre.getInternalTypeName().equals(this.internalTypeName);
    }

    protected Expression createObjectTypeReferenceDotClassExpression(int lineNumber, String fieldName, MethodInvocationExpression mie) {
        this.memberVisitor.init(fieldName);
        for (ClassFileFieldDeclaration field : this.bodyDeclaration.getFieldDeclarations()) {
            field.getFieldDeclarators().accept(this.memberVisitor);
            if (!this.memberVisitor.isFound()) continue;
            field.setFlags(field.getFlags() | 0x1000);
            break;
        }
        this.memberVisitor.init("class$");
        for (ClassFileConstructorOrMethodDeclaration member : this.bodyDeclaration.getMethodDeclarations()) {
            member.accept(this.memberVisitor);
            if (!this.memberVisitor.isFound()) continue;
            member.setFlags(member.getFlags() | 0x1000);
            break;
        }
        String typeName = ((StringConstantExpression)mie.getParameters()).getString();
        ObjectType ot = this.objectTypeMaker.make(typeName.replace('.', '/'));
        return new TypeReferenceDotClassExpression(lineNumber, ot);
    }

    protected void parseByteCode(BasicBlock basicBlock, Statements<Statement> statements) {
        this.byteCodeParser.parse(basicBlock, statements, this.stack);
    }

    protected void replacePreOperatorWithPostOperator(Statements statements) {
        for (Statement statement : statements) {
            PreOperatorExpression poe;
            String operator;
            ExpressionStatement cfes;
            if (statement.getClass() != ExpressionStatement.class || (cfes = (ExpressionStatement)statement).getExpression().getClass() != PreOperatorExpression.class || !"++".equals(operator = (poe = (PreOperatorExpression)cfes.getExpression()).getOperator()) && !"--".equals(operator)) continue;
            cfes.setExpression(new PostOperatorExpression(poe.getLineNumber(), poe.getExpression(), operator));
        }
    }

    protected void updateJumpStatements(Statements jumps) {
        assert (false) : "'jumps' list is not empty";
        for (ClassFileBreakContinueStatement statement : jumps) {
            statement.setStatement(new CommentStatement("// Byte code: goto -> " + statement.getTargetOffset()));
        }
    }

    protected static class NopBitSet
    extends BitSet {
        protected NopBitSet() {
        }

        @Override
        public boolean get(int var1) {
            return false;
        }

        @Override
        public void set(int var1) {
        }
    }

    protected static class MemberVisitor
    extends AbstractJavaSyntaxVisitor {
        protected String name;
        protected boolean found;

        protected MemberVisitor() {
        }

        public void init(String name) {
            this.name = name;
            this.found = false;
        }

        public boolean isFound() {
            return this.found;
        }

        @Override
        public void visit(FieldDeclarator declaration) {
            this.found |= declaration.getName().equals(this.name);
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.found |= declaration.getName().equals(this.name);
        }
    }

    protected static class SwitchCaseComparator
    implements Comparator<BasicBlock.SwitchCase> {
        protected SwitchCaseComparator() {
        }

        @Override
        public int compare(BasicBlock.SwitchCase sc1, BasicBlock.SwitchCase sc2) {
            int diff = sc1.getOffset() - sc2.getOffset();
            if (diff != 0) {
                return diff;
            }
            return sc1.getValue() - sc2.getValue();
        }
    }
}

