/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.visitors.regions.IRegionIterativeVisitor;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.InsnList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TernaryMod
implements IRegionIterativeVisitor {
    @Override
    public boolean visitRegion(MethodNode mth, IRegion region) {
        if (region instanceof IfRegion) {
            return TernaryMod.makeTernaryInsn(mth, (IfRegion)region);
        }
        return false;
    }

    private static boolean makeTernaryInsn(MethodNode mth, IfRegion ifRegion) {
        if (ifRegion.contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        IContainer thenRegion = ifRegion.getThenRegion();
        IContainer elseRegion = ifRegion.getElseRegion();
        if (thenRegion == null || elseRegion == null) {
            return false;
        }
        BlockNode tb = TernaryMod.getTernaryInsnBlock(thenRegion);
        BlockNode eb = TernaryMod.getTernaryInsnBlock(elseRegion);
        if (tb == null || eb == null) {
            return false;
        }
        List<BlockNode> conditionBlocks = ifRegion.getConditionBlocks();
        if (conditionBlocks.isEmpty()) {
            return false;
        }
        BlockNode header = conditionBlocks.get(0);
        InsnNode thenInsn = tb.getInstructions().get(0);
        InsnNode elseInsn = eb.getInstructions().get(0);
        if (thenInsn.getSourceLine() != elseInsn.getSourceLine() && (thenInsn.getSourceLine() != 0 && elseInsn.getSourceLine() != 0 ? !TernaryMod.checkLineStats(thenInsn, elseInsn) : TernaryMod.containsTernary(thenInsn) || TernaryMod.containsTernary(elseInsn))) {
            return false;
        }
        RegisterArg thenResArg = thenInsn.getResult();
        RegisterArg elseResArg = elseInsn.getResult();
        if (thenResArg != null && elseResArg != null) {
            RegisterArg resArg;
            PhiInsn thenPhi = thenResArg.getSVar().getOnlyOneUseInPhi();
            PhiInsn elsePhi = elseResArg.getSVar().getOnlyOneUseInPhi();
            if (thenPhi == null || thenPhi != elsePhi) {
                return false;
            }
            if (!ifRegion.getParent().replaceSubBlock(ifRegion, header)) {
                return false;
            }
            InsnList.remove(tb, thenInsn);
            InsnList.remove(eb, elseInsn);
            if (thenPhi.getArgsCount() == 2) {
                resArg = thenPhi.getResult();
            } else {
                resArg = thenResArg;
                thenPhi.removeArg(elseResArg);
            }
            TernaryInsn ternInsn = new TernaryInsn(ifRegion.getCondition(), resArg, InsnArg.wrapArg(thenInsn), InsnArg.wrapArg(elseInsn));
            ternInsn.setSourceLine(thenInsn.getSourceLine());
            header.getInstructions().clear();
            header.getInstructions().add(ternInsn);
            TernaryMod.clearConditionBlocks(conditionBlocks, header);
            CodeShrinkVisitor.shrinkMethod(mth);
            return true;
        }
        if (!mth.getReturnType().equals(ArgType.VOID) && thenInsn.getType() == InsnType.RETURN && elseInsn.getType() == InsnType.RETURN) {
            InsnArg thenArg = thenInsn.getArg(0);
            InsnArg elseArg = elseInsn.getArg(0);
            if (thenArg.isLiteral() != elseArg.isLiteral()) {
                return false;
            }
            if (!ifRegion.getParent().replaceSubBlock(ifRegion, header)) {
                return false;
            }
            InsnList.remove(tb, thenInsn);
            InsnList.remove(eb, elseInsn);
            tb.remove(AFlag.RETURN);
            eb.remove(AFlag.RETURN);
            TernaryInsn ternInsn = new TernaryInsn(ifRegion.getCondition(), null, thenArg, elseArg);
            ternInsn.setSourceLine(thenInsn.getSourceLine());
            InsnNode retInsn = new InsnNode(InsnType.RETURN, 1);
            retInsn.addArg(InsnArg.wrapArg(ternInsn));
            header.getInstructions().clear();
            header.getInstructions().add(retInsn);
            header.add(AFlag.RETURN);
            TernaryMod.clearConditionBlocks(conditionBlocks, header);
            CodeShrinkVisitor.shrinkMethod(mth);
            return true;
        }
        return false;
    }

    private static void clearConditionBlocks(List<BlockNode> conditionBlocks, BlockNode header) {
        for (BlockNode block : conditionBlocks) {
            if (block == header) continue;
            block.getInstructions().clear();
            block.add(AFlag.REMOVE);
        }
    }

    private static BlockNode getTernaryInsnBlock(IContainer thenRegion) {
        BlockNode block;
        IContainer container;
        Region r;
        if (thenRegion instanceof Region && (r = (Region)thenRegion).getSubBlocks().size() == 1 && (container = r.getSubBlocks().get(0)) instanceof BlockNode && (block = (BlockNode)container).getInstructions().size() == 1) {
            return block;
        }
        return null;
    }

    private static boolean containsTernary(InsnNode insn) {
        if (insn.getType() == InsnType.TERNARY) {
            return true;
        }
        for (int i = 0; i < insn.getArgsCount(); ++i) {
            InsnNode wrapInsn;
            InsnArg arg = insn.getArg(i);
            if (!arg.isInsnWrap() || !TernaryMod.containsTernary(wrapInsn = ((InsnWrapArg)arg).getWrapInsn())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkLineStats(InsnNode t, InsnNode e) {
        if (t.getResult() == null || e.getResult() == null) {
            return false;
        }
        PhiInsn tPhi = t.getResult().getSVar().getOnlyOneUseInPhi();
        PhiInsn ePhi = e.getResult().getSVar().getOnlyOneUseInPhi();
        if (ePhi == null || tPhi != ePhi) {
            return false;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(tPhi.getArgsCount());
        for (InsnArg insnArg : tPhi.getArguments()) {
            int sourceLine;
            InsnNode assignInsn;
            if (!insnArg.isRegister() || (assignInsn = ((RegisterArg)insnArg).getAssignInsn()) == null || (sourceLine = assignInsn.getSourceLine()) == 0) continue;
            map.merge(sourceLine, 1, Integer::sum);
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() < 2) continue;
            return true;
        }
        return false;
    }
}

