/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.ClassModifier;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.regions.variables.ProcessVariables;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.exceptions.JadxException;
import java.util.Iterator;
import java.util.List;

@JadxVisitor(name="PrepareForCodeGen", desc="Prepare instructions for code generation pass", runAfter={CodeShrinkVisitor.class, ClassModifier.class, ProcessVariables.class})
public class PrepareForCodeGen
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        List<BlockNode> blocks = mth.getBasicBlocks();
        if (blocks == null) {
            return;
        }
        for (BlockNode block : blocks) {
            if (block.contains(AFlag.DONT_GENERATE)) continue;
            PrepareForCodeGen.removeInstructions(block);
            PrepareForCodeGen.checkInline(block);
            PrepareForCodeGen.removeParenthesis(block);
            PrepareForCodeGen.modifyArith(block);
        }
    }

    private static void removeInstructions(BlockNode block) {
        Iterator<InsnNode> it = block.getInstructions().iterator();
        while (it.hasNext()) {
            InsnNode insn = it.next();
            switch (insn.getType()) {
                case NOP: 
                case MONITOR_ENTER: 
                case MONITOR_EXIT: 
                case MOVE_EXCEPTION: {
                    it.remove();
                    break;
                }
                case CONSTRUCTOR: {
                    ConstructorInsn co = (ConstructorInsn)insn;
                    if (!co.isSelf()) break;
                    it.remove();
                    break;
                }
                case MOVE: {
                    RegisterArg result = insn.getResult();
                    if (result.getSVar().getUseCount() != 0 || !result.isNameEquals(insn.getArg(0))) break;
                    it.remove();
                    break;
                }
            }
        }
    }

    private static void checkInline(BlockNode block) {
        List<InsnNode> list = block.getInstructions();
        for (int i = 0; i < list.size(); ++i) {
            InsnNode insn = list.get(i);
            if (insn.getType() != InsnType.MOVE || !insn.getArg(0).isInsnWrap()) continue;
            InsnNode wrapInsn = ((InsnWrapArg)insn.getArg(0)).getWrapInsn();
            wrapInsn.setResult(insn.getResult());
            wrapInsn.copyAttributesFrom(insn);
            list.set(i, wrapInsn);
        }
    }

    private static void removeParenthesis(BlockNode block) {
        for (InsnNode insn : block.getInstructions()) {
            PrepareForCodeGen.removeParenthesis(insn);
        }
    }

    private static void removeParenthesis(InsnNode insn) {
        block5: {
            block4: {
                if (insn.getType() != InsnType.ARITH) break block4;
                ArithNode arith = (ArithNode)insn;
                ArithOp op = arith.getOp();
                if (op != ArithOp.ADD && op != ArithOp.MUL && op != ArithOp.AND && op != ArithOp.OR) break block5;
                for (int i = 0; i < 2; ++i) {
                    InsnArg arg = arith.getArg(i);
                    if (!arg.isInsnWrap()) continue;
                    InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
                    if (wrapInsn.getType() == InsnType.ARITH && ((ArithNode)wrapInsn).getOp() == op) {
                        wrapInsn.add(AFlag.DONT_WRAP);
                    }
                    PrepareForCodeGen.removeParenthesis(wrapInsn);
                }
                break block5;
            }
            if (insn.getType() == InsnType.TERNARY) {
                PrepareForCodeGen.removeParenthesis(((TernaryInsn)insn).getCondition());
            }
            for (InsnArg arg : insn.getArguments()) {
                if (!arg.isInsnWrap()) continue;
                InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
                PrepareForCodeGen.removeParenthesis(wrapInsn);
            }
        }
    }

    private static void removeParenthesis(IfCondition cond) {
        IfCondition.Mode mode = cond.getMode();
        for (IfCondition c : cond.getArgs()) {
            if (c.getMode() != mode) continue;
            c.add(AFlag.DONT_WRAP);
        }
    }

    private static void modifyArith(BlockNode block) {
        List<InsnNode> list = block.getInstructions();
        for (InsnNode insn : list) {
            if (insn.getType() != InsnType.ARITH || insn.contains(AFlag.DECLARE_VAR)) continue;
            RegisterArg res = insn.getResult();
            InsnArg arg = insn.getArg(0);
            boolean replace = false;
            if (res.equals(arg)) {
                replace = true;
            } else if (arg.isRegister()) {
                RegisterArg regArg = (RegisterArg)arg;
                replace = res.sameCodeVar(regArg);
            }
            if (!replace) continue;
            insn.add(AFlag.ARITH_ONEARG);
        }
    }
}

