/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.MarkFinallyVisitor;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.dex.visitors.typeinference.TypeInferenceVisitor;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayList;
import java.util.List;

@JadxVisitor(name="Constants Inline", desc="Inline constant registers into instructions", runAfter={SSATransform.class, MarkFinallyVisitor.class}, runBefore={TypeInferenceVisitor.class})
public class ConstInlineVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        ArrayList<InsnNode> toRemove = new ArrayList<InsnNode>();
        for (BlockNode block : mth.getBasicBlocks()) {
            toRemove.clear();
            for (InsnNode insn : block.getInstructions()) {
                ConstInlineVisitor.checkInsn(mth, insn, toRemove);
            }
            InsnRemover.removeAllAndUnbind(mth, block, toRemove);
        }
    }

    private static void checkInsn(MethodNode mth, InsnNode insn, List<InsnNode> toRemove) {
        if (insn.contains(AFlag.DONT_INLINE) || insn.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        InsnType insnType = insn.getType();
        if (insnType != InsnType.CONST && insnType != InsnType.MOVE) {
            return;
        }
        InsnArg arg = insn.getArg(0);
        if (!arg.isLiteral()) {
            return;
        }
        long lit = ((LiteralArg)arg).getLiteral();
        SSAVar sVar = insn.getResult().getSVar();
        if (lit == 0L && ConstInlineVisitor.checkObjectInline(sVar)) {
            InsnNode assignInsn;
            if (sVar.getUseCount() == 1 && (assignInsn = insn.getResult().getAssignInsn()) != null) {
                assignInsn.add(AFlag.DONT_INLINE);
            }
            return;
        }
        if (ConstInlineVisitor.checkForFinallyBlock(sVar)) {
            return;
        }
        ConstInlineVisitor.replaceConst(mth, insn, lit, toRemove);
    }

    private static boolean checkForFinallyBlock(SSAVar sVar) {
        List<SSAVar> ssaVars = sVar.getCodeVar().getSsaVars();
        if (ssaVars.size() <= 1) {
            return false;
        }
        int countInsns = 0;
        int countFinallyInsns = 0;
        for (SSAVar ssaVar : ssaVars) {
            for (RegisterArg reg : ssaVar.getUseList()) {
                InsnNode parentInsn = reg.getParentInsn();
                if (parentInsn == null) continue;
                ++countInsns;
                if (!parentInsn.contains(AFlag.FINALLY_INSNS)) continue;
                ++countFinallyInsns;
            }
        }
        return countFinallyInsns != 0 && countFinallyInsns != countInsns;
    }

    private static boolean checkObjectInline(SSAVar sVar) {
        for (RegisterArg useArg : sVar.getUseList()) {
            InvokeNode inv;
            InsnType insnType;
            InsnNode insn = useArg.getParentInsn();
            if (insn == null || !((insnType = insn.getType()) == InsnType.INVOKE ? (inv = (InvokeNode)insn).getInvokeType() != InvokeType.STATIC && inv.getArg(0) == useArg : insnType == InsnType.ARRAY_LENGTH && insn.getArg(0) == useArg)) continue;
            return true;
        }
        return false;
    }

    private static int replaceConst(MethodNode mth, InsnNode constInsn, long literal, List<InsnNode> toRemove) {
        SSAVar ssaVar = constInsn.getResult().getSVar();
        ArrayList<RegisterArg> useList = new ArrayList<RegisterArg>(ssaVar.getUseList());
        int replaceCount = 0;
        for (RegisterArg arg : useList) {
            if (!ConstInlineVisitor.replaceArg(mth, arg, literal, constInsn, toRemove)) continue;
            ++replaceCount;
        }
        if (replaceCount == useList.size()) {
            toRemove.add(constInsn);
        }
        return replaceCount;
    }

    private static boolean replaceArg(MethodNode mth, RegisterArg arg, long literal, InsnNode constInsn, List<InsnNode> toRemove) {
        LiteralArg litArg;
        InsnNode useInsn = arg.getParentInsn();
        if (useInsn == null) {
            return false;
        }
        InsnType insnType = useInsn.getType();
        if (insnType == InsnType.PHI) {
            return false;
        }
        ArgType argType = arg.getInitType();
        if (argType.isObject() && literal != 0L) {
            argType = ArgType.NARROW_NUMBERS;
        }
        if (!useInsn.replaceArg(arg, litArg = InsnArg.lit(literal, argType))) {
            return false;
        }
        litArg.setType(arg.getInitType());
        FieldNode fieldNode = null;
        ArgType litArgType = litArg.getType();
        if (litArgType.isTypeKnown()) {
            fieldNode = mth.getParentClass().getConstFieldByLiteralArg(litArg);
        } else if (litArgType.contains(PrimitiveType.INT)) {
            fieldNode = mth.getParentClass().getConstField((int)literal, false);
        }
        if (fieldNode != null) {
            litArg.wrapInstruction(new IndexInsnNode(InsnType.SGET, fieldNode.getFieldInfo(), 0));
        }
        if (insnType == InsnType.RETURN) {
            useInsn.setSourceLine(constInsn.getSourceLine());
        } else if (insnType == InsnType.MOVE) {
            try {
                ConstInlineVisitor.replaceConst(mth, useInsn, literal, toRemove);
            }
            catch (StackOverflowError e) {
                throw new JadxOverflowException("Stack overflow at const inline visitor");
            }
        }
        return true;
    }
}

