/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dex.ClassData;
import com.android.dex.ClassDef;
import com.android.dex.Dex;
import jadx.core.codegen.CodeWriter;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.annotations.Annotation;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.ILoadable;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.parser.AnnotationsParser;
import jadx.core.dex.nodes.parser.FieldInitAttr;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.dex.nodes.parser.StaticValuesParser;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassNode
extends LineAttrNode
implements ILoadable,
ICodeNode {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNode.class);
    private final DexNode dex;
    private final ClassInfo clsInfo;
    private AccessInfo accessFlags;
    private ArgType superClass;
    private List<ArgType> interfaces;
    private Map<ArgType, List<ArgType>> genericMap;
    private final List<MethodNode> methods;
    private final List<FieldNode> fields;
    private List<ClassNode> innerClasses = new ArrayList<ClassNode>();
    private CodeWriter code;
    private String smali;
    private ClassNode parentClass;
    private ProcessState state = ProcessState.NOT_LOADED;
    private List<ClassNode> dependencies = Collections.emptyList();
    private Map<MethodInfo, MethodNode> mthInfoMap = Collections.emptyMap();

    public ClassNode(DexNode dex, ClassDef cls) {
        this.dex = dex;
        this.clsInfo = ClassInfo.fromDex(dex, cls.getTypeIndex());
        try {
            Annotation a;
            this.superClass = cls.getSupertypeIndex() == -1 ? null : dex.getType(cls.getSupertypeIndex());
            this.interfaces = new ArrayList<ArgType>(cls.getInterfaces().length);
            for (short interfaceIdx : cls.getInterfaces()) {
                this.interfaces.add(dex.getType(interfaceIdx));
            }
            if (cls.getClassDataOffset() != 0) {
                ClassData clsData = dex.readClassData(cls);
                int mthsCount = clsData.getDirectMethods().length + clsData.getVirtualMethods().length;
                int fieldsCount = clsData.getStaticFields().length + clsData.getInstanceFields().length;
                this.methods = new ArrayList<MethodNode>(mthsCount);
                this.fields = new ArrayList<FieldNode>(fieldsCount);
                for (ClassData.Method method : clsData.getDirectMethods()) {
                    this.methods.add(new MethodNode(this, method, false));
                }
                for (ClassData.Method method : clsData.getVirtualMethods()) {
                    this.methods.add(new MethodNode(this, method, true));
                }
                for (ClassData.Method method : clsData.getStaticFields()) {
                    this.fields.add(new FieldNode(this, (ClassData.Field)method));
                }
                this.loadStaticValues(cls, this.fields);
                for (ClassData.Method method : clsData.getInstanceFields()) {
                    this.fields.add(new FieldNode(this, (ClassData.Field)method));
                }
            } else {
                this.methods = Collections.emptyList();
                this.fields = Collections.emptyList();
            }
            this.loadAnnotations(cls);
            this.parseClassSignature();
            this.setFieldsTypesFromSignature();
            int sfIdx = cls.getSourceFileIndex();
            if (sfIdx != -1) {
                String fileName = dex.getString(sfIdx);
                this.addSourceFilenameAttr(fileName);
            }
            int accFlagsValue = (a = this.getAnnotation("dalvik.annotation.InnerClass")) != null ? ((Integer)a.getValues().get("accessFlags")).intValue() : cls.getAccessFlags();
            this.accessFlags = new AccessInfo(accFlagsValue, AccessInfo.AFType.CLASS);
            this.buildCache();
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Error decode class: " + this.clsInfo, e);
        }
    }

    public ClassNode(DexNode dex, String name, int accessFlags) {
        this.dex = dex;
        this.clsInfo = ClassInfo.fromName(dex.root(), name);
        this.interfaces = new ArrayList<ArgType>();
        this.methods = new ArrayList<MethodNode>();
        this.fields = new ArrayList<FieldNode>();
        this.accessFlags = new AccessInfo(accessFlags, AccessInfo.AFType.CLASS);
        this.parentClass = this;
        dex.addClassNode(this);
    }

    private void loadAnnotations(ClassDef cls) {
        int offset = cls.getAnnotationsOffset();
        if (offset != 0) {
            try {
                new AnnotationsParser(this).parse(offset);
            }
            catch (Exception e) {
                LOG.error("Error parsing annotations in {}", (Object)this, (Object)e);
            }
        }
    }

    private void loadStaticValues(ClassDef cls, List<FieldNode> staticFields) throws DecodeException {
        for (FieldNode f : staticFields) {
            if (!f.getAccessFlags().isFinal()) continue;
            f.addAttr(FieldInitAttr.NULL_VALUE);
        }
        int offset = cls.getStaticValuesOffset();
        if (offset == 0) {
            return;
        }
        Dex.Section section = this.dex.openSection(offset);
        StaticValuesParser parser = new StaticValuesParser(this.dex, section);
        parser.processFields(staticFields);
        this.root().getConstValues().processConstFields(this, staticFields);
    }

    private void parseClassSignature() {
        SignatureParser sp = SignatureParser.fromNode(this);
        if (sp == null) {
            return;
        }
        try {
            ArgType type;
            this.genericMap = sp.consumeGenericMap();
            this.superClass = sp.consumeType();
            for (int i = 0; i < this.interfaces.size() && (type = sp.consumeType()) != null; ++i) {
                this.interfaces.set(i, type);
            }
        }
        catch (Exception e) {
            LOG.error("Class signature parse error: {}", (Object)this, (Object)e);
        }
    }

    private void setFieldsTypesFromSignature() {
        for (FieldNode field : this.fields) {
            try {
                ArgType gType;
                SignatureParser sp = SignatureParser.fromNode(field);
                if (sp == null || (gType = sp.consumeType()) == null) continue;
                field.setType(gType);
            }
            catch (Exception e) {
                LOG.error("Field signature parse error: {}.{}", new Object[]{this.getFullName(), field.getName(), e});
            }
        }
    }

    private void addSourceFilenameAttr(String fileName) {
        if (fileName == null) {
            return;
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        if (fileName.isEmpty() || fileName.equals("SourceFile") || fileName.equals("\"")) {
            return;
        }
        if (this.clsInfo != null) {
            String name = this.clsInfo.getShortName();
            if (fileName.equals(name)) {
                return;
            }
            if (fileName.contains("$") && fileName.endsWith('$' + name)) {
                return;
            }
            ClassInfo parentClass = this.clsInfo.getTopParentClass();
            if (parentClass != null && fileName.equals(parentClass.getShortName())) {
                return;
            }
        }
        this.addAttr(new SourceFileAttr(fileName));
    }

    @Override
    public void load() {
        for (MethodNode mth : this.getMethods()) {
            try {
                mth.load();
            }
            catch (Exception e) {
                mth.addError("Method load error", e);
            }
        }
        for (ClassNode innerCls : this.getInnerClasses()) {
            innerCls.load();
        }
    }

    @Override
    public void unload() {
        for (MethodNode mth : this.getMethods()) {
            mth.unload();
        }
        for (ClassNode innerCls : this.getInnerClasses()) {
            innerCls.unload();
        }
        this.setState(ProcessState.UNLOADED);
    }

    private void buildCache() {
        this.mthInfoMap = new HashMap<MethodInfo, MethodNode>(this.methods.size());
        for (MethodNode mth : this.methods) {
            this.mthInfoMap.put(mth.getMethodInfo(), mth);
        }
    }

    @Nullable
    public ArgType getSuperClass() {
        return this.superClass;
    }

    public List<ArgType> getInterfaces() {
        return this.interfaces;
    }

    public Map<ArgType, List<ArgType>> getGenericMap() {
        return this.genericMap;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<FieldNode> getFields() {
        return this.fields;
    }

    public FieldNode getConstField(Object obj) {
        return this.getConstField(obj, true);
    }

    @Nullable
    public FieldNode getConstField(Object obj, boolean searchGlobal) {
        return this.root().getConstValues().getConstField(this, obj, searchGlobal);
    }

    @Nullable
    public FieldNode getConstFieldByLiteralArg(LiteralArg arg) {
        return this.root().getConstValues().getConstFieldByLiteralArg(this, arg);
    }

    public FieldNode searchFieldById(int id) {
        return this.searchField(FieldInfo.fromDex(this.dex, id));
    }

    public FieldNode searchField(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equals(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByNameAndType(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equalsNameAndType(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByName(String name) {
        for (FieldNode f : this.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public MethodNode searchMethod(MethodInfo mth) {
        return this.mthInfoMap.get(mth);
    }

    public MethodNode searchMethodByShortId(String shortId) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getShortId().equals(shortId)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public MethodNode searchMethodByShortName(String name) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public MethodNode searchMethodById(int id) {
        return this.searchMethodByShortId(MethodInfo.fromDex(this.dex, id).getShortId());
    }

    public ClassNode getParentClass() {
        if (this.parentClass == null) {
            ClassNode parent;
            this.parentClass = this.clsInfo.isInner() ? ((parent = this.dex().resolveClass(this.clsInfo.getParentClass())) == null ? this : parent) : this;
        }
        return this.parentClass;
    }

    public ClassNode getTopParentClass() {
        ClassNode parent = this.getParentClass();
        return parent == this ? this : parent.getTopParentClass();
    }

    public List<ClassNode> getInnerClasses() {
        return this.innerClasses;
    }

    public void addInnerClass(ClassNode cls) {
        this.innerClasses.add(cls);
        cls.parentClass = this;
    }

    public boolean isEnum() {
        return this.getAccessFlags().isEnum() && this.getSuperClass() != null && this.getSuperClass().getObject().equals(ArgType.ENUM.getObject());
    }

    public boolean isAnonymous() {
        return this.contains(AFlag.ANONYMOUS_CLASS);
    }

    @Nullable
    public MethodNode getClassInitMth() {
        return this.searchMethodByShortId("<clinit>()V");
    }

    @Nullable
    public MethodNode getDefaultConstructor() {
        for (MethodNode mth : this.methods) {
            if (!mth.isDefaultConstructor()) continue;
            return mth;
        }
        return null;
    }

    @Override
    public AccessInfo getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public void setAccessFlags(AccessInfo accessFlags) {
        this.accessFlags = accessFlags;
    }

    @Override
    public DexNode dex() {
        return this.dex;
    }

    @Override
    public RootNode root() {
        return this.dex.root();
    }

    @Override
    public String typeName() {
        return "class";
    }

    public String getRawName() {
        return this.clsInfo.getRawName();
    }

    public ClassInfo getClassInfo() {
        return this.clsInfo;
    }

    public String getShortName() {
        return this.clsInfo.getAliasShortName();
    }

    public String getFullName() {
        return this.clsInfo.getAliasFullName();
    }

    public String getPackage() {
        return this.clsInfo.getAliasPkg();
    }

    public void setCode(CodeWriter code) {
        this.code = code;
    }

    public CodeWriter getCode() {
        return this.code;
    }

    public void setSmali(String smali) {
        this.smali = smali;
    }

    public String getSmali() {
        return this.smali;
    }

    public ProcessState getState() {
        return this.state;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public List<ClassNode> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ClassNode> dependencies) {
        this.dependencies = dependencies;
    }

    public int hashCode() {
        return this.clsInfo.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ClassNode) {
            ClassNode other = (ClassNode)o;
            return this.clsInfo.equals(other.clsInfo);
        }
        return false;
    }

    public String toString() {
        return this.clsInfo.getFullName();
    }
}

