/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.StoredScriptSource;

public class GetStoredScriptResponse
extends ActionResponse
implements StatusToXContentObject {
    public static final ParseField _ID_PARSE_FIELD = new ParseField("_id", new String[0]);
    public static final ParseField FOUND_PARSE_FIELD = new ParseField("found", new String[0]);
    public static final ParseField SCRIPT = new ParseField("script", new String[0]);
    private static final ConstructingObjectParser<GetStoredScriptResponse, String> PARSER = new ConstructingObjectParser("GetStoredScriptResponse", true, (a, c) -> {
        String id = (String)a[0];
        boolean found = (Boolean)a[1];
        StoredScriptSource scriptSource = (StoredScriptSource)a[2];
        return found ? new GetStoredScriptResponse(id, scriptSource) : new GetStoredScriptResponse(id, null);
    });
    private String id;
    private StoredScriptSource source;

    GetStoredScriptResponse() {
    }

    GetStoredScriptResponse(String id, StoredScriptSource source) {
        this.id = id;
        this.source = source;
    }

    public String getId() {
        return this.id;
    }

    public StoredScriptSource getSource() {
        return this.source;
    }

    @Override
    public RestStatus status() {
        return this.source != null ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_ID_PARSE_FIELD.getPreferredName(), this.id);
        builder.field(FOUND_PARSE_FIELD.getPreferredName(), this.source != null);
        if (this.source != null) {
            builder.field(StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName());
            this.source.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static GetStoredScriptResponse fromXContent(XContentParser parser) throws IOException {
        return (GetStoredScriptResponse)PARSER.parse(parser, null);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.source = in.readBoolean() ? (in.getVersion().onOrAfter(Version.V_5_3_0) ? new StoredScriptSource(in) : new StoredScriptSource(in.readString())) : null;
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.id = in.readString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.source == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
                this.source.writeTo(out);
            } else {
                out.writeString(this.source.getSource());
            }
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeString(this.id);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStoredScriptResponse that = (GetStoredScriptResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), _ID_PARSE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.booleanValue(), FOUND_PARSE_FIELD, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> StoredScriptSource.fromXContent(p, true), SCRIPT, ObjectParser.ValueType.OBJECT);
    }
}

