/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.lang.CPStringBuilder;
import java.io.ObjectStreamException;
import java.net.InetAddress;

public final class Inet4Address
extends InetAddress {
    static final long serialVersionUID = 3286316764910316507L;
    private static final int AF_INET = 2;

    private Object writeReplace() throws ObjectStreamException {
        return new InetAddress(this.addr, this.hostName, 2);
    }

    Inet4Address(byte[] addr, String host) {
        super(addr, host, 2);
    }

    public boolean isMulticastAddress() {
        return (this.addr[0] & 0xF0) == 224;
    }

    public boolean isLoopbackAddress() {
        return (this.addr[0] & 0xFF) == 127;
    }

    public boolean isAnyLocalAddress() {
        return this.equals(InetAddress.ANY_IF);
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        if ((this.addr[0] & 0xFF) == 10) {
            return true;
        }
        if ((this.addr[0] & 0xFF) == 172 && (this.addr[1] & 0xF0) == 16) {
            return true;
        }
        return (this.addr[0] & 0xFF) == 192 && (this.addr[1] & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.addr[0] & 0xFF) == 224 && (this.addr[1] & 0xFF) == 0 && (this.addr[2] & 0xFF) == 0;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    public String getHostAddress() {
        CPStringBuilder sb = new CPStringBuilder(40);
        int len = this.addr.length;
        int i = 0;
        while (true) {
            sb.append(this.addr[i] & 0xFF);
            if (++i == len) break;
            sb.append('.');
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 0;
        int len = this.addr.length;
        int i = len > 4 ? len - 4 : 0;
        while (i < len) {
            hash = hash << 8 | this.addr[i] & 0xFF;
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InetAddress)) {
            return false;
        }
        byte[] addr1 = this.addr;
        byte[] addr2 = ((InetAddress)obj).addr;
        if (addr1.length != addr2.length) {
            return false;
        }
        int i = addr1.length;
        while (--i >= 0) {
            if (addr1[i] == addr2[i]) continue;
            return false;
        }
        return true;
    }
}

