/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.util.DerUtil;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;

public class DHKeyPairX509Codec
implements IKeyPairCodec {
    private static final OID DH_ALG_OID = new OID("1.2.840.10046.2.1");

    public int getFormatID() {
        return 2;
    }

    public byte[] encodePublicKey(PublicKey key) {
        byte[] result;
        if (!(key instanceof GnuDHPublicKey)) {
            throw new InvalidParameterException("Wrong key type");
        }
        DERValue derOID = new DERValue(6, DH_ALG_OID);
        GnuDHPublicKey dhKey = (GnuDHPublicKey)key;
        BigInteger p = dhKey.getParams().getP();
        BigInteger g = dhKey.getParams().getG();
        BigInteger q = dhKey.getQ();
        if (q == null) {
            q = BigInteger.ZERO;
        }
        BigInteger y = dhKey.getY();
        DERValue derP = new DERValue(2, p);
        DERValue derG = new DERValue(2, g);
        DERValue derQ = new DERValue(2, q);
        ArrayList<DERValue> params = new ArrayList<DERValue>(3);
        params.add(derP);
        params.add(derG);
        params.add(derQ);
        DERValue derParams = new DERValue(48, params);
        ArrayList<DERValue> algorithmID = new ArrayList<DERValue>(2);
        algorithmID.add(derOID);
        algorithmID.add(derParams);
        DERValue derAlgorithmID = new DERValue(48, algorithmID);
        DERValue derDHPublicKey = new DERValue(2, y);
        byte[] yBytes = derDHPublicKey.getEncoded();
        DERValue derSPK = new DERValue(3, new BitString(yBytes));
        ArrayList<DERValue> spki = new ArrayList<DERValue>(2);
        spki.add(derAlgorithmID);
        spki.add(derSPK);
        DERValue derSPKI = new DERValue(48, spki);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DERWriter.write(baos, derSPKI);
            result = baos.toByteArray();
        }
        catch (IOException x) {
            InvalidParameterException e = new InvalidParameterException();
            e.initCause(x);
            throw e;
        }
        return result;
    }

    public byte[] encodePrivateKey(PrivateKey key) {
        throw new InvalidParameterException("Wrong format for private keys");
    }

    public PublicKey decodePublicKey(byte[] input) {
        BigInteger y;
        BigInteger q;
        BigInteger g;
        BigInteger p;
        if (input == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader der = new DERReader(input);
        try {
            DERValue derSPKI = der.read();
            DerUtil.checkIsConstructed(derSPKI, "Wrong SubjectPublicKeyInfo field");
            DERValue derAlgorithmID = der.read();
            DerUtil.checkIsConstructed(derAlgorithmID, "Wrong AlgorithmIdentifier field");
            DERValue derOID = der.read();
            if (!(derOID.getValue() instanceof OID)) {
                throw new InvalidParameterException("Wrong Algorithm field");
            }
            OID algOID = (OID)derOID.getValue();
            if (!algOID.equals(DH_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + algOID);
            }
            DERValue derParams = der.read();
            DerUtil.checkIsConstructed(derParams, "Wrong DH Parameters field");
            DERValue val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong P field");
            p = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong G field");
            g = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong Q field");
            q = (BigInteger)val.getValue();
            if (q.compareTo(BigInteger.ZERO) == 0) {
                q = null;
            }
            if (!((val = der.read()).getValue() instanceof BitString)) {
                throw new InvalidParameterException("Wrong SubjectPublicKey field");
            }
            byte[] yBytes = ((BitString)val.getValue()).toByteArray();
            DERReader dhPub = new DERReader(yBytes);
            val = dhPub.read();
            DerUtil.checkIsBigInteger(val, "Wrong Y field");
            y = (BigInteger)val.getValue();
        }
        catch (IOException x) {
            InvalidParameterException e = new InvalidParameterException();
            e.initCause(x);
            throw e;
        }
        return new GnuDHPublicKey(2, q, p, g, y);
    }

    public PrivateKey decodePrivateKey(byte[] input) {
        throw new InvalidParameterException("Wrong format for private keys");
    }
}

