/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatCharacterIterator
implements AttributedCharacterIterator {
    private String formattedString;
    private int charIndex;
    private int attributeIndex;
    private int[] ranges;
    private List<Map<AttributedCharacterIterator.Attribute, Object>> attributes;
    private static final boolean DEBUG = false;

    public FormatCharacterIterator() {
        this.formattedString = "";
        this.ranges = new int[0];
        this.attributes = new ArrayList<Map<AttributedCharacterIterator.Attribute, Object>>(0);
    }

    public FormatCharacterIterator(String s, int[] ranges, List<Map<AttributedCharacterIterator.Attribute, Object>> attributes) {
        this.formattedString = s;
        this.ranges = ranges;
        this.attributes = attributes;
    }

    @Override
    public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
        if (this.attributes != null && this.attributes.get(this.attributeIndex) != null) {
            return this.attributes.get(this.attributeIndex).keySet();
        }
        return new HashSet<AttributedCharacterIterator.Attribute>();
    }

    @Override
    public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
        if (this.attributes != null && this.attributes.get(this.attributeIndex) != null) {
            return this.attributes.get(this.attributeIndex);
        }
        return new HashMap<AttributedCharacterIterator.Attribute, Object>();
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attrib) {
        if (this.attributes != null && this.attributes.get(this.attributeIndex) != null) {
            return this.attributes.get(this.attributeIndex).get(attrib);
        }
        return null;
    }

    @Override
    public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> reqAttrs) {
        Set<AttributedCharacterIterator.Attribute> newKeys;
        Map<AttributedCharacterIterator.Attribute, Object> currentAttr;
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        int currentAttrIndex = this.attributeIndex;
        do {
            if (++currentAttrIndex != this.attributes.size()) continue;
            return this.formattedString.length();
        } while ((currentAttr = this.attributes.get(currentAttrIndex)) != null && (newKeys = currentAttr.keySet()).containsAll(reqAttrs));
        return this.ranges[currentAttrIndex - 1];
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        HashSet s = new HashSet();
        s.add(attribute);
        return this.getRunLimit(s);
    }

    @Override
    public int getRunLimit() {
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        if (this.attributes.get(this.attributeIndex) == null) {
            int i = this.attributeIndex + 1;
            while (i < this.attributes.size()) {
                if (this.attributes.get(i) != null) {
                    return this.ranges[i - 1];
                }
                ++i;
            }
            return this.formattedString.length();
        }
        return this.getRunLimit(this.attributes.get(this.attributeIndex).keySet());
    }

    @Override
    public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> reqAttrs) {
        Map<AttributedCharacterIterator.Attribute, Object> currentAttr;
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        int currentAttrIndex = this.attributeIndex;
        Set<AttributedCharacterIterator.Attribute> newKeys = null;
        do {
            if (currentAttrIndex != 0) continue;
            return 0;
        } while ((currentAttr = this.attributes.get(--currentAttrIndex)) != null && (newKeys = currentAttr.keySet()).containsAll(reqAttrs));
        return currentAttrIndex > 0 ? this.ranges[currentAttrIndex - 1] : 0;
    }

    @Override
    public int getRunStart() {
        if (this.attributes == null) {
            return 0;
        }
        Map<AttributedCharacterIterator.Attribute, Object> attrib = this.attributes.get(this.attributeIndex);
        if (attrib == null) {
            int i = this.attributeIndex;
            while (i > 0) {
                if (this.attributes.get(i) != null) {
                    return this.ranges[this.attributeIndex - 1];
                }
                --i;
            }
            return 0;
        }
        return this.getRunStart(attrib.keySet());
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        HashSet s = new HashSet();
        s.add(attribute);
        return this.getRunStart(s);
    }

    @Override
    public Object clone() {
        return new FormatCharacterIterator(this.formattedString, this.ranges, this.attributes);
    }

    @Override
    public char current() {
        return this.formattedString.charAt(this.charIndex);
    }

    @Override
    public char first() {
        this.charIndex = 0;
        this.attributeIndex = 0;
        return this.formattedString.charAt(0);
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.formattedString.length();
    }

    @Override
    public int getIndex() {
        return this.charIndex;
    }

    @Override
    public char last() {
        this.charIndex = this.formattedString.length() - 1;
        if (this.attributes != null) {
            this.attributeIndex = this.attributes.size() - 1;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    @Override
    public char next() {
        ++this.charIndex;
        if (this.charIndex >= this.formattedString.length()) {
            this.charIndex = this.getEndIndex();
            return '\uffff';
        }
        if (this.attributes != null && this.charIndex >= this.ranges[this.attributeIndex]) {
            ++this.attributeIndex;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    @Override
    public char previous() {
        --this.charIndex;
        if (this.charIndex < 0) {
            this.charIndex = 0;
            return '\uffff';
        }
        if (this.attributes != null && this.charIndex < this.ranges[this.attributeIndex]) {
            --this.attributeIndex;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    @Override
    public char setIndex(int position) {
        if (position < 0 || position > this.formattedString.length()) {
            throw new IllegalArgumentException("position is out of range");
        }
        this.charIndex = position;
        if (this.attributes != null) {
            this.attributeIndex = 0;
            while (this.attributeIndex < this.attributes.size()) {
                if (this.ranges[this.attributeIndex] > this.charIndex) break;
                ++this.attributeIndex;
            }
            --this.attributeIndex;
        }
        if (this.charIndex == this.formattedString.length()) {
            return '\uffff';
        }
        return this.formattedString.charAt(this.charIndex);
    }

    public void mergeAttributes(List<Map<AttributedCharacterIterator.Attribute, Object>> attributes, int[] ranges) {
        ArrayList<Integer> newRanges = new ArrayList<Integer>();
        ArrayList<Map<AttributedCharacterIterator.Attribute, Object>> newAttributes = new ArrayList<Map<AttributedCharacterIterator.Attribute, Object>>();
        int i = 0;
        int j = 0;
        this.debug("merging " + attributes.size() + " attrs");
        while (i < this.ranges.length && j < ranges.length) {
            if (this.attributes.get(i) != null) {
                newAttributes.add(this.attributes.get(i));
                if (attributes.get(j) != null) {
                    this.attributes.get(i).putAll(attributes.get(j));
                }
            } else {
                newAttributes.add(attributes.get(j));
            }
            if (this.ranges[i] == ranges[j]) {
                newRanges.add(ranges[j]);
                ++i;
                ++j;
                continue;
            }
            if (this.ranges[i] < ranges[j]) {
                newRanges.add(this.ranges[i]);
                ++i;
                continue;
            }
            newRanges.add(ranges[j]);
            ++j;
        }
        if (i != this.ranges.length) {
            while (i < this.ranges.length) {
                newAttributes.add(this.attributes.get(i));
                newRanges.add(this.ranges[i]);
                ++i;
            }
        }
        if (j != ranges.length) {
            while (j < ranges.length) {
                newAttributes.add(attributes.get(j));
                newRanges.add(ranges[j]);
                ++j;
            }
        }
        this.attributes = newAttributes;
        this.ranges = new int[newRanges.size()];
        i = 0;
        while (i < newRanges.size()) {
            this.ranges[i] = (Integer)newRanges.get(i);
            ++i;
        }
        this.dumpTable();
    }

    public void append(AttributedCharacterIterator iterator) {
        char c = iterator.first();
        ArrayList<Integer> moreRanges = new ArrayList<Integer>();
        ArrayList<Map<AttributedCharacterIterator.Attribute, Object>> moreAttributes = new ArrayList<Map<AttributedCharacterIterator.Attribute, Object>>();
        do {
            this.formattedString = String.valueOf(this.formattedString) + String.valueOf(c);
            moreAttributes.add(iterator.getAttributes());
            moreRanges.add(this.formattedString.length());
        } while ((c = iterator.next()) != '\uffff');
        ArrayList<Map<AttributedCharacterIterator.Attribute, Object>> newAttributes = new ArrayList<Map<AttributedCharacterIterator.Attribute, Object>>(this.attributes.size() + moreAttributes.size());
        int[] newRanges = new int[this.ranges.length + moreRanges.size()];
        newAttributes.addAll(this.attributes);
        newAttributes.addAll(moreAttributes);
        System.arraycopy(this.ranges, 0, newRanges, 0, this.ranges.length);
        Integer[] newRangesArray = moreRanges.toArray(new Integer[moreRanges.size()]);
        int i = 0;
        while (i < moreRanges.size()) {
            newRanges[i + this.ranges.length] = newRangesArray[i];
            ++i;
        }
        this.attributes = newAttributes;
        this.ranges = newRanges;
    }

    public void append(String text, HashMap<? extends AttributedCharacterIterator.Attribute, ? extends Object> localAttributes) {
        int[] newRanges = new int[this.ranges.length + 1];
        ArrayList<Map<AttributedCharacterIterator.Attribute, Object>> newAttributes = new ArrayList<Map<AttributedCharacterIterator.Attribute, Object>>(this.attributes.size() + 1);
        this.formattedString = String.valueOf(this.formattedString) + text;
        newAttributes.addAll(this.attributes);
        System.arraycopy(this.ranges, 0, newRanges, 0, this.ranges.length);
        newRanges[this.ranges.length] = this.formattedString.length();
        newAttributes.add(new HashMap<AttributedCharacterIterator.Attribute, Object>(localAttributes));
        this.ranges = newRanges;
        this.attributes = newAttributes;
    }

    public void append(String text) {
        this.append(text, null);
    }

    public void addAttributes(Map<? extends AttributedCharacterIterator.Attribute, ? extends Object> attributes, int rangeStart, int rangeEnd) {
        int[] mergeRanges;
        ArrayList<Map<AttributedCharacterIterator.Attribute, Object>> mergeAttribs = new ArrayList<Map<AttributedCharacterIterator.Attribute, Object>>();
        if (rangeStart == 0) {
            mergeRanges = new int[]{rangeEnd};
        } else {
            mergeRanges = new int[]{rangeStart, rangeEnd};
            mergeAttribs.add(null);
        }
        mergeAttribs.add(new HashMap<AttributedCharacterIterator.Attribute, Object>(attributes));
        this.mergeAttributes(mergeAttribs, mergeRanges);
    }

    private void debug(String s) {
    }

    private void dumpTable() {
    }
}

