/*
 * Decompiled with CFR 0.152.
 */
package javax.wsdl.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;

public abstract class WSDLFactory {
    private static final String PROPERTY_NAME = "javax.wsdl.factory.WSDLFactory";
    private static final String PROPERTY_FILE_NAME = "wsdl.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "com.ibm.wsdl.factory.WSDLFactoryImpl";
    private static String fullPropertyFileName = null;

    private static String findFactoryImplName() {
        block6: {
            String string = null;
            try {
                string = System.getProperty(PROPERTY_NAME);
                if (string != null) {
                    return string;
                }
            }
            catch (SecurityException securityException) {}
            String string2 = WSDLFactory.getFullPropertyFileName();
            if (string2 == null) break block6;
            try {
                Properties properties = new Properties();
                File file = new File(string2);
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
                string = properties.getProperty(PROPERTY_NAME);
                if (string != null) {
                    return string;
                }
            }
            catch (IOException iOException) {}
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        block2: {
            if (fullPropertyFileName != null) break block2;
            try {
                String string = System.getProperty("java.home");
                fullPropertyFileName = String.valueOf(string) + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {}
        }
        return fullPropertyFileName;
    }

    public abstract Definition newDefinition();

    public static WSDLFactory newInstance() throws WSDLException {
        String string = WSDLFactory.findFactoryImplName();
        return WSDLFactory.newInstance(string);
    }

    public static WSDLFactory newInstance(String string) throws WSDLException {
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                return (WSDLFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating factory implementation.", exception);
            }
        }
        throw new WSDLException("CONFIGURATION_ERROR", "Unable to find name of factory implementation.");
    }

    public abstract ExtensionRegistry newPopulatedExtensionRegistry();

    public abstract WSDLReader newWSDLReader();

    public abstract WSDLWriter newWSDLWriter();
}

