/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Logging;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.StyleableStringProperty;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.logging.PlatformLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.control.Tooltip;
import javafx.scene.control.UAStylesheetLoader;

public abstract class Control
extends Parent
implements Skinnable {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    private ObjectProperty<Skin<?>> skin = new StyleableObjectProperty<Skin<?>>(){
        private Skin<?> oldValue;

        @Override
        public void set(Skin<?> skin) {
            if (skin == null ? this.oldValue == null : this.oldValue != null && skin.getClass().equals(this.oldValue.getClass())) {
                return;
            }
            super.set(skin);
            Control.this.currentSkinClassName = skin == null ? null : skin.getClass().getName();
            Control.this.skinClassNameProperty().set(Control.this.currentSkinClassName);
        }

        @Override
        protected void invalidated() {
            if (this.oldValue != null) {
                this.oldValue.dispose();
            }
            Skin skin = this.oldValue = (Skin)this.getValue();
            Control.this.updateChildren();
            PlatformLogger platformLogger = com.sun.javafx.scene.control.Logging.getControlsLogger();
            if (platformLogger.isLoggable(300)) {
                platformLogger.finest("Stored skin[" + this.getValue() + "] on " + this);
            }
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.SKIN;
        }

        @Override
        public Object getBean() {
            return Control.this;
        }

        @Override
        public String getName() {
            return "skin";
        }
    };
    private ObjectProperty<Tooltip> tooltip;
    private ObjectProperty<ContextMenu> contextMenu = new SimpleObjectProperty<ContextMenu>((Object)this, "contextMenu"){

        @Override
        protected void invalidated() {
            ContextMenu contextMenu = (ContextMenu)this.get();
            if (contextMenu != null) {
                contextMenu.setImpl_showRelativeToWindow(true);
            }
        }

        @Override
        public Object getBean() {
            return Control.this;
        }

        @Override
        public String getName() {
            return "contextMenu";
        }
    };
    private ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper(){

        @Override
        protected void invalidated() {
            Control.this.impl_layoutBoundsChanged();
            Control.this.requestLayout();
        }

        @Override
        public Object getBean() {
            return Control.this;
        }

        @Override
        public String getName() {
            return "width";
        }
    };
    private ReadOnlyDoubleWrapper height = new ReadOnlyDoubleWrapper(){

        @Override
        protected void invalidated() {
            Control.this.impl_layoutBoundsChanged();
            Control.this.requestLayout();
        }

        @Override
        public Object getBean() {
            return Control.this;
        }

        @Override
        public String getName() {
            return "height";
        }
    };
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private String currentSkinClassName = null;
    private StringProperty skinClassName;

    static Class<?> loadClass(String string, Object object) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Thread.currentThread().getContextClassLoader() != null) {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            if (object != null) {
                for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        return clazz.getClassLoader().loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        continue;
                    }
                }
            }
            throw classNotFoundException;
        }
    }

    @Override
    public final ObjectProperty<Skin<?>> skinProperty() {
        return this.skin;
    }

    @Override
    public final void setSkin(Skin<?> skin) {
        this.skinProperty().set(skin);
    }

    @Override
    public final Skin<?> getSkin() {
        return (Skin)this.skinProperty().getValue();
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new ObjectPropertyBase<Tooltip>(){
                private Tooltip old = null;

                @Override
                protected void invalidated() {
                    Tooltip tooltip = (Tooltip)this.get();
                    if (tooltip != this.old) {
                        if (this.old != null) {
                            Tooltip.uninstall(Control.this, this.old);
                        }
                        if (tooltip != null) {
                            Tooltip.install(Control.this, tooltip);
                        }
                        this.old = tooltip;
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "tooltip";
                }
            };
        }
        return this.tooltip;
    }

    public final void setTooltip(Tooltip tooltip) {
        this.tooltipProperty().setValue(tooltip);
    }

    public final Tooltip getTooltip() {
        return this.tooltip == null ? null : (Tooltip)this.tooltip.getValue();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenu;
    }

    public final void setContextMenu(ContextMenu contextMenu) {
        this.contextMenu.setValue(contextMenu);
    }

    public final ContextMenu getContextMenu() {
        return this.contextMenu == null ? null : (ContextMenu)this.contextMenu.getValue();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    protected final void setWidth(double d) {
        this.width.set(d);
    }

    public final double getWidth() {
        return this.width.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    protected final void setHeight(double d) {
        this.height.set(d);
    }

    public final double getHeight() {
        return this.height.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Control.this.getParent() != null) {
                        Control.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? -1.0 : this.minWidth.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Control.this.getParent() != null) {
                        Control.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setMinHeight(double d) {
        this.minHeightProperty().set(d);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? -1.0 : this.minHeight.get();
    }

    public void setMinSize(double d, double d2) {
        this.setMinWidth(d);
        this.setMinHeight(d2);
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Control.this.getParent() != null) {
                        Control.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? -1.0 : this.prefWidth.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Control.this.getParent() != null) {
                        Control.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public final void setPrefHeight(double d) {
        this.prefHeightProperty().set(d);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? -1.0 : this.prefHeight.get();
    }

    public void setPrefSize(double d, double d2) {
        this.setPrefWidth(d);
        this.setPrefHeight(d2);
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Control.this.getParent() != null) {
                        Control.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? -1.0 : this.maxWidth.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Control.this.getParent() != null) {
                        Control.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public final void setMaxHeight(double d) {
        this.maxHeightProperty().set(d);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? -1.0 : this.maxHeight.get();
    }

    protected Control() {
        StyleableProperty styleableProperty = StyleableProperty.getStyleableProperty(this.focusTraversableProperty());
        styleableProperty.set(this, Boolean.TRUE);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d, double d2) {
        this.setWidth(d);
        this.setHeight(d2);
        PlatformLogger platformLogger = Logging.getLayoutLogger();
        if (platformLogger.isLoggable(400)) {
            platformLogger.finer(this.toString() + " resized to " + d + " x " + d2);
        }
    }

    @Override
    public final double minWidth(double d) {
        double d2 = this.getMinWidth();
        if (d2 == -1.0) {
            return super.minWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double minHeight(double d) {
        double d2 = this.getMinHeight();
        if (d2 == -1.0) {
            return super.minHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    @Override
    public final double prefWidth(double d) {
        double d2 = this.getPrefWidth();
        if (d2 == -1.0) {
            return super.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double prefHeight(double d) {
        double d2 = this.getPrefHeight();
        if (d2 == -1.0) {
            return super.prefHeight(d);
        }
        return d2;
    }

    @Override
    public final double maxWidth(double d) {
        double d2 = this.getMaxWidth();
        if (d2 == -1.0) {
            return this.computeMaxWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double maxHeight(double d) {
        double d2 = this.getMaxHeight();
        if (d2 == -1.0) {
            return this.computeMaxHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    public void setMaxSize(double d, double d2) {
        this.setMaxWidth(d);
        this.setMaxHeight(d2);
    }

    @Override
    protected double computeMinWidth(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minWidth(d);
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minHeight(d);
    }

    protected double computeMaxWidth(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxWidth(d);
    }

    protected double computeMaxHeight(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxHeight(d);
    }

    @Override
    protected double computePrefWidth(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefWidth(d);
    }

    @Override
    protected double computePrefHeight(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefHeight(d);
    }

    @Override
    public double getBaselineOffset() {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().getBaselineOffset();
    }

    @Override
    @Deprecated
    protected void impl_notifyLayoutBoundsChanged() {
    }

    @Override
    @Deprecated
    protected Bounds impl_computeLayoutBounds() {
        return new BoundingBox(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    @Override
    protected void layoutChildren() {
        Node node = this.getSkinNode();
        if (node != null) {
            node.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        Node node = this.getSkinNode();
        return node == null ? false : node.contains(d, d2);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        Node node = this.getSkinNode();
        return node == null ? false : node.intersects(d, d2, d3, d4);
    }

    private Node getSkinNode() {
        return this.getSkin() == null ? null : this.getSkin().getNode();
    }

    private void updateChildren() {
        Node node = this.getSkinNode();
        if (node != null) {
            this.getChildren().setAll((Node[])new Node[]{node});
        } else {
            this.getChildren().clear();
        }
    }

    protected StringProperty skinClassNameProperty() {
        if (this.skinClassName == null) {
            this.skinClassName = new StyleableStringProperty(){

                @Override
                public void set(String string) {
                    if (string == null || string.isEmpty() || string.equals(this.get())) {
                        return;
                    }
                    super.set(string);
                }

                @Override
                public void invalidated() {
                    if (this.get() != null && !this.get().equals(Control.this.currentSkinClassName)) {
                        Control.this.loadSkinClass();
                    }
                }

                @Override
                public Object getBean() {
                    return Control.this;
                }

                @Override
                public String getName() {
                    return "skinClassName";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SKIN;
                }
            };
        }
        return this.skinClassName;
    }

    protected void setSkinClassName(String string) {
        this.skinClassNameProperty().set(string);
    }

    private void loadSkinClass() {
        if (this.skinClassName == null || this.skinClassName.get() == null || ((String)this.skinClassName.get()).isEmpty()) {
            String string = "Empty -fx-skin property specified for control " + this;
            ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
            if (observableList != null) {
                CssError cssError = new CssError(string);
                observableList.add(cssError);
            }
            com.sun.javafx.scene.control.Logging.getControlsLogger().severe(string);
            return;
        }
        try {
            Class<?> clazz = Control.loadClass((String)this.skinClassName.get(), this);
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> constructor2 : constructorArray) {
                Class<?>[] classArray = constructor2.getParameterTypes();
                if (classArray.length != 1 || !Control.class.isAssignableFrom(classArray[0])) continue;
                constructor = constructor2;
                break;
            }
            if (constructor == null) {
                String cssError = "No valid constructor defined in '" + this.skinClassName + "' for control " + this + ".\r\nYou must provide a constructor that accepts a single " + "Control parameter in " + this.skinClassName + ".";
                ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
                if (observableList != null) {
                    CssError cssError2 = new CssError(cssError);
                    observableList.add(cssError2);
                }
                com.sun.javafx.scene.control.Logging.getControlsLogger().severe(cssError);
            } else {
                Skin cssError = (Skin)constructor.newInstance(this);
                this.skinProperty().set(cssError);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Failed to load skin '" + this.skinClassName + "' for control " + this;
            ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
            if (observableList != null) {
                CssError cssError = new CssError(string + " :" + invocationTargetException.getLocalizedMessage());
                observableList.add(cssError);
            }
            com.sun.javafx.scene.control.Logging.getControlsLogger().severe(string, invocationTargetException.getCause());
        }
        catch (Exception exception) {
            String string = "Failed to load skin '" + this.skinClassName + "' for control " + this;
            ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
            if (observableList != null) {
                CssError cssError = new CssError(string + " :" + exception.getLocalizedMessage());
                observableList.add(cssError);
            }
            com.sun.javafx.scene.control.Logging.getControlsLogger().severe(string, exception);
        }
    }

    protected String getUserAgentStylesheet() {
        return null;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Control.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public void impl_processCSS(boolean bl) {
        if (bl && this.getUserAgentStylesheet() != null) {
            StyleManager.getInstance().addUserAgentStylesheet(this.getScene(), this.getUserAgentStylesheet());
        }
        super.impl_processCSS(bl);
        if (this.getSkin() == null) {
            String string = "The -fx-skin property has not been defined in CSS for " + this;
            ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
            if (observableList != null) {
                CssError cssError = new CssError(string);
                observableList.add(cssError);
            }
            com.sun.javafx.scene.control.Logging.getControlsLogger().severe(string);
        }
    }

    @Override
    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.TRUE;
    }

    static {
        UAStylesheetLoader.doLoad();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Control, String> SKIN = new StyleableProperty<Control, String>("-fx-skin", (StyleConverter)StringConverter.getInstance()){

            @Override
            public boolean isSettable(Control control) {
                return control.skin == null || !control.skin.isBound();
            }

            @Override
            public WritableValue<String> getWritableValue(Control control) {
                return control.skinClassNameProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Parent.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, SKIN);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

