/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.filters;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.spider.DomainAlwaysInScopeMatcher;
import org.zaproxy.zap.spider.filters.FetchFilter;

public class DefaultFetchFilter
extends FetchFilter {
    private Set<String> scopes = new LinkedHashSet<String>();
    private List<DomainAlwaysInScopeMatcher> domainsAlwaysInScope = Collections.emptyList();
    private List<String> excludeList = null;
    private Context scanContext;

    @Override
    public FetchFilter.FetchStatus checkFilter(URI uri) {
        log.debug((Object)("Checking: " + uri));
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            return FetchFilter.FetchStatus.ILLEGAL_PROTOCOL;
        }
        try {
            if (this.scanContext != null) {
                if (!this.scanContext.isInContext(uri.toString())) {
                    return FetchFilter.FetchStatus.OUT_OF_CONTEXT;
                }
            } else {
                String host = uri.getHost();
                if (!this.isDomainInScope(host) && !this.isDomainAlwaysInScope(host)) {
                    return FetchFilter.FetchStatus.OUT_OF_SCOPE;
                }
            }
            if (this.isExcluded(uri.toString())) {
                return FetchFilter.FetchStatus.USER_RULES;
            }
        }
        catch (URIException e) {
            log.warn((Object)("Error while fetching host for uri: " + uri), (Throwable)e);
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        return FetchFilter.FetchStatus.VALID;
    }

    private boolean isExcluded(String uri) {
        if (this.excludeList == null || this.excludeList.isEmpty()) {
            return false;
        }
        for (String ex : this.excludeList) {
            if (!uri.matches(ex)) continue;
            return true;
        }
        return false;
    }

    private boolean isDomainInScope(String domain) {
        for (String scope : this.scopes) {
            if (!domain.matches(scope)) continue;
            return true;
        }
        return false;
    }

    private boolean isDomainAlwaysInScope(String domain) {
        for (DomainAlwaysInScopeMatcher domainInScope : this.domainsAlwaysInScope) {
            if (!domainInScope.matches(domain)) continue;
            return true;
        }
        return false;
    }

    public void addScopeRegex(String scope) {
        this.scopes.add(scope);
    }

    public void setDomainsAlwaysInScope(List<DomainAlwaysInScopeMatcher> domainsAlwaysInScope) {
        this.domainsAlwaysInScope = domainsAlwaysInScope == null || domainsAlwaysInScope.isEmpty() ? Collections.emptyList() : domainsAlwaysInScope;
    }

    public void setExcludeRegexes(List<String> excl) {
        this.excludeList = excl;
    }

    public void setScanContext(Context scanContext) {
        this.scanContext = scanContext;
    }
}

