/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.jdbc;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jxls.common.JxlsException;
import org.jxls.jdbc.CaseInsensitiveHashMap;

public class JdbcHelper {
    private Connection conn;

    public JdbcHelper(Connection conn) {
        this.conn = conn;
    }

    public List<Map<String, Object>> query(String sql, Object ... params) {
        List<Map<String, Object>> result;
        if (this.conn == null) {
            throw new JxlsException("Null jdbc connection");
        }
        if (sql == null) {
            throw new JxlsException("Null SQL statement");
        }
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            this.fillStatement(stmt, params);
            try (ResultSet rs = stmt.executeQuery();){
                result = this.handle(rs);
            }
        }
        catch (Exception e) {
            throw new JxlsException("Failed to execute sql", e);
        }
        return result;
    }

    private void fillStatement(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        ParameterMetaData pmd = null;
        boolean pmdKnownBroken = false;
        int stmtCount = 0;
        int paramsCount = 0;
        try {
            pmd = stmt.getParameterMetaData();
            stmtCount = pmd.getParameterCount();
            paramsCount = params.length;
        }
        catch (Exception e) {
            pmdKnownBroken = true;
        }
        if (stmtCount != paramsCount) {
            throw new SQLException("Wrong number of parameters: expected " + stmtCount + ", was given " + paramsCount);
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null) {
                stmt.setObject(i + 1, params[i]);
                continue;
            }
            int sqlType = 12;
            if (!pmdKnownBroken) {
                try {
                    sqlType = pmd.getParameterType(i + 1);
                }
                catch (SQLException e) {
                    pmdKnownBroken = true;
                }
            }
            stmt.setNull(i + 1, sqlType);
        }
    }

    public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            rows.add(this.handleRow(rs));
        }
        return rows;
    }

    private Map<String, Object> handleRow(ResultSet rs) throws SQLException {
        CaseInsensitiveHashMap result = new CaseInsensitiveHashMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String columnName = rsmd.getColumnLabel(i);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(i);
            }
            result.put(columnName, rs.getObject(i));
        }
        return result;
    }
}

