/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class XirgoProtocolDecoder
extends BaseProtocolDecoder {
    private Boolean newFormat;
    private static final Pattern PATTERN_OLD = new PatternBuilder().text("$$").number("(d+),").number("(d+),").number("(dddd)/(dd)/(dd),").number("(dd):(dd):(dd),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(d+.?d*),").number("(d+.?d*),").number("(d+),").number("(d+.?d*),").number("(d+.d+),").number("(d+),").number("(d+.?d*),").number("(d+),").any().compile();
    private static final Pattern PATTERN_NEW = new PatternBuilder().text("$$").number("(d+),").number("(d+),").number("(dddd)/(dd)/(dd),").number("(dd):(dd):(dd),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(d+.?d*),").number("d+.?d*,").number("d+.?d*,").number("d+,").number("(d+.?d*),").number("(d+),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.d+),").number("(d+),").number("(d+),").groupBegin().number("d,").expression("([01])").expression("([01])").expression("([01])").expression("([01]),").number("(d+.?d*),").number("(d+.?d*),").number("d+,").number("(d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("(d+),").number("(-?d+)").groupEnd("?").any().compile();

    public XirgoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeEvent(Position position, int event) {
        position.set("event", event);
        switch (event) {
            case 4001: 
            case 4003: 
            case 6011: 
            case 6013: {
                position.set("ignition", true);
                break;
            }
            case 4002: 
            case 4004: 
            case 6012: 
            case 6014: {
                position.set("ignition", false);
                break;
            }
            case 4005: {
                position.set("charge", false);
                break;
            }
            case 6002: {
                position.set("alarm", "overspeed");
                break;
            }
            case 6006: {
                position.set("alarm", "hardAcceleration");
                break;
            }
            case 6007: {
                position.set("alarm", "hardBraking");
                break;
            }
            case 6008: {
                position.set("alarm", "lowPower");
                break;
            }
            case 6009: {
                position.set("alarm", "powerCut");
                break;
            }
            case 6010: {
                position.set("alarm", "powerRestored");
                break;
            }
            case 6016: {
                position.set("alarm", "idle");
                break;
            }
            case 6017: {
                position.set("alarm", "tow");
                break;
            }
            case 6030: 
            case 6071: {
                position.set("motion", true);
                break;
            }
            case 6031: {
                position.set("motion", false);
                break;
            }
            case 6032: {
                position.set("alarm", "parking");
                break;
            }
            case 6090: {
                position.set("alarm", "removing");
                break;
            }
            case 6091: {
                position.set("alarm", "lowBattery");
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        if (this.newFormat == null) {
            parser = new Parser(PATTERN_NEW, sentence);
            if (parser.matches()) {
                this.newFormat = true;
            } else {
                parser = new Parser(PATTERN_OLD, sentence);
                if (!parser.matches()) return null;
                this.newFormat = false;
            }
        } else {
            parser = this.newFormat != false ? new Parser(PATTERN_NEW, sentence) : new Parser(PATTERN_OLD, sentence);
            if (!parser.matches()) {
                return null;
            }
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        this.decodeEvent(position, parser.nextInt());
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromMph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt());
        position.set("hdop", parser.nextDouble());
        if (this.newFormat.booleanValue()) {
            position.set("odometer", UnitsConverter.metersFromMiles(parser.nextDouble(0.0)));
            position.set("fuelConsumption", parser.next());
        }
        position.set("battery", parser.nextDouble(0.0));
        position.set("rssi", parser.nextDouble());
        if (!this.newFormat.booleanValue()) {
            position.set("odometer", UnitsConverter.metersFromMiles(parser.nextDouble(0.0)));
        }
        position.setValid(parser.nextInt(0) == 1);
        if (!this.newFormat.booleanValue() || !parser.hasNext(13)) return position;
        position.set("in1", parser.nextInt());
        position.set("in2", parser.nextInt());
        position.set("in3", parser.nextInt());
        position.set("out1", parser.nextInt());
        position.set("adc1", parser.nextDouble());
        position.set("fuel", parser.nextDouble());
        position.set("hours", UnitsConverter.msFromHours(parser.nextInt().intValue()));
        position.set("oilPressure", parser.nextInt());
        position.set("oilLevel", parser.nextInt());
        position.set("oilTemp", parser.nextInt());
        position.set("coolantPressure", parser.nextInt());
        position.set("coolantLevel", parser.nextInt());
        position.set("coolantTemp", parser.nextInt());
        return position;
    }
}

