/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class WialonProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("(dd)(dd)(dd);").number("(dd)(dd)(dd);").number("(dd)(dd.d+);").expression("([NS]);").number("(ddd)(dd.d+);").expression("([EW]);").number("(d+.?d*)?;").number("(d+.?d*)?;").number("(?:NA|(-?d+.?d*));").number("(?:NA|(d+))").groupBegin().text(";").number("(?:NA|(d+.?d*));").number("(?:NA|(d+));").number("(?:NA|(d+));").expression("(?:NA|([^;]*));").expression("(?:NA|([^;]*));").expression("(?:NA|(.*))").groupEnd("?").compile();

    public WialonProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, String prefix, Integer number) {
        if (channel != null) {
            StringBuilder response = new StringBuilder(prefix);
            if (number != null) {
                response.append(number);
            }
            response.append("\r\n");
            channel.writeAndFlush((Object)new NetworkMessage(response.toString(), remoteAddress));
        }
    }

    private Position decodePosition(Channel channel, SocketAddress remoteAddress, String substring) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Parser parser = new Parser(PATTERN, substring);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        if (parser.hasNext()) {
            int satellites = parser.nextInt(0);
            position.setValid(satellites >= 3);
            position.set("sat", satellites);
        }
        position.set("hdop", parser.nextDouble());
        position.set("input", parser.next());
        position.set("output", parser.next());
        if (parser.hasNext()) {
            String[] values = parser.next().split(",");
            for (int i = 0; i < values.length; ++i) {
                position.set("adc" + (i + 1), values[i]);
            }
        }
        position.set("driverUniqueId", parser.next());
        if (parser.hasNext()) {
            String[] values;
            for (String param : values = parser.next().split(",")) {
                Matcher paramParser = Pattern.compile("(.*):[1-3]:(.*)").matcher(param);
                if (!paramParser.matches()) continue;
                try {
                    position.set(paramParser.group(1).toLowerCase(), Double.parseDouble(paramParser.group(2)));
                }
                catch (NumberFormatException e) {
                    position.set(paramParser.group(1).toLowerCase(), paramParser.group(2));
                }
            }
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        String sentence = (String)msg;
        if (sentence.startsWith("#L#")) {
            String[] values = sentence.substring(3).split(";");
            String imei = values[0].indexOf(46) >= 0 ? values[1] : values[0];
            DeviceSession deviceSession2 = this.getDeviceSession(channel, remoteAddress, imei);
            if (deviceSession2 != null) {
                this.sendResponse(channel, remoteAddress, "#AL#", 1);
            }
        } else if (sentence.startsWith("#P#")) {
            this.sendResponse(channel, remoteAddress, "#AP#", null);
        } else if (sentence.startsWith("#SD#") || sentence.startsWith("#D#")) {
            Position position = this.decodePosition(channel, remoteAddress, sentence.substring(sentence.indexOf(35, 1) + 1));
            if (position != null) {
                this.sendResponse(channel, remoteAddress, "#AD#", 1);
                return position;
            }
        } else if (sentence.startsWith("#B#")) {
            String[] messages = sentence.substring(sentence.indexOf(35, 1) + 1).split("\\|");
            LinkedList<Position> positions = new LinkedList<Position>();
            for (String message : messages) {
                Position position = this.decodePosition(channel, remoteAddress, message);
                if (position == null) continue;
                position.set("archive", true);
                positions.add(position);
            }
            this.sendResponse(channel, remoteAddress, "#AB#", messages.length);
            if (!positions.isEmpty()) {
                return positions;
            }
        } else if (sentence.startsWith("#M#") && (deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0])) != null) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, new Date());
            position.setValid(false);
            position.set("result", sentence.substring(sentence.indexOf(35, 1) + 1));
            this.sendResponse(channel, remoteAddress, "#AM#", 1);
            return position;
        }
        return null;
    }
}

