/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class ItsProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$,").expression("[^,]+,").groupBegin().expression("[^,]+,").expression("[^,]+,").groupEnd("?").expression("[^,]+,").groupBegin().number("d+,").expression("[LH],").groupEnd("?").number("(d{15}),").groupBegin().expression("(?:NM|SP),").or().expression("[^,]+,").number("([01]),").groupEnd().number("(dd),?(dd),?(dddd),").number("(dd),?(dd),?(dd),").expression("([AV]),").optional().number("(d+.d+),([NS]),").number("(d+.d+),([EW]),").groupBegin().number("(d+.d+),").number("(d+.d+),").number("(d+),").or().number("(-?d+.d+),").number("(d+.d+),").groupEnd().any().compile();

    public ItsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        if (channel != null && sentence.startsWith("$,01,")) {
            channel.writeAndFlush((Object)new NetworkMessage("$,1,*", remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, sentence)).matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.hasNext()) {
            position.setValid(parser.nextInt() == 1);
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        if (parser.hasNext()) {
            position.setValid(parser.next().equals("A"));
        }
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        if (parser.hasNext(3)) {
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
            position.setCourse(parser.nextDouble());
            position.set("sat", parser.nextInt());
        }
        if (parser.hasNext()) {
            position.setAltitude(parser.nextDouble(0.0));
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        }
        return position;
    }
}

