/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class CguardProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_NV = new PatternBuilder().text("NV:").number("(dd)(dd)(dd) ").number("(dd)(dd)(dd)").number(":(-?d+.d+)").number(":(-?d+.d+)").number(":(d+.?d*)").number(":(?:NAN|(d+.?d*))").number(":(?:NAN|(d+.?d*))").number(":(?:NAN|(d+.?d*))").optional().compile();
    private static final Pattern PATTERN_BC = new PatternBuilder().text("BC:").number("(dd)(dd)(dd) ").number("(dd)(dd)(dd):").expression("(.+)").compile();

    public CguardProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodePosition(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN_NV, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setValid(true);
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setAccuracy(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        return position;
    }

    private Position decodeStatus(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN_BC, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, parser.nextDateTime());
        String[] data = parser.next().split(":");
        block12: for (int i = 0; i < data.length / 2; ++i) {
            String key = data[i * 2];
            String value = data[i * 2 + 1];
            switch (key) {
                case "CSQ1": {
                    position.set("rssi", Integer.parseInt(value));
                    continue block12;
                }
                case "NSQ1": {
                    position.set("sat", Integer.parseInt(value));
                    continue block12;
                }
                case "BAT1": {
                    position.set("batteryLevel", Integer.parseInt(value));
                    continue block12;
                }
                case "PWR1": {
                    position.set("power", Double.parseDouble(value));
                    continue block12;
                }
                default: {
                    position.set(key.toLowerCase(), value);
                }
            }
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("ID:") || sentence.startsWith("IDRO:")) {
            this.getDeviceSession(channel, remoteAddress, sentence.substring(sentence.indexOf(58) + 1));
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        if (sentence.startsWith("NV:")) {
            return this.decodePosition(deviceSession, sentence);
        }
        if (sentence.startsWith("BC:")) {
            return this.decodeStatus(deviceSession, sentence);
        }
        return null;
    }
}

