/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.date.chooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.util.NbBundle;
import tr.prefs.dates.DatesPrefs;

public class DateChooserDialog
extends JDialog
implements ItemListener,
MouseListener,
FocusListener,
KeyListener,
ActionListener {
    private static final Class clazz = DateChooserDialog.class;
    private static final String JANUARY = NbBundle.getMessage((Class)clazz, (String)"january");
    private static final String FEBRUARY = NbBundle.getMessage((Class)clazz, (String)"february");
    private static final String MARCH = NbBundle.getMessage((Class)clazz, (String)"march");
    private static final String APRIL = NbBundle.getMessage((Class)clazz, (String)"april");
    private static final String MAY = NbBundle.getMessage((Class)clazz, (String)"may");
    private static final String JUNE = NbBundle.getMessage((Class)clazz, (String)"june");
    private static final String JULY = NbBundle.getMessage((Class)clazz, (String)"july");
    private static final String AUGUST = NbBundle.getMessage((Class)clazz, (String)"august");
    private static final String SEPTEMBER = NbBundle.getMessage((Class)clazz, (String)"september");
    private static final String OCTOBER = NbBundle.getMessage((Class)clazz, (String)"october");
    private static final String NOVEMBER = NbBundle.getMessage((Class)clazz, (String)"november");
    private static final String DECEMBER = NbBundle.getMessage((Class)clazz, (String)"december");
    private static final String MON = NbBundle.getMessage((Class)clazz, (String)"mon");
    private static final String TUE = NbBundle.getMessage((Class)clazz, (String)"tue");
    private static final String WED = NbBundle.getMessage((Class)clazz, (String)"wed");
    private static final String THU = NbBundle.getMessage((Class)clazz, (String)"thu");
    private static final String FRI = NbBundle.getMessage((Class)clazz, (String)"fri");
    private static final String SAT = NbBundle.getMessage((Class)clazz, (String)"sat");
    private static final String SUN = NbBundle.getMessage((Class)clazz, (String)"sun");
    private static final Color SELECTED_FG_COLOR = UIManager.getDefaults().getColor("List.selectionForeground");
    private static final Color SELECTED_BG_COLOR = UIManager.getDefaults().getColor("List.selectionBackground");
    private static final Color DESELECTED_FG_COLOR = UIManager.getDefaults().getColor("List.foreground");
    private static final Color DESELECTED_BG_COLOR = UIManager.getDefaults().getColor("List.background");
    public static final String DEFAULT_TITLE = NbBundle.getMessage(DateChooserDialog.class, (String)"date.chooser");
    private static final DateFormat DF = new SimpleDateFormat("EEE, d MMM yyyy");
    private static final String[] MONTHS = new String[]{JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST, SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER};
    private static final int MONTH_INDEX_JANUARY = 0;
    private static final int MONTH_INDEX_DECEMBER = 11;
    private static final ImageIcon ICON_BACK = new ImageIcon(DateChooserDialog.class.getResource("/tr/swing/date/chooser/Back16.gif"));
    private static final ImageIcon ICON_NEXT = new ImageIcon(DateChooserDialog.class.getResource("/tr/swing/date/chooser/Next16.gif"));
    private int FIRST_DAY;
    private String[] DAYS;
    private static final String[] DAYS_SUN_FIRST = new String[]{SUN, MON, TUE, WED, THU, FRI, SAT, SUN};
    private static final String[] DAYS_MON_FIRST = new String[]{MON, TUE, WED, THU, FRI, SAT, SUN, MON};
    private static final Dimension DAY_BOX_SIZE = new Dimension(36, 36);
    private static final Color HEADINGS_FOREGROUND = Color.black;
    private static final Color DAYS_FOREGROUND = DESELECTED_FG_COLOR;
    private static final Color DAYS_BACKGROUND = DESELECTED_BG_COLOR;
    private static final Color SELECTED_DAY_FOREGROUND = SELECTED_FG_COLOR;
    private static final Color SELECTED_DAY_BACKGROUND = SELECTED_BG_COLOR;
    private static final Color GRID_BACKGROUND = Color.lightGray;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private static final int FIRST_YEAR = 1900;
    private static final int LAST_YEAR = 2100;
    private GregorianCalendar calendar;
    private JEditorPane todayPane;
    private JLabel[][] days;
    private FocusablePanel daysGrid;
    private JPanel headGrid;
    private JComboBox month;
    private JButton monthLast;
    private JButton monthNext;
    private JButton yearLast;
    private JButton yearNext;
    private JComboBox year;
    private JButton clear;
    private JButton okButton;
    private JButton cancelButton;
    private int offset;
    private int lastDay;
    private JLabel day;
    private boolean okay;
    private boolean cancel;

    private void construct() {
        int i;
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this.cancel = true;
                DateChooserDialog.this.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(cancelListener, stroke, 2);
        this.calendar = new GregorianCalendar();
        this.month = new JComboBox<String>(MONTHS);
        this.month.setPreferredSize(new Dimension(110, 23));
        this.month.addItemListener(this);
        this.month.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    DateChooserDialog.this.goLastMonth();
                } else if (e.getKeyCode() == 39) {
                    DateChooserDialog.this.goNextMonth();
                }
            }
        });
        this.monthLast = new JButton();
        this.monthLast.setFocusable(false);
        this.monthLast.setIcon(ICON_BACK);
        this.monthLast.setMargin(new Insets(0, 0, 0, 0));
        this.monthLast.setMaximumSize(new Dimension(18, 23));
        this.monthLast.setMinimumSize(new Dimension(18, 23));
        this.monthLast.setPreferredSize(new Dimension(18, 23));
        this.monthLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this.goLastMonth();
            }
        });
        this.monthNext = new JButton();
        this.monthNext.setFocusable(false);
        this.monthNext.setIcon(ICON_NEXT);
        this.monthNext.setMargin(new Insets(0, 0, 0, 0));
        this.monthNext.setMaximumSize(new Dimension(18, 23));
        this.monthNext.setMinimumSize(new Dimension(18, 23));
        this.monthNext.setPreferredSize(new Dimension(18, 23));
        this.monthNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this.goNextMonth();
            }
        });
        this.year = new JComboBox();
        this.year.setPreferredSize(new Dimension(110, 23));
        for (i = 1900; i <= 2100; ++i) {
            this.year.addItem(Integer.toString(i));
        }
        this.year.addItemListener(this);
        this.year.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    DateChooserDialog.this.goLastYear();
                } else if (e.getKeyCode() == 39) {
                    DateChooserDialog.this.goNextYear();
                }
            }
        });
        this.yearLast = new JButton();
        this.yearLast.setFocusable(false);
        this.yearLast.setIcon(ICON_BACK);
        this.yearLast.setMargin(new Insets(0, 0, 0, 0));
        this.yearLast.setMaximumSize(new Dimension(18, 23));
        this.yearLast.setMinimumSize(new Dimension(18, 23));
        this.yearLast.setPreferredSize(new Dimension(18, 23));
        this.yearLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this.goLastYear();
            }
        });
        this.yearNext = new JButton();
        this.yearNext.setFocusable(false);
        this.yearNext.setIcon(ICON_NEXT);
        this.yearNext.setMargin(new Insets(0, 0, 0, 0));
        this.yearNext.setMaximumSize(new Dimension(18, 23));
        this.yearNext.setMinimumSize(new Dimension(18, 23));
        this.yearNext.setPreferredSize(new Dimension(18, 23));
        this.yearNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this.goNextYear();
            }
        });
        this.days = new JLabel[7][7];
        for (i = 0; i < 7; ++i) {
            this.days[0][i] = new JLabel(this.DAYS[i], 0);
            this.days[0][i].setOpaque(true);
            this.days[0][i].setForeground(HEADINGS_FOREGROUND);
            this.days[0][i].setPreferredSize(DAY_BOX_SIZE);
            this.days[0][i].setMaximumSize(DAY_BOX_SIZE);
            this.days[0][i].setMinimumSize(DAY_BOX_SIZE);
            this.days[0][i].setFont(this.days[0][i].getFont().deriveFont(1));
        }
        for (i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.days[i][j] = new JLabel(" ", 0);
                this.days[i][j].setOpaque(true);
                this.days[i][j].setForeground(DAYS_FOREGROUND);
                this.days[i][j].setBackground(DAYS_BACKGROUND);
                this.days[i][j].addMouseListener(this);
                this.days[i][j].setPreferredSize(DAY_BOX_SIZE);
                this.days[i][j].setMaximumSize(DAY_BOX_SIZE);
                this.days[i][j].setMinimumSize(DAY_BOX_SIZE);
                this.days[i][j].setFont(this.days[i][j].getFont().deriveFont(1));
            }
        }
        this.clear = new JButton(NbBundle.getMessage(DateChooserDialog.class, (String)"clear"));
        this.clear.addActionListener(this);
        this.okButton = new JButton(NbBundle.getMessage(DateChooserDialog.class, (String)"select"));
        this.okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton(NbBundle.getMessage(DateChooserDialog.class, (String)"cancel"));
        this.cancelButton.addActionListener(this);
        JPanel monthPanel = new JPanel(new FlowLayout(0, 0, 0));
        monthPanel.add(this.monthLast);
        monthPanel.add(this.month);
        monthPanel.add(this.monthNext);
        JPanel yearPanel = new JPanel(new FlowLayout(0, 0, 0));
        yearPanel.add(this.yearLast);
        yearPanel.add(this.year);
        yearPanel.add(this.yearNext);
        JPanel monthYear = new JPanel();
        monthYear.add(monthPanel);
        monthYear.add(yearPanel);
        this.headGrid = new JPanel(new GridLayout(1, 7, 1, 1));
        this.headGrid.addFocusListener(this);
        this.headGrid.addKeyListener(this);
        for (int j = 0; j < 7; ++j) {
            this.headGrid.add(this.days[0][j]);
        }
        this.headGrid.setBorder(EMPTY_BORDER);
        this.daysGrid = new FocusablePanel(new GridLayout(6, 7, 1, 1));
        this.daysGrid.addFocusListener(this);
        this.daysGrid.addKeyListener(this);
        for (int i2 = 1; i2 < 7; ++i2) {
            for (int j = 0; j < 7; ++j) {
                this.daysGrid.add(this.days[i2][j]);
            }
        }
        this.daysGrid.setBackground(GRID_BACKGROUND);
        JPanel daysPanel = new JPanel(new BorderLayout());
        daysPanel.add((Component)this.headGrid, "North");
        daysPanel.add((Component)this.daysGrid, "Center");
        this.todayPane = new JEditorPane();
        this.todayPane.setEditable(false);
        this.todayPane.setBackground(monthPanel.getBackground());
        this.todayPane.setContentType("text/html");
        String today = NbBundle.getMessage(DateChooserDialog.class, (String)"today.is");
        this.todayPane.setText("<html><body><p align='center' style='font-family:sans-serif'>" + today + " <a href=''>" + DF.format(new Date()) + "</a></p><br></body></html>");
        this.todayPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    DateChooserDialog.this.goToday();
                }
            }
        });
        daysPanel.add((Component)this.todayPane, "South");
        JPanel buttons = new JPanel();
        buttons.add(this.clear);
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)monthYear, "North");
        mainPanel.add((Component)daysPanel, "Center");
        mainPanel.add((Component)buttons, "South");
        JPanel fillBottomPanel = new JPanel();
        fillBottomPanel.setPreferredSize(new Dimension(0, 32));
        JPanel fillWestPanel = new JPanel();
        fillWestPanel.setPreferredSize(new Dimension(32, 0));
        JPanel fillEastPanel = new JPanel();
        fillEastPanel.setPreferredSize(new Dimension(32, 0));
        Container dialog = this.getContentPane();
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)mainPanel, "Center");
        dialog.add((Component)fillBottomPanel, "South");
        dialog.add((Component)fillWestPanel, "West");
        dialog.add((Component)fillEastPanel, "East");
        this.pack();
        this.setResizable(false);
        this.daysGrid.requestFocusInWindow();
    }

    private int getSelectedDay() {
        if (this.day == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.day.getText());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void setSelected(JLabel newDay) {
        if (this.day != null) {
            this.day.setForeground(DAYS_FOREGROUND);
            this.day.setBackground(DAYS_BACKGROUND);
        }
        this.day = newDay;
        this.day.setForeground(SELECTED_DAY_FOREGROUND);
        this.day.setBackground(SELECTED_DAY_BACKGROUND);
        this.daysGrid.requestFocusInWindow();
    }

    private void goToday() {
        Calendar cal = Calendar.getInstance();
        this.year.setSelectedIndex(cal.get(1) - 1900);
        this.month.setSelectedIndex(cal.get(2) - 0);
        this.setSelected(cal.get(5));
    }

    private void goLastMonth() {
        int i = this.month.getSelectedIndex() - 1;
        if (i >= 0) {
            this.month.setSelectedIndex(i);
            this.update();
        } else {
            this.month.setSelectedIndex(11);
            this.goLastYear();
        }
    }

    private void goNextMonth() {
        int i = this.month.getSelectedIndex() + 1;
        if (i <= 11) {
            this.month.setSelectedIndex(i);
            this.update();
        } else {
            this.month.setSelectedIndex(0);
            this.goNextYear();
        }
    }

    private void goLastYear() {
        int i = this.year.getSelectedIndex() - 1;
        if (i > -1) {
            this.year.setSelectedIndex(i);
            this.update();
        }
    }

    private void goNextYear() {
        int i = this.year.getSelectedIndex() + 1;
        if (i < this.year.getItemCount()) {
            this.year.setSelectedIndex(i);
            this.update();
        }
    }

    private void setSelected(int newDay) {
        this.setSelected(this.days[(newDay + this.offset - 1) / 7 + 1][(newDay + this.offset - 1) % 7]);
    }

    private void update() {
        int i;
        int iday = this.getSelectedDay();
        for (i = 0; i < 7; ++i) {
            this.days[1][i].setText(" ");
            this.days[5][i].setText(" ");
            this.days[6][i].setText(" ");
        }
        this.calendar.set(5, 1);
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        this.offset = this.calendar.get(7) - 1;
        if (this.FIRST_DAY == 2) {
            this.offset = this.offset > 0 ? this.offset - 1 : 6;
        }
        this.lastDay = this.calendar.getActualMaximum(5);
        for (i = 0; i < this.lastDay; ++i) {
            this.days[(i + this.offset) / 7 + 1][(i + this.offset) % 7].setText(String.valueOf(i + 1));
        }
        if (iday != -1) {
            if (iday > this.lastDay) {
                iday = this.lastDay;
            }
            this.setSelected(iday);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.okay = true;
        } else if (e.getSource() == this.cancelButton) {
            this.cancel = true;
        }
        this.setVisible(false);
    }

    public void focusGained(FocusEvent e) {
        this.setSelected(this.day);
    }

    public void focusLost(FocusEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        this.update();
    }

    public void keyPressed(KeyEvent e) {
        int iday = this.getSelectedDay();
        switch (e.getKeyCode()) {
            case 37: {
                if (iday <= 1) break;
                this.setSelected(iday - 1);
                break;
            }
            case 39: {
                if (iday >= this.lastDay) break;
                this.setSelected(iday + 1);
                break;
            }
            case 38: {
                if (iday <= 7) break;
                this.setSelected(iday - 7);
                break;
            }
            case 40: {
                if (iday > this.lastDay - 7) break;
                this.setSelected(iday + 7);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        JLabel theDay = (JLabel)e.getSource();
        if (!theDay.getText().equals(" ")) {
            this.setSelected(theDay);
        }
        if (e.getClickCount() > 1) {
            this.okay = true;
            this.cancel = false;
            this.setVisible(false);
        } else {
            this.daysGrid.requestFocus();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public DateChooserDialog(Frame owner) {
        this(owner, DEFAULT_TITLE);
    }

    public DateChooserDialog(Frame owner, String title) {
        super(owner, title, true);
        this.initialise();
    }

    public DateChooserDialog(Dialog owner) {
        this(owner, DEFAULT_TITLE);
    }

    public DateChooserDialog(Dialog owner, String title) {
        super(owner, title, true);
        this.initialise();
    }

    private void initialise() {
        this.setDefaultCloseOperation(1);
        this.FIRST_DAY = DatesPrefs.getFirstDayOfWeek();
        this.DAYS = this.FIRST_DAY == 2 ? DAYS_MON_FIRST : DAYS_SUN_FIRST;
    }

    public Date select(Date date, Component component) {
        if (this.calendar == null) {
            this.construct();
        }
        int hour = 0;
        int min = 0;
        int sec = 0;
        int msec = 0;
        if (date == null) {
            date = new Date();
            this.calendar.setTime(date);
        } else {
            this.calendar.setTime(date);
            hour = this.calendar.get(11);
            min = this.calendar.get(12);
            sec = this.calendar.get(13);
            msec = this.calendar.get(14);
        }
        int _year = this.calendar.get(1);
        int _month = this.calendar.get(2);
        int _day = this.calendar.get(5);
        this.year.setSelectedIndex(_year - 1900);
        this.month.setSelectedIndex(_month - 0);
        this.setSelected(_day);
        this.okay = false;
        this.cancel = false;
        if (component != null) {
            this.setLocationRelativeTo(component);
        }
        this.daysGrid.requestFocusInWindow();
        this.setVisible(true);
        if (!this.okay) {
            return null;
        }
        this.calendar.set(5, this.getSelectedDay());
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        this.calendar.set(11, hour);
        this.calendar.set(12, min);
        this.calendar.set(13, sec);
        this.calendar.set(14, msec);
        return this.calendar.getTime();
    }

    public boolean cancelled() {
        return this.cancel;
    }

    public boolean okayed() {
        return this.okay;
    }

    private static class FocusablePanel
    extends JPanel {
        public FocusablePanel(LayoutManager layout) {
            super(layout);
        }

        public boolean isFocusable() {
            return true;
        }
    }
}

