/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class VersionBucket {
    private int lockTimeoutMs;
    private final Lock lock = new ReentrantLock(true);
    private final Condition condition = this.lock.newCondition();
    public long highest;

    public VersionBucket(int lockTimeoutMs) {
        this.lockTimeoutMs = lockTimeoutMs;
    }

    public void updateHighest(long val) {
        if (this.highest != 0L) {
            this.highest = Math.max(this.highest, Math.abs(val));
        }
    }

    public int getLockTimeoutMs() {
        return this.lockTimeoutMs;
    }

    public boolean tryLock() {
        try {
            return this.lock.tryLock(this.lockTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void signalAll() {
        this.condition.signalAll();
    }

    public void awaitNanos(long nanosTimeout) {
        try {
            this.condition.awaitNanos(nanosTimeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

