/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Header;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.Edition;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.connector.ConnectionClosingRepresentation;
import org.restlet.engine.connector.HttpClientHelper;
import org.restlet.engine.ssl.SslContextFactory;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class HttpUrlConnectionCall
extends ClientCall {
    private final HttpURLConnection connection;
    private volatile boolean responseHeadersAdded;

    public HttpUrlConnectionCall(HttpClientHelper helper, String method, String requestUri, boolean hasEntity) throws IOException {
        super(helper, method, requestUri);
        if (requestUri.startsWith("http")) {
            URL url = new URL(requestUri);
            this.connection = (HttpURLConnection)url.openConnection();
            int majorVersionNumber = SystemUtils.getJavaMajorVersion();
            int minorVersionNumber = SystemUtils.getJavaMinorVersion();
            if (majorVersionNumber > 1 || majorVersionNumber == 1 && minorVersionNumber >= 5) {
                this.connection.setConnectTimeout(this.getHelper().getSocketConnectTimeoutMs());
                this.connection.setReadTimeout(this.getHelper().getReadTimeout());
            }
            this.connection.setAllowUserInteraction(this.getHelper().isAllowUserInteraction());
            this.connection.setDoOutput(hasEntity);
            this.connection.setInstanceFollowRedirects(this.getHelper().isFollowRedirects());
            this.connection.setUseCaches(this.getHelper().isUseCaches());
            this.responseHeadersAdded = false;
            if (this.connection instanceof HttpsURLConnection) {
                HostnameVerifier verifier;
                this.setConfidential(true);
                HttpsURLConnection https = (HttpsURLConnection)this.connection;
                SslContextFactory sslContextFactory = SslUtils.getSslContextFactory(this.getHelper());
                if (sslContextFactory != null) {
                    try {
                        SSLContext sslContext = sslContextFactory.createSslContext();
                        https.setSSLSocketFactory(sslContext.getSocketFactory());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to create SSLContext.", e);
                    }
                }
                if ((verifier = helper.getHostnameVerifier()) != null) {
                    https.setHostnameVerifier(verifier);
                }
            }
        } else {
            throw new IllegalArgumentException("Only HTTP or HTTPS resource URIs are allowed here");
        }
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    @Override
    public HttpClientHelper getHelper() {
        return (HttpClientHelper)super.getHelper();
    }

    @Override
    public String getReasonPhrase() {
        try {
            return this.getConnection().getResponseMessage();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Representation getRepresentation(InputStream stream) {
        Representation r = super.getRepresentation(stream);
        return new ConnectionClosingRepresentation(r, this.getConnection());
    }

    @Override
    public WritableByteChannel getRequestEntityChannel() {
        return null;
    }

    @Override
    public OutputStream getRequestEntityStream() {
        return this.getRequestStream();
    }

    @Override
    public OutputStream getRequestHeadStream() {
        return this.getRequestStream();
    }

    public OutputStream getRequestStream() {
        try {
            return this.getConnection().getOutputStream();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public ReadableByteChannel getResponseEntityChannel(long size) {
        return null;
    }

    @Override
    public InputStream getResponseEntityStream(long size) {
        InputStream result = null;
        try {
            result = this.getConnection().getInputStream();
        }
        catch (IOException ioe) {
            result = this.getConnection().getErrorStream();
        }
        if (result == null) {
            result = this.getConnection().getErrorStream();
        }
        return result;
    }

    @Override
    public Series<Header> getResponseHeaders() {
        Series<Header> result = super.getResponseHeaders();
        if (!this.responseHeadersAdded) {
            boolean loop = true;
            int i = 0;
            String headerName = null;
            String headerValue = null;
            while (loop) {
                try {
                    headerName = this.getConnection().getHeaderFieldKey(i);
                    headerValue = this.getConnection().getHeaderField(i);
                }
                catch (NoSuchElementException e) {
                    headerName = null;
                }
                if (headerName != null) {
                    result.add(headerName, headerValue);
                } else {
                    loop = i == 0;
                }
                ++i;
            }
            this.responseHeadersAdded = true;
        }
        return result;
    }

    @Override
    public String getServerAddress() {
        return this.getConnection().getURL().getHost();
    }

    @Override
    public int getStatusCode() throws IOException {
        return this.getConnection().getResponseCode();
    }

    @Override
    public Status sendRequest(Request request) {
        Status result = null;
        try {
            if (request.isEntityAvailable()) {
                Representation entity = request.getEntity();
                int majorVersionNumber = SystemUtils.getJavaMajorVersion();
                int minorVersionNumber = SystemUtils.getJavaMinorVersion();
                if (majorVersionNumber > 1 || majorVersionNumber == 1 && minorVersionNumber >= 5) {
                    if (entity.getSize() != -1L) {
                        this.getConnection().setFixedLengthStreamingMode((int)entity.getSize());
                    } else if (this.getHelper().getChunkLength() >= 0) {
                        this.getConnection().setChunkedStreamingMode(this.getHelper().getChunkLength());
                    }
                }
            }
            this.getConnection().setRequestMethod(this.getMethod());
            for (Header header : this.getRequestHeaders()) {
                this.getConnection().addRequestProperty(header.getName(), header.getValue());
            }
            if (Edition.CURRENT == Edition.GAE && request.getProtocol() == Protocol.SDC) {
                this.getConnection().getRequestProperties().remove("Proxy-Authorization");
                this.getConnection().setRequestProperty("use_intranet", "true");
            }
            this.getConnection().connect();
            result = super.sendRequest(request);
        }
        catch (ConnectException ce) {
            this.getHelper().getLogger().log(Level.FINE, "An error occurred during the connection to the remote HTTP server.", ce);
            result = new Status(Status.CONNECTOR_ERROR_CONNECTION, (Throwable)ce);
        }
        catch (SocketTimeoutException ste) {
            this.getHelper().getLogger().log(Level.FINE, "An timeout error occurred during the communication with the remote HTTP server.", ste);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ste);
        }
        catch (FileNotFoundException fnfe) {
            this.getHelper().getLogger().log(Level.FINE, "An unexpected error occurred during the sending of the HTTP request.", fnfe);
            result = new Status(Status.CONNECTOR_ERROR_INTERNAL, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.FINE, "An error occurred during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ioe);
        }
        catch (Exception e) {
            this.getHelper().getLogger().log(Level.FINE, "An unexpected error occurred during the sending of the HTTP request.", e);
            result = new Status(Status.CONNECTOR_ERROR_INTERNAL, (Throwable)e);
        }
        return result;
    }

    @Override
    public void sendRequest(Request request, Response response, Uniform callback) throws Exception {
        this.sendRequest(request);
        if (request.getOnSent() != null) {
            request.getOnSent().handle(request, response);
        }
        if (callback != null) {
            callback.handle(request, response);
        }
    }
}

