/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Date;
import org.restlet.data.Parameter;
import org.restlet.engine.util.DateUtils;
import org.restlet.util.Series;

public class Disposition {
    public static final String NAME_CREATION_DATE = "creation-date";
    public static final String NAME_FILENAME = "filename";
    public static final String NAME_MODIFICATION_DATE = "modification-date";
    public static final String NAME_READ_DATE = "read-date";
    public static final String NAME_SIZE = "size";
    public static final String TYPE_ATTACHMENT = "attachment";
    public static final String TYPE_INLINE = "inline";
    public static final String TYPE_NONE = "none";
    private Series<Parameter> parameters;
    private String type;

    public Disposition() {
        this(TYPE_NONE);
    }

    public Disposition(String type) {
        this.type = type;
    }

    public Disposition(String type, Series<Parameter> parameters) {
        this(type);
        this.parameters = parameters;
    }

    public void addDate(String name, Date value) {
        this.getParameters().add(name, DateUtils.format(value, DateUtils.FORMAT_RFC_822.get(0)));
    }

    public String getFilename() {
        return this.getParameters().getFirstValue(NAME_FILENAME, true);
    }

    public Series<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new Series<Parameter>(Parameter.class);
        }
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public void setCreationDate(Date value) {
        this.setDate(NAME_CREATION_DATE, value);
    }

    public void setDate(String name, Date value) {
        this.getParameters().set(name, DateUtils.format(value, DateUtils.FORMAT_RFC_822.get(0)), true);
    }

    public void setFilename(String fileName) {
        this.getParameters().set(NAME_FILENAME, fileName, true);
    }

    public void setModificationDate(Date value) {
        this.setDate(NAME_MODIFICATION_DATE, value);
    }

    public void setParameters(Series<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setReadDate(Date value) {
        this.setDate(NAME_READ_DATE, value);
    }

    public void setSize(long size) {
        this.getParameters().set(NAME_SIZE, Long.toString(size), true);
    }

    public void setType(String type) {
        this.type = type;
    }
}

