/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.facet.DoubleFuncSlotAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDoubleMerger;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetSortableMerger;
import org.apache.solr.search.facet.FieldUtil;
import org.apache.solr.search.facet.LongFuncSlotAcc;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.function.FieldNameValueSource;

public class MinMaxAgg
extends SimpleAggValueSource {
    final int minmax;

    public MinMaxAgg(String minOrMax, ValueSource vs) {
        super(minOrMax, vs);
        this.minmax = "min".equals(this.name) ? 1 : -1;
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        SchemaField sf = null;
        if (vs instanceof FieldNameValueSource) {
            String field = ((FieldNameValueSource)vs).getFieldName();
            sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                vs = null;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "min/max aggregations can't be used on multi-valued field " + field);
            }
            vs = sf.getType().getValueSource(sf, null);
        }
        if (vs instanceof StrFieldSource) {
            return new SingleValuedOrdAcc(fcontext, sf, numSlots);
        }
        if (sf != null && sf.getType().getNumberType() != null) {
            switch (sf.getType().getNumberType()) {
                case FLOAT: 
                case DOUBLE: {
                    return new DFuncAcc(vs, fcontext, numSlots);
                }
                case INTEGER: 
                case LONG: {
                    return new LFuncAcc(vs, fcontext, numSlots);
                }
                case DATE: {
                    return new DateFuncAcc(vs, fcontext, numSlots);
                }
            }
        }
        return new DFuncAcc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        if (prototype instanceof Double) {
            return new NumericMerger();
        }
        if (prototype instanceof Comparable) {
            return new ComparableMerger();
        }
        throw new UnsupportedOperationException("min/max merge of " + prototype);
    }

    class SingleValuedOrdAcc
    extends OrdAcc {
        SortedDocValues topLevel;
        SortedDocValues[] subDvs;
        OrdinalMap ordMap;
        LongValues toGlobal;
        SortedDocValues subDv;

        public SingleValuedOrdAcc(FacetContext fcontext, SchemaField field, int numSlots) throws IOException {
            super(fcontext, field, numSlots);
        }

        @Override
        public void resetIterators() throws IOException {
            super.resetIterators();
            this.topLevel = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.field, null);
            if (this.topLevel instanceof MultiDocValues.MultiSortedDocValues) {
                this.ordMap = ((MultiDocValues.MultiSortedDocValues)this.topLevel).mapping;
                this.subDvs = ((MultiDocValues.MultiSortedDocValues)this.topLevel).values;
            } else {
                this.ordMap = null;
                this.subDvs = null;
            }
        }

        @Override
        protected BytesRef lookupOrd(int ord) throws IOException {
            return this.topLevel.lookupOrd(ord);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            if (this.subDvs != null) {
                this.subDv = this.subDvs[readerContext.ord];
                this.toGlobal = this.ordMap.getGlobalOrds(readerContext.ord);
                assert (this.toGlobal != null);
            } else {
                assert (readerContext.ord == 0 || this.topLevel.getValueCount() == 0);
                this.subDv = this.topLevel;
            }
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            if (this.subDv.advanceExact(doc)) {
                int ord;
                int segOrd = this.subDv.ordValue();
                int n = ord = this.toGlobal == null ? segOrd : (int)this.toGlobal.get((long)segOrd);
                if ((ord - this.slotOrd[slotNum]) * MinMaxAgg.this.minmax < 0 || this.slotOrd[slotNum] == -1) {
                    this.slotOrd[slotNum] = ord;
                }
            }
        }
    }

    abstract class OrdAcc
    extends SlotAcc {
        static final int MISSING = -1;
        SchemaField field;
        int[] slotOrd;

        public OrdAcc(FacetContext fcontext, SchemaField field, int numSlots) throws IOException {
            super(fcontext);
            this.field = field;
            this.slotOrd = new int[numSlots];
            Arrays.fill(this.slotOrd, -1);
        }

        abstract BytesRef lookupOrd(int var1) throws IOException;

        @Override
        public int compare(int slotA, int slotB) {
            int a = this.slotOrd[slotA];
            int b = this.slotOrd[slotB];
            return a - b;
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            int globOrd = this.slotOrd[slotNum];
            if (globOrd == -1) {
                return null;
            }
            BytesRef term = this.lookupOrd(globOrd);
            return this.field.getType().toObject(this.field, term);
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.slotOrd, -1);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.slotOrd = resizer.resize(this.slotOrd, -1);
        }
    }

    class DateFuncAcc
    extends LongFuncSlotAcc {
        private static final long MISSING = Long.MIN_VALUE;

        public DateFuncAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots, Long.MIN_VALUE);
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            long val = this.values.longVal(doc);
            if (val == 0L && !this.values.exists(doc)) {
                return;
            }
            long currVal = this.result[slotNum];
            if (Long.compare(val, currVal) * MinMaxAgg.this.minmax < 0 || currVal == Long.MIN_VALUE) {
                this.result[slotNum] = val;
            }
        }

        @Override
        public Object getValue(int slot) {
            return this.result[slot] == Long.MIN_VALUE ? null : new Date(this.result[slot]);
        }
    }

    class LFuncAcc
    extends LongFuncSlotAcc {
        FixedBitSet exists;

        public LFuncAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots, 0L);
            this.exists = new FixedBitSet(numSlots);
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            long val = this.values.longVal(doc);
            if (val == 0L && !this.values.exists(doc)) {
                return;
            }
            long currVal = this.result[slotNum];
            if (currVal == 0L && !this.exists.get(slotNum)) {
                this.exists.set(slotNum);
                this.result[slotNum] = val;
            } else if (Long.compare(val, currVal) * MinMaxAgg.this.minmax < 0) {
                this.result[slotNum] = val;
            }
        }

        @Override
        public Object getValue(int slot) {
            long val = this.result[slot];
            if (val == 0L && !this.exists.get(slot)) {
                return null;
            }
            return val;
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            super.resize(resizer);
            this.exists = resizer.resize(this.exists);
        }

        @Override
        public int compare(int slotA, int slotB) {
            boolean eb;
            long a = this.result[slotA];
            long b = this.result[slotB];
            boolean ea = a != 0L || this.exists.get(slotA);
            boolean bl = eb = b != 0L || this.exists.get(slotB);
            if (ea != eb) {
                if (ea) {
                    return 1;
                }
                if (eb) {
                    return -1;
                }
            }
            return Long.compare(a, b);
        }

        @Override
        public void reset() {
            super.reset();
            this.exists.clear(0, this.exists.length());
        }
    }

    class DFuncAcc
    extends DoubleFuncSlotAcc {
        public DFuncAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots, Double.NaN);
        }

        @Override
        public void collect(int doc, int slotNum, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            double val = this.values.doubleVal(doc);
            if (val == 0.0 && !this.values.exists(doc)) {
                return;
            }
            double currVal = this.result[slotNum];
            if (Double.compare(val, currVal) * MinMaxAgg.this.minmax < 0 || Double.isNaN(currVal)) {
                this.result[slotNum] = val;
            }
        }

        @Override
        public Object getValue(int slot) {
            double val = this.result[slot];
            if (Double.isNaN(val)) {
                return null;
            }
            return val;
        }
    }

    private class ComparableMerger
    extends FacetSortableMerger {
        Comparable val;

        private ComparableMerger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            Comparable other = (Comparable)facetResult;
            if (this.val == null) {
                this.val = other;
            } else if (other.compareTo(this.val) * MinMaxAgg.this.minmax < 0) {
                this.val = other;
            }
        }

        @Override
        public Object getMergedResult() {
            return this.val;
        }

        @Override
        public int compareTo(FacetSortableMerger other, FacetRequest.SortDirection direction) {
            return this.val.compareTo(((ComparableMerger)other).val);
        }
    }

    private class NumericMerger
    extends FacetDoubleMerger {
        double val = Double.NaN;

        private NumericMerger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            double result = ((Number)facetResult).doubleValue();
            if (Double.compare(result, this.val) * MinMaxAgg.this.minmax < 0 || Double.isNaN(this.val)) {
                this.val = result;
            }
        }

        @Override
        protected double getDouble() {
            return this.val;
        }
    }
}

