/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.JoinQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.ScoreJoinQParserPlugin;

public class JoinQParserPlugin
extends QParserPlugin {
    public static final String NAME = "join";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                if (this.localParams != null && this.localParams.get("score") != null) {
                    return new ScoreJoinQParserPlugin().createParser(this.qstr, this.localParams, this.params, this.req).parse();
                }
                return this.parseJoin();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            Query parseJoin() throws SyntaxError {
                fromField = this.getParam("from");
                fromIndex = this.getParam("fromIndex");
                toField = this.getParam("to");
                v = this.localParams.get("v");
                fromCoreOpenTime = 0L;
                if (fromIndex != null && !fromIndex.equals(this.req.getCore().getCoreDescriptor().getName())) {
                    container = this.req.getCore().getCoreContainer();
                    fromCore = container.getCore(coreName = ScoreJoinQParserPlugin.getCoreName(fromIndex, container));
                    if (fromCore == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + coreName);
                    }
                    fromHolder = null;
                    otherReq = new LocalSolrQueryRequest(fromCore, this.params);
                    try {
                        parser = QParser.getParser(v, otherReq);
                        fromQuery = parser.getQuery();
                        fromHolder = fromCore.getRegisteredSearcher();
                        if (fromHolder == null) ** GOTO lbl30
                        fromCoreOpenTime = fromHolder.get().getOpenNanoTime();
                    }
                    finally {
                        otherReq.close();
                        fromCore.close();
                        if (fromHolder != null) {
                            fromHolder.decref();
                        }
                    }
                } else {
                    coreName = null;
                    fromQueryParser = this.subQuery(v, null);
                    fromQueryParser.setIsFilter(true);
                    fromQuery = fromQueryParser.getQuery();
                }
lbl30:
                // 3 sources

                jq = new JoinQuery(fromField, toField, coreName == null ? fromIndex : coreName, fromQuery);
                jq.fromCoreOpenTime = fromCoreOpenTime;
                return jq;
            }
        };
    }

    public static Query createJoinQuery(Query subQuery, String fromField, String toField) {
        return new JoinQuery(fromField, toField, null, subQuery);
    }
}

