/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.params.TermsParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.PointMerger;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.BoundedTreeSet;

public class TermsComponent
extends SearchComponent {
    public static final int UNLIMITED_MAX_COUNT = -1;
    public static final String COMPONENT_NAME = "terms";
    private HttpShardHandlerFactory.WhitelistHostChecker whitelistHostChecker = new HttpShardHandlerFactory.WhitelistHostChecker(null, !HttpShardHandlerFactory.doGetDisableShardsWhitelist());

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.whitelistHostChecker = new HttpShardHandlerFactory.WhitelistHostChecker((String)args.get("shardsWhitelist"), !HttpShardHandlerFactory.doGetDisableShardsWhitelist());
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.get(COMPONENT_NAME, "false").equals("true")) {
            return;
        }
        rb.doTerms = true;
        String shards = params.get("shards");
        if (shards != null) {
            rb.isDistrib = true;
            if (params.get("shards.qt") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shards.qt parameter specified");
            }
            List lst = StrUtils.splitSmart((String)shards, (String)",", (boolean)true);
            this.checkShardsWhitelist(rb, lst);
            rb.shards = lst.toArray(new String[lst.size()]);
        }
    }

    protected void checkShardsWhitelist(ResponseBuilder rb, List<String> lst) {
        LinkedList<String> urls = new LinkedList<String>();
        for (String ele : lst) {
            urls.addAll(StrUtils.splitSmart((String)ele, (char)'|'));
        }
        if (this.whitelistHostChecker.isWhitelistHostCheckingEnabled() && rb.req.getCore().getCoreContainer().getZkController() == null && !this.whitelistHostChecker.hasExplicitWhitelist()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "TermsComponent shardsWhitelist not configured but required when using the 'shards' parameter with the TermsComponent. set -Dsolr.disable.shardsWhitelist=true to disable shards whitelist checks");
        }
        ClusterState cs = null;
        if (rb.req.getCore().getCoreContainer().getZkController() != null) {
            cs = rb.req.getCore().getCoreContainer().getZkController().getClusterState();
        }
        this.whitelistHostChecker.checkWhitelist(cs, ((Object)urls).toString(), urls);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(ResponseBuilder rb) throws IOException {
        String termList;
        SolrParams params = rb.req.getParams();
        if (!params.get(COMPONENT_NAME, "false").equals("true")) {
            return;
        }
        String[] fields = params.getParams("terms.fl");
        SimpleOrderedMap termsResult = new SimpleOrderedMap();
        rb.rsp.add(COMPONENT_NAME, termsResult);
        if (fields == null || fields.length == 0) {
            return;
        }
        boolean termStats = params.getBool("terms.stats", false);
        if (termStats) {
            SimpleOrderedMap stats = new SimpleOrderedMap();
            rb.rsp.add("indexstats", stats);
            TermsComponent.collectStats(rb.req.getSearcher(), (NamedList<Number>)stats);
        }
        if ((termList = params.get("terms.list")) != null) {
            boolean includeTotalTermFreq = params.getBool("terms.ttf", false);
            TermsComponent.fetchTerms(rb.req.getSearcher(), fields, termList, includeTotalTermFreq, (NamedList<Object>)termsResult);
            return;
        }
        int _limit = params.getInt("terms.limit", 10);
        int limit = _limit < 0 ? Integer.MAX_VALUE : _limit;
        String lowerStr = params.get("terms.lower");
        String upperStr = params.get("terms.upper");
        boolean upperIncl = params.getBool("terms.upper.incl", false);
        boolean lowerIncl = params.getBool("terms.lower.incl", true);
        boolean sort = !"index".equals(params.get("terms.sort", "count"));
        int freqmin = params.getInt("terms.mincount", 1);
        int _freqmax = params.getInt("terms.maxcount", -1);
        int freqmax = _freqmax < 0 ? Integer.MAX_VALUE : _freqmax;
        String prefix = params.get("terms.prefix");
        String regexp = params.get("terms.regex");
        Pattern pattern = regexp != null ? Pattern.compile(regexp, this.resolveRegexpFlags(params)) : null;
        boolean raw = params.getBool("terms.raw", false);
        LeafReader indexReader = rb.req.getSearcher().getSlowAtomicReader();
        block0: for (String field : fields) {
            void var33_46;
            BytesRef lowerBytes;
            FieldType ft;
            NamedList fieldTerms = new NamedList();
            Terms terms = indexReader.terms(field);
            if (terms == null) {
                SchemaField sf = rb.req.getSchema().getFieldOrNull(field);
                if (sf != null && sf.getType().isPointField()) {
                    MutableValue mv;
                    PointMerger.ValueIterator valueIterator;
                    if (lowerStr != null || upperStr != null || prefix != null || regexp != null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "The terms component does not support Points-based fields with sorting or with parameters %s,%s,%s,%s ", "terms.lower", "terms.upper", "terms.prefix", "terms.regex"));
                    }
                    if (sort) {
                        long count;
                        BoundedTreeSet<SimpleFacets.CountPair<MutableValue, Integer>> queue;
                        valueIterator = new PointMerger.ValueIterator(sf, rb.req.getSearcher().getRawReader().leaves());
                        mv = valueIterator.getMutableValue();
                        BoundedTreeSet<SimpleFacets.CountPair<MutableValue, Integer>> boundedTreeSet = queue = sort ? new BoundedTreeSet<SimpleFacets.CountPair<MutableValue, Integer>>(limit) : null;
                        while ((count = valueIterator.getNextCount()) >= 0L) {
                            if (count < (long)freqmin || count > (long)freqmax || queue.size() >= limit && (long)((Integer)((SimpleFacets.CountPair)queue.last()).val).intValue() >= count && ((long)((Integer)((SimpleFacets.CountPair)queue.last()).val).intValue() != count || ((MutableValue)((SimpleFacets.CountPair)queue.last()).key).compareTo(mv) >= 0)) continue;
                            queue.add(new SimpleFacets.CountPair<MutableValue, Integer>(mv.duplicate(), (int)count));
                        }
                        for (SimpleFacets.CountPair countPair : queue) {
                            fieldTerms.add(((MutableValue)countPair.key).toString(), countPair.val);
                        }
                        termsResult.add(field, (Object)fieldTerms);
                        continue;
                    }
                    if (!sort) {
                        long count;
                        valueIterator = new PointMerger.ValueIterator(sf, rb.req.getSearcher().getRawReader().leaves());
                        mv = valueIterator.getMutableValue();
                        int num = 0;
                        while ((count = valueIterator.getNextCount()) >= 0L) {
                            if (count < (long)freqmin || count > (long)freqmax) continue;
                            if (++num > limit) break;
                            fieldTerms.add(mv.toString(), (Object)((int)count));
                        }
                        termsResult.add(field, (Object)fieldTerms);
                        continue;
                    }
                }
                termsResult.add(field, (Object)fieldTerms);
                continue;
            }
            termsResult.add(field, (Object)fieldTerms);
            FieldType fieldType = ft = raw ? null : rb.req.getSchema().getFieldTypeNoEx(field);
            if (ft == null) {
                ft = new StrField();
            }
            BytesRef prefixBytes = prefix == null ? null : new BytesRef((CharSequence)prefix);
            BytesRef upperBytes = null;
            if (upperStr != null) {
                BytesRefBuilder b = new BytesRefBuilder();
                ft.readableToIndexed(upperStr, b);
                upperBytes = b.get();
            }
            if (lowerStr == null) {
                lowerBytes = prefixBytes;
            } else {
                lowerBytes = new BytesRef();
                if (raw) {
                    lowerBytes = new BytesRef((CharSequence)lowerStr);
                } else {
                    BytesRefBuilder b = new BytesRefBuilder();
                    ft.readableToIndexed(lowerStr, b);
                    lowerBytes = b.get();
                }
            }
            TermsEnum termsEnum = terms.iterator();
            Object var33_41 = null;
            if (lowerBytes != null) {
                if (termsEnum.seekCeil(lowerBytes) == TermsEnum.SeekStatus.END) {
                    termsEnum = null;
                } else {
                    BytesRef bytesRef = termsEnum.term();
                    if (!lowerIncl && bytesRef.equals((Object)lowerBytes)) {
                        BytesRef bytesRef2 = termsEnum.next();
                    }
                }
            } else {
                BytesRef bytesRef = termsEnum.next();
            }
            int i = 0;
            BoundedTreeSet<SimpleFacets.CountPair<BytesRef, Integer>> queue = sort ? new BoundedTreeSet<SimpleFacets.CountPair<BytesRef, Integer>>(limit) : null;
            CharsRefBuilder external = new CharsRefBuilder();
            while (var33_46 != null && (i < limit || sort)) {
                int n;
                boolean externalized = false;
                if (prefixBytes != null && !StringHelper.startsWith((BytesRef)var33_46, (BytesRef)prefixBytes)) break;
                if (pattern != null) {
                    ft.indexedToReadable((BytesRef)var33_46, external);
                    externalized = true;
                    if (!pattern.matcher((CharSequence)external.get()).matches()) {
                        BytesRef bytesRef = termsEnum.next();
                        continue;
                    }
                }
                if (upperBytes != null && ((n = var33_46.compareTo(upperBytes)) > 0 || n == 0 && !upperIncl)) break;
                n = termsEnum.docFreq();
                if (n >= freqmin && n <= freqmax) {
                    if (sort) {
                        queue.add(new SimpleFacets.CountPair<BytesRef, Integer>(BytesRef.deepCopyOf((BytesRef)var33_46), n));
                    } else {
                        if (!externalized) {
                            ft.indexedToReadable((BytesRef)var33_46, external);
                        }
                        fieldTerms.add(external.toString(), (Object)n);
                        ++i;
                    }
                }
                BytesRef bytesRef = termsEnum.next();
            }
            if (!sort) continue;
            for (SimpleFacets.CountPair countPair : queue) {
                if (i >= limit) continue block0;
                ft.indexedToReadable((BytesRef)countPair.key, external);
                fieldTerms.add(external.toString(), countPair.val);
                ++i;
            }
        }
    }

    int resolveRegexpFlags(SolrParams params) {
        String[] flagParams = params.getParams("terms.regex.flag");
        if (flagParams == null) {
            return 0;
        }
        int flags = 0;
        for (String flagParam : flagParams) {
            try {
                flags |= TermsParams.TermsRegexpFlag.valueOf((String)flagParam.toUpperCase(Locale.ROOT)).getValue();
            }
            catch (IllegalArgumentException iae) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown terms regex flag '" + flagParam + "'");
            }
        }
        return flags;
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.doTerms) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            TermsHelper th = rb._termsHelper;
            if (th == null) {
                th = rb._termsHelper = new TermsHelper();
                th.init(rb.req.getParams());
            }
            ShardRequest sreq = TermsComponent.createShardQuery(rb.req.getParams());
            rb.addRequest(this, sreq);
        }
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doTerms || (sreq.purpose & 0x400) == 0) {
            return;
        }
        TermsHelper th = rb._termsHelper;
        if (th != null) {
            for (ShardResponse srsp : sreq.responses) {
                NamedList terms = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
                th.parse((NamedList<NamedList<Object>>)terms);
                NamedList stats = (NamedList)srsp.getSolrResponse().getResponse().get("indexstats");
                if (stats == null) continue;
                th.numDocs += ((Number)stats.get("numDocs")).longValue();
                th.stats = true;
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doTerms || rb.stage != ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return;
        }
        TermsHelper ti = rb._termsHelper;
        NamedList<Object> terms = ti.buildResponse();
        rb.rsp.add(COMPONENT_NAME, terms);
        if (ti.stats) {
            SimpleOrderedMap stats = new SimpleOrderedMap();
            stats.add("numDocs", (Object)ti.numDocs);
            rb.rsp.add("indexstats", stats);
        }
        rb._termsHelper = null;
    }

    private static ShardRequest createShardQuery(SolrParams params) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1024;
        sreq.params = new ModifiableSolrParams(params);
        sreq.params.remove("terms.maxcount");
        sreq.params.remove("terms.mincount");
        sreq.params.set("terms.limit", -1);
        sreq.params.set("terms.sort", new String[]{"index"});
        return sreq;
    }

    private static void fetchTerms(SolrIndexSearcher indexSearcher, String[] fields, String termList, boolean includeTotalTermFreq, NamedList<Object> result) throws IOException {
        List splitTermList = StrUtils.splitSmart((String)termList, (String)",", (boolean)true);
        Object[] splitTerms = splitTermList.toArray(new String[splitTermList.size()]);
        for (int i = 0; i < splitTerms.length; ++i) {
            splitTerms[i] = ((String)splitTerms[i]).trim();
        }
        Arrays.sort(splitTerms);
        IndexReaderContext topReaderContext = indexSearcher.getTopReaderContext();
        for (String field : fields) {
            SchemaField sf = indexSearcher.getSchema().getField(field);
            FieldType fieldType = sf.getType();
            if (fieldType.isPointField()) {
                SimpleOrderedMap termsMap = new SimpleOrderedMap();
                for (Object term : splitTerms) {
                    Query q = fieldType.getFieldQuery(null, sf, (String)term);
                    int count = indexSearcher.getDocSet(q).size();
                    termsMap.add((String)term, (Object)count);
                }
                result.add(field, (Object)termsMap);
                continue;
            }
            Term[] terms = new Term[splitTerms.length];
            for (int i = 0; i < splitTerms.length; ++i) {
                terms[i] = new Term(field, fieldType.readableToIndexed((String)splitTerms[i]));
            }
            TermStates[] termStates = new TermStates[terms.length];
            TermsComponent.collectTermStates(topReaderContext, termStates, terms);
            SimpleOrderedMap termsMap = new SimpleOrderedMap();
            for (int i = 0; i < terms.length; ++i) {
                if (termStates[i] == null) continue;
                String outTerm = fieldType.indexedToReadable(terms[i].bytes().utf8ToString());
                int docFreq = termStates[i].docFreq();
                if (!includeTotalTermFreq) {
                    termsMap.add(outTerm, (Object)docFreq);
                    continue;
                }
                long totalTermFreq = termStates[i].totalTermFreq();
                SimpleOrderedMap termStats = new SimpleOrderedMap();
                termStats.add("df", (Object)docFreq);
                termStats.add("ttf", (Object)totalTermFreq);
                termsMap.add(outTerm, (Object)termStats);
            }
            result.add(field, (Object)termsMap);
        }
    }

    private static void collectTermStates(IndexReaderContext topReaderContext, TermStates[] contextArray, Term[] queryTerms) throws IOException {
        TermsEnum termsEnum = null;
        for (LeafReaderContext context : topReaderContext.leaves()) {
            for (int i = 0; i < queryTerms.length; ++i) {
                Term term = queryTerms[i];
                Terms terms = context.reader().terms(term.field());
                if (terms == null) continue;
                termsEnum = terms.iterator();
                assert (termsEnum != null);
                if (termsEnum == TermsEnum.EMPTY) continue;
                TermStates termStates = contextArray[i];
                if (!termsEnum.seekExact(term.bytes())) continue;
                if (termStates == null) {
                    contextArray[i] = termStates = new TermStates(topReaderContext);
                }
                termStates.accumulateStatistics(termsEnum.docFreq(), termsEnum.totalTermFreq());
            }
        }
    }

    private static void collectStats(SolrIndexSearcher searcher, NamedList<Number> stats) {
        int numDocs = searcher.getTopReaderContext().reader().numDocs();
        stats.add("numDocs", (Object)numDocs);
    }

    @Override
    public String getDescription() {
        return "A Component for working with Term Enumerators";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }

    public static class TermsHelper {
        private HashMap<String, HashMap<String, TermsResponse.Term>> fieldmap = new HashMap(5);
        private SolrParams params;
        public long numDocs = 0L;
        public boolean stats;

        public void init(SolrParams params) {
            this.params = params;
            String[] fields = params.getParams("terms.fl");
            if (fields != null) {
                for (String field : fields) {
                    this.fieldmap.put(field, new HashMap(128));
                }
            }
        }

        public void parse(NamedList<NamedList<Object>> terms) {
            if (terms == null) {
                return;
            }
            TermsResponse termsResponse = new TermsResponse(terms);
            for (String key : this.fieldmap.keySet()) {
                HashMap<String, TermsResponse.Term> termmap = this.fieldmap.get(key);
                List termlist = termsResponse.getTerms(key);
                if (termlist == null) continue;
                for (TermsResponse.Term tc : termlist) {
                    String term = tc.getTerm();
                    if (termmap.containsKey(term)) {
                        TermsResponse.Term oldtc = termmap.get(term);
                        oldtc.addFrequency(tc.getFrequency());
                        oldtc.addTotalTermFreq(tc.getTotalTermFreq());
                        termmap.put(term, oldtc);
                        continue;
                    }
                    termmap.put(term, tc);
                }
            }
        }

        public NamedList<Object> buildResponse() {
            boolean sort;
            SimpleOrderedMap response = new SimpleOrderedMap();
            boolean bl = sort = !"index".equals(this.params.get("terms.sort", "count"));
            if (this.params.get("terms.list") != null) {
                sort = false;
            }
            long freqmin = 1L;
            String s = this.params.get("terms.mincount");
            if (s != null) {
                freqmin = Long.parseLong(s);
            }
            long freqmax = -1L;
            s = this.params.get("terms.maxcount");
            if (s != null) {
                freqmax = Long.parseLong(s);
            }
            if (freqmax < 0L) {
                freqmax = Long.MAX_VALUE;
            }
            long limit = 10L;
            s = this.params.get("terms.limit");
            if (s != null) {
                limit = Long.parseLong(s);
            }
            if (limit < 0L) {
                limit = Long.MAX_VALUE;
            }
            for (String key : this.fieldmap.keySet()) {
                SimpleOrderedMap fieldterms = new SimpleOrderedMap();
                TermsResponse.Term[] data = null;
                data = sort ? this.getCountSorted(this.fieldmap.get(key)) : this.getLexSorted(this.fieldmap.get(key));
                boolean includeTotalTermFreq = this.params.getBool("terms.ttf", false);
                int cnt = 0;
                for (TermsResponse.Term tc : data) {
                    if (tc.getFrequency() >= freqmin && tc.getFrequency() <= freqmax) {
                        if (includeTotalTermFreq) {
                            SimpleOrderedMap termStats = new SimpleOrderedMap();
                            termStats.add("df", (Object)tc.getFrequency());
                            termStats.add("ttf", (Object)tc.getTotalTermFreq());
                            fieldterms.add(tc.getTerm(), (Object)termStats);
                        } else {
                            fieldterms.add(tc.getTerm(), (Object)TermsHelper.num(tc.getFrequency()));
                        }
                        ++cnt;
                    }
                    if ((long)cnt >= limit) break;
                }
                response.add(key, (Object)fieldterms);
            }
            return response;
        }

        private static Number num(long val) {
            if (val < Integer.MAX_VALUE) {
                return (int)val;
            }
            return val;
        }

        public TermsResponse.Term[] getLexSorted(HashMap<String, TermsResponse.Term> data) {
            TermsResponse.Term[] arr = data.values().toArray(new TermsResponse.Term[data.size()]);
            Arrays.sort(arr, (o1, o2) -> o1.getTerm().compareTo(o2.getTerm()));
            return arr;
        }

        public TermsResponse.Term[] getCountSorted(HashMap<String, TermsResponse.Term> data) {
            TermsResponse.Term[] arr = data.values().toArray(new TermsResponse.Term[data.size()]);
            Arrays.sort(arr, (o1, o2) -> {
                long freq1 = o1.getFrequency();
                long freq2 = o2.getFrequency();
                if (freq2 < freq1) {
                    return -1;
                }
                if (freq1 < freq2) {
                    return 1;
                }
                return o1.getTerm().compareTo(o2.getTerm());
            });
            return arr;
        }
    }
}

