/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.RegExp;
import org.junit.Assert;

public abstract class BaseDocValuesFormatTestCase
extends BaseIndexFileFormatTestCase {
    @Override
    protected void addRandomFields(Document doc) {
        int i;
        if (BaseDocValuesFormatTestCase.usually()) {
            doc.add((IndexableField)new NumericDocValuesField("ndv", (long)BaseDocValuesFormatTestCase.random().nextInt(4096)));
            doc.add((IndexableField)new BinaryDocValuesField("bdv", new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()))));
            doc.add((IndexableField)new SortedDocValuesField("sdv", new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random(), 2))));
        }
        int numValues = BaseDocValuesFormatTestCase.random().nextInt(5);
        for (i = 0; i < numValues; ++i) {
            doc.add((IndexableField)new SortedSetDocValuesField("ssdv", new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random(), 2))));
        }
        numValues = BaseDocValuesFormatTestCase.random().nextInt(5);
        for (i = 0; i < numValues; ++i) {
            doc.add((IndexableField)new SortedNumericDocValuesField("sndv", TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
        }
    }

    public void testOneNumber() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv", 5L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
            int docID = hits.scoreDocs[i].doc;
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.longValue());
        }
        ireader.close();
        directory.close();
    }

    public void testOneFloat() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new FloatDocValuesField("dv", 5.7f));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = isearcher.doc(docID);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((long)Float.floatToRawIntBits(5.7f), (long)dv.longValue());
        }
        ireader.close();
        directory.close();
    }

    public void testTwoNumbers() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        doc.add((IndexableField)new NumericDocValuesField("dv2", 17L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = isearcher.doc(docID);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.longValue());
            dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((long)17L, (long)dv.longValue());
        }
        ireader.close();
        directory.close();
    }

    public void testTwoBinaryValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef((CharSequence)longTerm)));
        doc.add((IndexableField)new BinaryDocValuesField("dv2", new BytesRef((CharSequence)text)));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int hitDocID = hits.scoreDocs[i].doc;
            Document hitDoc = isearcher.doc(hitDocID);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)hitDocID, (long)dv.advance(hitDocID));
            BytesRef scratch = dv.binaryValue();
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)longTerm), (Object)scratch);
            dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)hitDocID, (long)dv.advance(hitDocID));
            scratch = dv.binaryValue();
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)text), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testTwoFieldsMixed() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        doc.add((IndexableField)new BinaryDocValuesField("dv2", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = isearcher.doc(docID);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.longValue());
            BinaryDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv2.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)dv2.binaryValue());
        }
        ireader.close();
        directory.close();
    }

    public void testThreeFieldsMixed() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField("dv1", new BytesRef((CharSequence)"hello hello")));
        doc.add((IndexableField)new NumericDocValuesField("dv2", 5L));
        doc.add((IndexableField)new BinaryDocValuesField("dv3", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = isearcher.doc(docID);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            int ord = dv.ordValue();
            BytesRef scratch = dv.lookupOrd(ord);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello hello"), (Object)scratch);
            NumericDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv2.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv2.longValue());
            BinaryDocValues dv3 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv3");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv3.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)dv3.binaryValue());
        }
        ireader.close();
        directory.close();
    }

    public void testThreeFieldsMixed2() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef((CharSequence)"hello world")));
        doc.add((IndexableField)new SortedDocValuesField("dv2", new BytesRef((CharSequence)"hello hello")));
        doc.add((IndexableField)new NumericDocValuesField("dv3", 5L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = isearcher.doc(docID);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            int ord = dv.ordValue();
            scratch = dv.lookupOrd(ord);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello hello"), (Object)scratch);
            NumericDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv3");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv2.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv2.longValue());
            BinaryDocValues dv3 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv3.advance(docID));
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)dv3.binaryValue());
        }
        ireader.close();
        directory.close();
    }

    public void testTwoDocumentsNumeric() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 1L));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 2L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.longValue());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.longValue());
        ireader.close();
        directory.close();
    }

    public void testTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new NumericDocValuesField("dv", -10L));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new NumericDocValuesField("dv", 99L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().document(i);
            long expected = doc2.get("id").equals("0") ? -10L : 99L;
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)dv.nextDoc());
            BaseDocValuesFormatTestCase.assertEquals((long)expected, (long)dv.longValue());
        }
        ireader.close();
        directory.close();
    }

    public void testBigNumericRange() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", Long.MIN_VALUE));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", Long.MAX_VALUE));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)Long.MIN_VALUE, (long)dv.longValue());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)Long.MAX_VALUE, (long)dv.longValue());
        ireader.close();
        directory.close();
    }

    public void testBigNumericRange2() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", -8841491950446638677L));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 9062230939892376225L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)-8841491950446638677L, (long)dv.longValue());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)9062230939892376225L, (long)dv.longValue());
        ireader.close();
        directory.close();
    }

    public void testBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int hitDocID = hits.scoreDocs[i].doc;
            Document hitDoc = isearcher.doc(hitDocID);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
            BaseDocValuesFormatTestCase.assertEquals((long)hitDocID, (long)dv.advance(hitDocID));
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)dv.binaryValue());
        }
        ireader.close();
        directory.close();
    }

    public void testBytesTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().document(i);
            String expected = doc2.get("id").equals("0") ? "hello world 1" : "hello 2";
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)dv.nextDoc());
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)dv.binaryValue().utf8ToString());
        }
        ireader.close();
        directory.close();
    }

    public void testBytesMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new BinaryDocValuesField("field", new BytesRef((CharSequence)"hi")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        BinaryDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getBinaryDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.count((Query)new TermQuery(new Term("fieldname", longTerm))));
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            int docID = hits.scoreDocs[i].doc;
            Document hitDoc = isearcher.doc(docID);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
            BaseDocValuesFormatTestCase.assertEquals((long)docID, (long)dv.advance(docID));
            scratch = dv.lookupOrd(dv.ordValue());
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testSortedBytesTwoDocuments() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = new BytesRef();
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        scratch = dv.lookupOrd(dv.ordValue());
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 1", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        scratch = dv.lookupOrd(dv.ordValue());
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 2", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testSortedBytesThreeDocuments() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.ordValue());
        BytesRef scratch = dv.lookupOrd(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 1", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.ordValue());
        scratch = dv.lookupOrd(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 2", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.ordValue());
        ireader.close();
        directory.close();
    }

    public void testSortedBytesTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BytesRef scratch = dv.binaryValue();
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 1"), (Object)scratch);
        scratch = dv.lookupOrd(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 2"), (Object)scratch);
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().document(i);
            String expected = doc2.get("id").equals("0") ? "hello world 1" : "hello world 2";
            if (dv.docID() < i) {
                BaseDocValuesFormatTestCase.assertEquals((long)i, (long)dv.nextDoc());
            }
            scratch = dv.lookupOrd(dv.ordValue());
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)scratch.utf8ToString());
        }
        ireader.close();
        directory.close();
    }

    public void testSortedMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testBytesWithNewline() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello\nworld\r1")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello\nworld\r1"), (Object)dv.binaryValue());
        ireader.close();
        directory.close();
    }

    public void testMissingSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.addDocument(new Document());
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BytesRef scratch = dv.lookupOrd(dv.ordValue());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 2"), (Object)scratch);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedTermsEnum() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"ha!")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"zzz")));
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"aba")));
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"hello")));
        BaseDocValuesFormatTestCase.assertEquals((String)Codec.getDefault().toString(), (Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"world")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"bogus")));
        termsEnum.seekExact(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        termsEnum.seekExact(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        termsEnum.seekExact(2L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        termsEnum = dv.intersect(new CompiledAutomaton(new RegExp(".*l.*").toAutomaton()));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertNull((Object)termsEnum.next());
        termsEnum = dv.intersect(new CompiledAutomaton(new RegExp("hello").toAutomaton()));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertNull((Object)termsEnum.next());
        ireader.close();
        directory.close();
    }

    public void testEmptySortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.ordValue());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.ordValue());
        BytesRef scratch = dv.lookupOrd(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testEmptyBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)dv.binaryValue().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)dv.binaryValue().utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testVeryLargeButLegalBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        byte[] bytes = new byte[32766];
        BytesRef b = new BytesRef(bytes);
        BaseDocValuesFormatTestCase.random().nextBytes(bytes);
        doc.add((IndexableField)new BinaryDocValuesField("dv", b));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(bytes), (Object)dv.binaryValue());
        ireader.close();
        directory.close();
    }

    public void testVeryLargeButLegalSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        byte[] bytes = new byte[32766];
        BytesRef b = new BytesRef(bytes);
        BaseDocValuesFormatTestCase.random().nextBytes(bytes);
        doc.add((IndexableField)new SortedDocValuesField("dv", b));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = DocValues.getBinary((LeafReader)((LeafReaderContext)ireader.leaves().get(0)).reader(), (String)"dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(bytes), (Object)dv.binaryValue());
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"boo!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)"boo!", (Object)dv.binaryValue().utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"boo!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = DocValues.getBinary((LeafReader)((LeafReaderContext)ireader.leaves().get(0)).reader(), (String)"dv");
        byte[] mybytes = new byte[20];
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)"boo!", (Object)dv.binaryValue().utf8ToString());
        BaseDocValuesFormatTestCase.assertFalse((dv.binaryValue().bytes == mybytes ? 1 : 0) != 0);
        ireader.close();
        directory.close();
    }

    public void testDocValuesSimple() throws IOException {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        IndexWriter writer = new IndexWriter((Directory)dir, conf);
        for (int i = 0; i < 5; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new NumericDocValuesField("docId", (long)i));
            doc.add((IndexableField)new TextField("docId", "" + i, Field.Store.NO));
            writer.addDocument((Iterable)doc);
        }
        writer.commit();
        writer.forceMerge(1, true);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)reader.leaves().size());
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.add((Query)new TermQuery(new Term("docId", "0")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "1")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "2")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "3")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "4")), BooleanClause.Occur.SHOULD);
        TopDocs search = searcher.search((Query)query.build(), 10);
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)search.totalHits.value);
        ScoreDoc[] scoreDocs = search.scoreDocs;
        NumericDocValues docValues = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)reader).getNumericDocValues("docId");
        for (int i = 0; i < scoreDocs.length; ++i) {
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.advance(i));
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.longValue());
        }
        reader.close();
        dir.close();
    }

    public void testRandomSortedBytes() throws IOException {
        Document doc;
        int i;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig cfg = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter w = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, cfg);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(100);
        BytesRefHash hash = new BytesRefHash();
        HashMap<String, String> docToString = new HashMap<String, String>();
        int maxLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 50);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            Document doc2 = new Document();
            doc2.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", "" + i2, Field.Store.YES));
            String string = TestUtil.randomRealisticUnicodeString(BaseDocValuesFormatTestCase.random(), 1, maxLength);
            BytesRef br = new BytesRef((CharSequence)string);
            doc2.add((IndexableField)new SortedDocValuesField("field", br));
            hash.add(br);
            docToString.put("" + i2, string);
            w.addDocument(doc2);
        }
        if (BaseDocValuesFormatTestCase.rarely()) {
            w.commit();
        }
        int numDocsNoValue = BaseDocValuesFormatTestCase.atLeast(10);
        for (i = 0; i < numDocsNoValue; ++i) {
            doc = new Document();
            doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", "noValue", Field.Store.YES));
            w.addDocument(doc);
        }
        if (BaseDocValuesFormatTestCase.rarely()) {
            w.commit();
        }
        for (i = 0; i < numDocs; ++i) {
            doc = new Document();
            String id = "" + i + numDocs;
            doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", id, Field.Store.YES));
            String string = TestUtil.randomRealisticUnicodeString(BaseDocValuesFormatTestCase.random(), 1, maxLength);
            BytesRef br = new BytesRef((CharSequence)string);
            hash.add(br);
            docToString.put(id, string);
            doc.add((IndexableField)new SortedDocValuesField("field", br));
            w.addDocument(doc);
        }
        w.commit();
        DirectoryReader reader = w.getReader();
        SortedDocValues docValues = MultiDocValues.getSortedValues((IndexReader)reader, (String)"field");
        int[] sort = hash.sort();
        BytesRef expected = new BytesRef();
        BaseDocValuesFormatTestCase.assertEquals((long)hash.size(), (long)docValues.getValueCount());
        for (int i3 = 0; i3 < hash.size(); ++i3) {
            hash.get(sort[i3], expected);
            BytesRef actual = docValues.lookupOrd(i3);
            BaseDocValuesFormatTestCase.assertEquals((Object)expected.utf8ToString(), (Object)actual.utf8ToString());
            int ord = docValues.lookupTerm(expected);
            BaseDocValuesFormatTestCase.assertEquals((long)i3, (long)ord);
        }
        Set entrySet = docToString.entrySet();
        for (Map.Entry entry : entrySet) {
            PostingsEnum termPostingsEnum = TestUtil.docs(BaseDocValuesFormatTestCase.random(), (IndexReader)reader, "id", new BytesRef((CharSequence)entry.getKey()), null, 0);
            int docId = termPostingsEnum.nextDoc();
            expected = new BytesRef((CharSequence)entry.getValue());
            docValues = MultiDocValues.getSortedValues((IndexReader)reader, (String)"field");
            BaseDocValuesFormatTestCase.assertEquals((long)docId, (long)docValues.advance(docId));
            BytesRef actual = docValues.binaryValue();
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)actual);
        }
        reader.close();
        w.close();
        dir.close();
    }

    private void doTestNumericsVsStoredFields(double density, LongSupplier longs) throws Exception {
        this.doTestNumericsVsStoredFields(density, longs, 256);
    }

    private void doTestNumericsVsStoredFields(double density, LongSupplier longs, int minDocs) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        Field storedField = BaseDocValuesFormatTestCase.newStringField("stored", "", Field.Store.YES);
        NumericDocValuesField dvField = new NumericDocValuesField("dv", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast((int)((double)minDocs * 1.172));
        assert (numDocs > 256);
        for (int i = 0; i < numDocs; ++i) {
            if (BaseDocValuesFormatTestCase.random().nextDouble() > density) {
                writer.addDocument(new Document());
                continue;
            }
            idField.setStringValue(Integer.toString(i));
            long value = longs.getAsLong();
            storedField.setStringValue(Long.toString(value));
            dvField.setLongValue(value);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.forceMerge(numDocs / Math.max(256, minDocs));
        writer.close();
        this.assertDVIterate((Directory)dir);
        dir.close();
    }

    protected void assertDVIterate(Directory dir) throws IOException {
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            LeafReader r = context.reader();
            NumericDocValues docValues = DocValues.getNumeric((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (int i = 0; i < r.maxDoc(); ++i) {
                String storedValue = r.document(i).get("stored");
                if (storedValue == null) {
                    BaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                BaseDocValuesFormatTestCase.assertEquals((long)Long.parseLong(storedValue), (long)docValues.longValue());
                docValues.nextDoc();
            }
            BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
    }

    private void doTestSortedNumericsVsStoredFields(LongSupplier counts, LongSupplier values) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(300);
        assert (numDocs > 256);
        for (int i = 0; i < numDocs; ++i) {
            int j;
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", Integer.toString(i), Field.Store.NO));
            int valueCount = (int)counts.getAsLong();
            long[] valueArray = new long[valueCount];
            for (j = 0; j < valueCount; ++j) {
                long value;
                valueArray[j] = value = values.getAsLong();
                doc.add((IndexableField)new SortedNumericDocValuesField("dv", value));
            }
            Arrays.sort(valueArray);
            for (j = 0; j < valueCount; ++j) {
                doc.add((IndexableField)new StoredField("stored", Long.toString(valueArray[j])));
            }
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.forceMerge(numDocs / 256);
        writer.close();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            LeafReader r = context.reader();
            SortedNumericDocValues docValues = DocValues.getSortedNumeric((LeafReader)r, (String)"dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                if (i > docValues.docID()) {
                    docValues.nextDoc();
                }
                Object[] expected = r.document(i).getValues("stored");
                if (i < docValues.docID()) {
                    BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)expected.length);
                    continue;
                }
                Object[] actual = new String[docValues.docValueCount()];
                for (int j = 0; j < actual.length; ++j) {
                    actual[j] = Long.toString(docValues.nextValue());
                }
                BaseDocValuesFormatTestCase.assertArrayEquals((Object[])expected, (Object[])actual);
            }
        }
        ir.close();
        dir.close();
    }

    public void testBooleanNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, () -> BaseDocValuesFormatTestCase.random().nextInt(2));
        }
    }

    public void testSparseBooleanNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(BaseDocValuesFormatTestCase.random().nextDouble(), () -> BaseDocValuesFormatTestCase.random().nextInt(2));
        }
    }

    public void testByteNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, () -> TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), -128, 127));
        }
    }

    public void testSparseByteNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(BaseDocValuesFormatTestCase.random().nextDouble(), () -> TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), -128, 127));
        }
    }

    public void testShortNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, () -> TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), Short.MIN_VALUE, Short.MAX_VALUE));
        }
    }

    public void testSparseShortNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(BaseDocValuesFormatTestCase.random().nextDouble(), () -> TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), Short.MIN_VALUE, Short.MAX_VALUE));
        }
    }

    public void testIntNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, BaseDocValuesFormatTestCase.random()::nextInt);
        }
    }

    public void testSparseIntNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(BaseDocValuesFormatTestCase.random().nextDouble(), BaseDocValuesFormatTestCase.random()::nextInt);
        }
    }

    public void testLongNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(1.0, BaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    public void testSparseLongNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(BaseDocValuesFormatTestCase.random().nextDouble(), BaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    private void doTestBinaryVsStoredFields(double density, Supplier<byte[]> bytes) throws Exception {
        BytesRef binaryValue;
        int i;
        BinaryDocValues docValues;
        LeafReader r;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        BinaryDocValuesField dvField = new BinaryDocValuesField("dv", new BytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(300);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            if (BaseDocValuesFormatTestCase.random().nextDouble() > density) {
                writer.addDocument(new Document());
                continue;
            }
            idField.setStringValue(Integer.toString(i2));
            byte[] buffer = bytes.get();
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i3 = 0; i3 < numDeletions; ++i3) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = DocValues.getBinary((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    BaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)docValues.binaryValue());
                docValues.nextDoc();
            }
            BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = DocValues.getBinary((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    BaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)docValues.binaryValue());
                docValues.nextDoc();
            }
            BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.close();
        dir.close();
    }

    public void testBinaryFixedLengthVsStoredFields() throws Exception {
        this.doTestBinaryFixedLengthVsStoredFields(1.0);
    }

    public void testSparseBinaryFixedLengthVsStoredFields() throws Exception {
        this.doTestBinaryFixedLengthVsStoredFields(BaseDocValuesFormatTestCase.random().nextDouble());
    }

    private void doTestBinaryFixedLengthVsStoredFields(double density) throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 0, 10);
            this.doTestBinaryVsStoredFields(density, () -> {
                byte[] buffer = new byte[fixedLength];
                BaseDocValuesFormatTestCase.random().nextBytes(buffer);
                return buffer;
            });
        }
    }

    public void testBinaryVariableLengthVsStoredFields() throws Exception {
        this.doTestBinaryVariableLengthVsStoredFields(1.0);
    }

    public void testSparseBinaryVariableLengthVsStoredFields() throws Exception {
        this.doTestBinaryVariableLengthVsStoredFields(BaseDocValuesFormatTestCase.random().nextDouble());
    }

    public void doTestBinaryVariableLengthVsStoredFields(double density) throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestBinaryVsStoredFields(density, () -> {
                int length = BaseDocValuesFormatTestCase.random().nextInt(10);
                byte[] buffer = new byte[length];
                BaseDocValuesFormatTestCase.random().nextBytes(buffer);
                return buffer;
            });
        }
    }

    protected void doTestSortedVsStoredFields(int numDocs, double density, Supplier<byte[]> bytes) throws Exception {
        BytesRef binaryValue;
        int i;
        BinaryDocValues docValues;
        LeafReader r;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newFSDirectory(BaseDocValuesFormatTestCase.createTempDir("dvduel"));
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        SortedDocValuesField dvField = new SortedDocValuesField("dv", new BytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            if (BaseDocValuesFormatTestCase.random().nextDouble() > density) {
                writer.addDocument(new Document());
                continue;
            }
            idField.setStringValue(Integer.toString(i2));
            byte[] buffer = bytes.get();
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i3 = 0; i3 < numDeletions; ++i3) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = DocValues.getBinary((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    BaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)docValues.binaryValue());
                docValues.nextDoc();
            }
            BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = DocValues.getBinary((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    BaseDocValuesFormatTestCase.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)docValues.binaryValue());
                docValues.nextDoc();
            }
            BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.close();
        dir.close();
    }

    public void testSortedFixedLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1.0, fixedLength, fixedLength);
        }
    }

    public void testSparseSortedFixedLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), BaseDocValuesFormatTestCase.random().nextDouble(), fixedLength, fixedLength);
        }
    }

    public void testSortedVariableLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1.0, 1, 10);
        }
    }

    public void testSparseSortedVariableLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), BaseDocValuesFormatTestCase.random().nextDouble(), 1, 10);
        }
    }

    protected void doTestSortedVsStoredFields(int numDocs, double density, int minLength, int maxLength) throws Exception {
        this.doTestSortedVsStoredFields(numDocs, density, () -> {
            int length = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            return buffer;
        });
    }

    public void testSortedSetOneValue() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoFields() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field2", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field2");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsMerged() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        bytes = dv.lookupOrd(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoValuesUnordered() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetThreeValuesTwoDocs() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"beer"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        bytes = dv.lookupOrd(2L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsLastMissing() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        doc = new Document();
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsLastMissingMerge() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsFirstMissing() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsFirstMissingMerge() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getValueCount());
        ireader.close();
        directory.close();
    }

    public void testSortedSetTermsEnum() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"ha!")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"zzz")));
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"hello")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"world")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"bogus")));
        termsEnum.seekExact(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        termsEnum.seekExact(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        termsEnum.seekExact(2L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        termsEnum = dv.intersect(new CompiledAutomaton(new RegExp(".*l.*").toAutomaton()));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertNull((Object)termsEnum.next());
        termsEnum = dv.intersect(new CompiledAutomaton(new RegExp("hello").toAutomaton()));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertNull((Object)termsEnum.next());
        ireader.close();
        directory.close();
    }

    protected void doTestSortedSetVsStoredFields(int numDocs, int minLength, int maxLength, int maxValuesPerDoc, int maxUniqueValues) throws Exception {
        BytesRef scratch;
        long ord;
        int j;
        String[] stringValues;
        SortedSetDocValues docValues;
        LeafReader r;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newFSDirectory(BaseDocValuesFormatTestCase.createTempDir("dvduel"));
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        HashSet<String> valueSet = new HashSet<String>();
        for (int i = 0; i < 10000 && valueSet.size() < maxUniqueValues; ++i) {
            int length = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            valueSet.add(TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random(), length));
        }
        Object[] uniqueValues = valueSet.toArray(new String[0]);
        if (VERBOSE) {
            System.out.println("\nTEST: now add numDocs=" + numDocs);
        }
        for (int i = 0; i < numDocs; ++i) {
            Object v3;
            Document doc = new Document();
            StringField idField = new StringField("id", Integer.toString(i), Field.Store.NO);
            doc.add((IndexableField)idField);
            int numValues = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 0, maxValuesPerDoc);
            TreeSet<Object> values = new TreeSet<Object>();
            for (int v2 = 0; v2 < numValues; ++v2) {
                values.add(RandomPicks.randomFrom((Random)BaseDocValuesFormatTestCase.random(), (Object[])uniqueValues));
            }
            for (Object v3 : values) {
                doc.add((IndexableField)new StoredField("stored", (String)v3));
            }
            ArrayList unordered = new ArrayList(values);
            Collections.shuffle(unordered, BaseDocValuesFormatTestCase.random());
            v3 = unordered.iterator();
            while (v3.hasNext()) {
                String v4 = (String)v3.next();
                doc.add((IndexableField)new SortedSetDocValuesField("dv", new BytesRef((CharSequence)v4)));
            }
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        if (VERBOSE) {
            System.out.println("\nTEST: now delete " + numDeletions + " docs");
        }
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        if (VERBOSE) {
            System.out.println("\nTEST: now get reader");
        }
        DirectoryReader ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getSortedSetDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                stringValues = r.document(i).getValues("stored");
                if (docValues != null && docValues.docID() < i) {
                    docValues.nextDoc();
                }
                if (docValues == null || stringValues.length <= 0) continue;
                BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                for (j = 0; j < stringValues.length; ++j) {
                    assert (docValues != null);
                    ord = docValues.nextOrd();
                    assert (ord != -1L);
                    scratch = docValues.lookupOrd(ord);
                    BaseDocValuesFormatTestCase.assertEquals((Object)stringValues[j], (Object)scratch.utf8ToString());
                }
                BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)docValues.nextOrd());
            }
        }
        if (VERBOSE) {
            System.out.println("\nTEST: now close reader");
        }
        ir.close();
        if (VERBOSE) {
            System.out.println("TEST: force merge");
        }
        writer.forceMerge(1);
        ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getSortedSetDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                stringValues = r.document(i).getValues("stored");
                if (docValues.docID() < i) {
                    docValues.nextDoc();
                }
                if (docValues == null || stringValues.length <= 0) continue;
                BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.docID());
                for (j = 0; j < stringValues.length; ++j) {
                    assert (docValues != null);
                    ord = docValues.nextOrd();
                    assert (ord != -1L);
                    scratch = docValues.lookupOrd(ord);
                    BaseDocValuesFormatTestCase.assertEquals((Object)stringValues[j], (Object)scratch.utf8ToString());
                }
                BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)docValues.nextOrd());
            }
        }
        if (VERBOSE) {
            System.out.println("TEST: close reader");
        }
        ir.close();
        if (VERBOSE) {
            System.out.println("TEST: close writer");
        }
        writer.close();
        if (VERBOSE) {
            System.out.println("TEST: close dir");
        }
        dir.close();
    }

    public void testSortedSetFixedLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), fixedLength, fixedLength, 16, 100);
        }
    }

    public void testSortedNumericsSingleValuedVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(() -> 1L, BaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    public void testSortedNumericsSingleValuedMissingVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(() -> BaseDocValuesFormatTestCase.random().nextBoolean() ? 0L : 1L, BaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    public void testSortedNumericsMultipleValuesVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(() -> TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), 0L, 50L), BaseDocValuesFormatTestCase.random()::nextLong);
        }
    }

    public void testSortedNumericsFewUniqueSetsVsStoredFields() throws Exception {
        long[] values = new long[TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 2, 6)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = BaseDocValuesFormatTestCase.random().nextLong();
        }
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(() -> TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), 0L, 6L), () -> values[BaseDocValuesFormatTestCase.random().nextInt(values.length)]);
        }
    }

    public void testSortedSetVariableLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1, 10, 16, 100);
        }
    }

    public void testSortedSetFixedLengthSingleValuedVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), fixedLength, fixedLength, 1, 100);
        }
    }

    public void testSortedSetVariableLengthSingleValuedVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1, 10, 1, 100);
        }
    }

    public void testSortedSetFixedLengthFewUniqueSetsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 10, 10, 6, 6);
        }
    }

    public void testSortedSetVariableLengthFewUniqueSetsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1, 10, 6, 6);
        }
    }

    public void testSortedSetVariableLengthManyValuesPerDocVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(20), 1, 10, 500, 1000);
        }
    }

    public void testSortedSetFixedLengthManyValuesPerDocVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(20), 10, 10, 500, 1000);
        }
    }

    public void testGCDCompression() throws Exception {
        this.doTestGCDCompression(1.0);
    }

    public void testSparseGCDCompression() throws Exception {
        this.doTestGCDCompression(BaseDocValuesFormatTestCase.random().nextDouble());
    }

    private void doTestGCDCompression(double density) throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            long min = -((long)BaseDocValuesFormatTestCase.random().nextInt(0x40000000) << 32);
            long mul = (long)BaseDocValuesFormatTestCase.random().nextInt() & 0xFFFFFFFFL;
            LongSupplier longs = () -> min + mul * (long)BaseDocValuesFormatTestCase.random().nextInt(0x100000);
            this.doTestNumericsVsStoredFields(density, longs);
        }
    }

    public void testZeros() throws Exception {
        this.doTestNumericsVsStoredFields(1.0, () -> 0L);
    }

    public void testSparseZeros() throws Exception {
        this.doTestNumericsVsStoredFields(BaseDocValuesFormatTestCase.random().nextDouble(), () -> 0L);
    }

    public void testZeroOrMin() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            LongSupplier longs = () -> BaseDocValuesFormatTestCase.random().nextBoolean() ? 0L : Long.MIN_VALUE;
            this.doTestNumericsVsStoredFields(1.0, longs);
        }
    }

    public void testTwoNumbersOneMissing() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.longValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testTwoNumbersOneMissingWithMerging() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.longValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testThreeNumbersOneMissingWithMerging() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "2", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.longValue());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.longValue());
        ir.close();
        directory.close();
    }

    public void testTwoBytesOneMissing() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef()));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)dv.binaryValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testTwoBytesOneMissingWithMerging() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef()));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)dv.binaryValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testThreeBytesOneMissingWithMerging() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef()));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "2", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef((CharSequence)"boo")));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)dv.binaryValue());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"boo"), (Object)dv.binaryValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ir.close();
        directory.close();
    }

    public void testThreads() throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedBinField = new StoredField("storedBin", new byte[0]);
        BinaryDocValuesField dvBinField = new BinaryDocValuesField("dvBin", new BytesRef());
        SortedDocValuesField dvSortedField = new SortedDocValuesField("dvSorted", new BytesRef());
        StoredField storedNumericField = new StoredField("storedNum", "");
        NumericDocValuesField dvNumericField = new NumericDocValuesField("dvNum", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedBinField);
        doc.add((IndexableField)dvBinField);
        doc.add((IndexableField)dvSortedField);
        doc.add((IndexableField)storedNumericField);
        doc.add((IndexableField)dvNumericField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(300);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            int length = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 0, 8);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedBinField.setBytesValue(buffer);
            dvBinField.setBytesValue(buffer);
            dvSortedField.setBytesValue(buffer);
            long numericValue = BaseDocValuesFormatTestCase.random().nextLong();
            storedNumericField.setStringValue(Long.toString(numericValue));
            dvNumericField.setLongValue(numericValue);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        final DirectoryReader ir = DirectoryReader.open((Directory)dir);
        int numThreads = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 2, 7);
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        startingGun.await();
                        for (LeafReaderContext context : ir.leaves()) {
                            LeafReader r = context.reader();
                            BinaryDocValues binaries = r.getBinaryDocValues("dvBin");
                            SortedDocValues sorted = r.getSortedDocValues("dvSorted");
                            NumericDocValues numerics = r.getNumericDocValues("dvNum");
                            for (int j = 0; j < r.maxDoc(); ++j) {
                                BytesRef binaryValue = r.document(j).getBinaryValue("storedBin");
                                Assert.assertEquals((long)j, (long)binaries.nextDoc());
                                BytesRef scratch = binaries.binaryValue();
                                Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                Assert.assertEquals((long)j, (long)sorted.nextDoc());
                                scratch = sorted.binaryValue();
                                Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                String expected = r.document(j).get("storedNum");
                                Assert.assertEquals((long)j, (long)numerics.nextDoc());
                                Assert.assertEquals((long)Long.parseLong(expected), (long)numerics.longValue());
                            }
                        }
                        TestUtil.checkReader((IndexReader)ir);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[i].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
        ir.close();
        dir.close();
    }

    @LuceneTestCase.Slow
    public void testThreads2() throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedBinField = new StoredField("storedBin", new byte[0]);
        BinaryDocValuesField dvBinField = new BinaryDocValuesField("dvBin", new BytesRef());
        SortedDocValuesField dvSortedField = new SortedDocValuesField("dvSorted", new BytesRef());
        StoredField storedNumericField = new StoredField("storedNum", "");
        NumericDocValuesField dvNumericField = new NumericDocValuesField("dvNum", 0L);
        int numDocs = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1025, 2047);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            int length = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 0, 8);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedBinField.setBytesValue(buffer);
            dvBinField.setBytesValue(buffer);
            dvSortedField.setBytesValue(buffer);
            long numericValue = BaseDocValuesFormatTestCase.random().nextLong();
            storedNumericField.setStringValue(Long.toString(numericValue));
            dvNumericField.setLongValue(numericValue);
            Document doc = new Document();
            doc.add((IndexableField)idField);
            if (BaseDocValuesFormatTestCase.random().nextInt(4) > 0) {
                doc.add((IndexableField)storedBinField);
                doc.add((IndexableField)dvBinField);
                doc.add((IndexableField)dvSortedField);
            }
            if (BaseDocValuesFormatTestCase.random().nextInt(4) > 0) {
                doc.add((IndexableField)storedNumericField);
                doc.add((IndexableField)dvNumericField);
            }
            int numSortedSetFields = BaseDocValuesFormatTestCase.random().nextInt(3);
            TreeSet<String> values = new TreeSet<String>();
            for (int j = 0; j < numSortedSetFields; ++j) {
                values.add(TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()));
            }
            for (String v : values) {
                doc.add((IndexableField)new SortedSetDocValuesField("dvSortedSet", new BytesRef((CharSequence)v)));
                doc.add((IndexableField)new StoredField("storedSortedSet", v));
            }
            int numSortedNumericFields = BaseDocValuesFormatTestCase.random().nextInt(3);
            TreeSet<Long> numValues = new TreeSet<Long>();
            for (int j = 0; j < numSortedNumericFields; ++j) {
                numValues.add(TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE));
            }
            for (Long l : numValues) {
                doc.add((IndexableField)new SortedNumericDocValuesField("dvSortedNumeric", l.longValue()));
                doc.add((IndexableField)new StoredField("storedSortedNumeric", Long.toString(l)));
            }
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        final DirectoryReader ir = DirectoryReader.open((Directory)dir);
        int numThreads = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 2, 7);
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        startingGun.await();
                        for (LeafReaderContext context : ir.leaves()) {
                            LeafReader r = context.reader();
                            BinaryDocValues binaries = r.getBinaryDocValues("dvBin");
                            SortedDocValues sorted = r.getSortedDocValues("dvSorted");
                            NumericDocValues numerics = r.getNumericDocValues("dvNum");
                            SortedSetDocValues sortedSet = r.getSortedSetDocValues("dvSortedSet");
                            SortedNumericDocValues sortedNumeric = r.getSortedNumericDocValues("dvSortedNumeric");
                            for (int j = 0; j < r.maxDoc(); ++j) {
                                String[] numValues;
                                String[] values;
                                String number;
                                BytesRef binaryValue = r.document(j).getBinaryValue("storedBin");
                                if (binaryValue != null && binaries != null) {
                                    Assert.assertEquals((long)j, (long)binaries.nextDoc());
                                    BytesRef scratch = binaries.binaryValue();
                                    Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                    Assert.assertEquals((long)j, (long)sorted.nextDoc());
                                    scratch = sorted.binaryValue();
                                    Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                }
                                if ((number = r.document(j).get("storedNum")) != null && numerics != null) {
                                    Assert.assertEquals((long)j, (long)numerics.advance(j));
                                    Assert.assertEquals((long)Long.parseLong(number), (long)numerics.longValue());
                                }
                                if ((values = r.document(j).getValues("storedSortedSet")).length > 0) {
                                    Assert.assertNotNull((Object)sortedSet);
                                    Assert.assertEquals((long)j, (long)sortedSet.nextDoc());
                                    for (int k = 0; k < values.length; ++k) {
                                        long ord = sortedSet.nextOrd();
                                        Assert.assertTrue((ord != -1L ? 1 : 0) != 0);
                                        BytesRef value = sortedSet.lookupOrd(ord);
                                        Assert.assertEquals((Object)values[k], (Object)value.utf8ToString());
                                    }
                                    Assert.assertEquals((long)-1L, (long)sortedSet.nextOrd());
                                }
                                if ((numValues = r.document(j).getValues("storedSortedNumeric")).length <= 0) continue;
                                Assert.assertNotNull((Object)sortedNumeric);
                                Assert.assertEquals((long)j, (long)sortedNumeric.nextDoc());
                                Assert.assertEquals((long)numValues.length, (long)sortedNumeric.docValueCount());
                                for (int k = 0; k < numValues.length; ++k) {
                                    long v = sortedNumeric.nextValue();
                                    Assert.assertEquals((Object)numValues[k], (Object)Long.toString(v));
                                }
                            }
                        }
                        TestUtil.checkReader((IndexReader)ir);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[i].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
        ir.close();
        dir.close();
    }

    @LuceneTestCase.Slow
    public void testThreads3() throws Exception {
        int i;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newFSDirectory(BaseDocValuesFormatTestCase.createTempDir());
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        int numSortedSets = BaseDocValuesFormatTestCase.random().nextInt(21);
        int numBinaries = BaseDocValuesFormatTestCase.random().nextInt(21);
        int numSortedNums = BaseDocValuesFormatTestCase.random().nextInt(21);
        int numDocs = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 2025, 2047);
        for (i = 0; i < numDocs; ++i) {
            int j;
            Document doc = new Document();
            for (j = 0; j < numSortedSets; ++j) {
                doc.add((IndexableField)new SortedSetDocValuesField("ss" + j, new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()))));
                doc.add((IndexableField)new SortedSetDocValuesField("ss" + j, new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()))));
            }
            for (j = 0; j < numBinaries; ++j) {
                doc.add((IndexableField)new BinaryDocValuesField("b" + j, new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()))));
            }
            for (j = 0; j < numSortedNums; ++j) {
                doc.add((IndexableField)new SortedNumericDocValuesField("sn" + j, TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
                doc.add((IndexableField)new SortedNumericDocValuesField("sn" + j, TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
            }
            writer.addDocument(doc);
        }
        writer.close();
        for (i = 0; i < 10; ++i) {
            int tid;
            final DirectoryReader r = DirectoryReader.open((Directory)dir);
            final CountDownLatch startingGun = new CountDownLatch(1);
            Thread[] threads = new Thread[TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 4, 10)];
            for (tid = 0; tid < threads.length; ++tid) {
                threads[tid] = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
                            PrintStream infoStream = new PrintStream((OutputStream)bos, false, IOUtils.UTF_8);
                            startingGun.await();
                            for (LeafReaderContext leaf : r.leaves()) {
                                CheckIndex.Status.DocValuesStatus status = CheckIndex.testDocValues((CodecReader)((SegmentReader)leaf.reader()), (PrintStream)infoStream, (boolean)true);
                                if (status.error == null) continue;
                                throw status.error;
                            }
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            for (tid = 0; tid < threads.length; ++tid) {
                threads[tid].start();
            }
            startingGun.countDown();
            for (tid = 0; tid < threads.length; ++tid) {
                threads[tid].join();
            }
            r.close();
        }
        dir.close();
    }

    public void testEmptyBinaryValueOnPageSizes() throws Exception {
        for (int i = 0; i < 20 && (i <= 14 || this.codecAcceptsHugeBinaryValues("field")); ++i) {
            BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
            RandomIndexWriter w = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir);
            BytesRef bytes = new BytesRef();
            bytes.bytes = new byte[1 << i];
            bytes.length = 1 << i;
            for (int j = 0; j < 4; ++j) {
                Document doc = new Document();
                doc.add((IndexableField)new BinaryDocValuesField("field", bytes));
                w.addDocument(doc);
            }
            Document doc = new Document();
            doc.add((IndexableField)new StoredField("id", "5"));
            doc.add((IndexableField)new BinaryDocValuesField("field", new BytesRef()));
            w.addDocument(doc);
            DirectoryReader r = w.getReader();
            w.close();
            BinaryDocValues values = MultiDocValues.getBinaryValues((IndexReader)r, (String)"field");
            for (int j = 0; j < 5; ++j) {
                BaseDocValuesFormatTestCase.assertEquals((long)j, (long)values.nextDoc());
                BytesRef result = values.binaryValue();
                BaseDocValuesFormatTestCase.assertTrue((result.length == 0 || result.length == 1 << i ? 1 : 0) != 0);
            }
            r.close();
            dir.close();
        }
    }

    public void testOneSortedNumber() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 5L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.nextValue());
        reader.close();
        directory.close();
    }

    public void testOneSortedNumberOneMissing() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)directory, new IndexWriterConfig(null));
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 5L));
        writer.addDocument((Iterable)doc);
        writer.addDocument((Iterable)new Document());
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.nextValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        reader.close();
        directory.close();
    }

    public void testNumberMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("field", 5L));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        NumericDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testTwoSortedNumber() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.nextValue());
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        reader.close();
        directory.close();
    }

    public void testTwoSortedNumberSameValue() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        reader.close();
        directory.close();
    }

    public void testTwoSortedNumberOneMissing() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)directory, new IndexWriterConfig(null));
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument((Iterable)doc);
        writer.addDocument((Iterable)new Document());
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.docValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.nextValue());
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        reader.close();
        directory.close();
    }

    public void testSortedNumberMerge() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        iwc.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        IndexWriter writer = new IndexWriter((Directory)directory, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        writer.addDocument((Iterable)doc);
        writer.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument((Iterable)doc);
        writer.forceMerge(1);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.nextValue());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.docValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.nextValue());
        reader.close();
        directory.close();
    }

    public void testSortedNumberMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedNumericDocValuesField("field", 5L));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedNumericDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedEnumAdvanceIndependently() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        SortedDocValuesField field = new SortedDocValuesField("field", new BytesRef((CharSequence)"2"));
        doc.add((IndexableField)field);
        iwriter.addDocument(doc);
        field.setBytesValue(new BytesRef((CharSequence)"1"));
        iwriter.addDocument(doc);
        field.setBytesValue(new BytesRef((CharSequence)"3"));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        this.doTestSortedSetEnumAdvanceIndependently(DocValues.singleton((SortedDocValues)dv));
        ireader.close();
        directory.close();
    }

    public void testSortedSetEnumAdvanceIndependently() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        SortedSetDocValuesField field1 = new SortedSetDocValuesField("field", new BytesRef((CharSequence)"2"));
        SortedSetDocValuesField field2 = new SortedSetDocValuesField("field", new BytesRef((CharSequence)"3"));
        doc.add((IndexableField)field1);
        doc.add((IndexableField)field2);
        iwriter.addDocument(doc);
        field1.setBytesValue(new BytesRef((CharSequence)"1"));
        iwriter.addDocument(doc);
        field2.setBytesValue(new BytesRef((CharSequence)"2"));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        this.doTestSortedSetEnumAdvanceIndependently(dv);
        ireader.close();
        directory.close();
    }

    protected void doTestSortedSetEnumAdvanceIndependently(SortedSetDocValues dv) throws IOException {
        if (dv.getValueCount() < 2L) {
            return;
        }
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>();
        TermsEnum te = dv.termsEnum();
        terms.add(BytesRef.deepCopyOf((BytesRef)te.next()));
        terms.add(BytesRef.deepCopyOf((BytesRef)te.next()));
        TermsEnum enum1 = dv.termsEnum();
        TermsEnum enum2 = dv.termsEnum();
        BytesRefBuilder term1 = new BytesRefBuilder();
        BytesRefBuilder term2 = new BytesRefBuilder();
        term1.copyBytes(enum1.next());
        term2.copyBytes(enum2.next());
        term1.copyBytes(enum1.next());
        BaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        BytesRefBuilder seekTerm = new BytesRefBuilder();
        seekTerm.append((BytesRef)terms.get(0));
        seekTerm.append((byte)0);
        enum1.seekCeil(seekTerm.get());
        term1.copyBytes(enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        enum1.seekCeil((BytesRef)terms.get(1));
        term1.copyBytes(enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        boolean found = enum1.seekExact((BytesRef)terms.get(1));
        BaseDocValuesFormatTestCase.assertTrue((boolean)found);
        term1.copyBytes(enum1.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        enum1.seekExact(1L);
        term1.copyBytes(enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
    }

    public void testSortedMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testNumericMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("field", 42L));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        NumericDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testSortedNumericMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedNumericDocValuesField("field", 42L));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedNumericDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testBinaryMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new BinaryDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        BinaryDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getBinaryDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        ireader.close();
        directory.close();
    }

    public void testRandomAdvanceNumeric() throws IOException {
        final long longRange = BaseDocValuesFormatTestCase.random().nextBoolean() ? (long)TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 1024) : TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), 1L, Long.MAX_VALUE);
        this.doTestRandomAdvance(new FieldCreator(){

            @Override
            public Field next() {
                return new NumericDocValuesField("field", TestUtil.nextLong(LuceneTestCase.random(), 0L, longRange));
            }

            @Override
            public DocIdSetIterator iterator(IndexReader r) throws IOException {
                return MultiDocValues.getNumericValues((IndexReader)r, (String)"field");
            }
        });
    }

    public void testRandomAdvanceBinary() throws IOException {
        this.doTestRandomAdvance(new FieldCreator(){

            @Override
            public Field next() {
                byte[] bytes = new byte[LuceneTestCase.random().nextInt(10)];
                LuceneTestCase.random().nextBytes(bytes);
                return new BinaryDocValuesField("field", new BytesRef(bytes));
            }

            @Override
            public DocIdSetIterator iterator(IndexReader r) throws IOException {
                return MultiDocValues.getBinaryValues((IndexReader)r, (String)"field");
            }
        });
    }

    private void doTestRandomAdvance(FieldCreator fieldCreator) throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter w = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        int numChunks = BaseDocValuesFormatTestCase.atLeast(10);
        int id = 0;
        HashSet<Integer> missingSet = new HashSet<Integer>();
        for (int i = 0; i < numChunks; ++i) {
            double sparseChance = BaseDocValuesFormatTestCase.random().nextDouble();
            int docCount = BaseDocValuesFormatTestCase.atLeast(1000);
            for (int j = 0; j < docCount; ++j) {
                Document doc = new Document();
                doc.add((IndexableField)new StoredField("id", id));
                if (BaseDocValuesFormatTestCase.random().nextDouble() > sparseChance) {
                    doc.add((IndexableField)fieldCreator.next());
                } else {
                    missingSet.add(id);
                }
                ++id;
                w.addDocument(doc);
            }
        }
        if (BaseDocValuesFormatTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        DirectoryReader r = w.getReader();
        FixedBitSet missing = new FixedBitSet(r.maxDoc());
        for (int docID = 0; docID < r.maxDoc(); ++docID) {
            Document doc = r.document(docID);
            if (!missingSet.contains(doc.getField("id").numericValue())) continue;
            missing.set(docID);
        }
        block3: for (int iter = 0; iter < 100; ++iter) {
            DocIdSetIterator values = fieldCreator.iterator((IndexReader)r);
            BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)values.docID());
            while (true) {
                int docID;
                if (BaseDocValuesFormatTestCase.random().nextBoolean()) {
                    docID = values.nextDoc();
                } else {
                    int range = BaseDocValuesFormatTestCase.random().nextInt(10) == 7 ? r.maxDoc() - values.docID() : 25;
                    int inc = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, range);
                    docID = values.advance(values.docID() + inc);
                }
                if (docID == Integer.MAX_VALUE) continue block3;
                BaseDocValuesFormatTestCase.assertFalse((boolean)missing.get(docID));
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{r, w, directory});
    }

    protected boolean codecAcceptsHugeBinaryValues(String field) {
        return true;
    }

    private static interface FieldCreator {
        public Field next();

        public DocIdSetIterator iterator(IndexReader var1) throws IOException;
    }
}

