/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.rrd4j.core.RrdFileBackend;

public class RrdRandomAccessFileBackend
extends RrdFileBackend {
    protected final RandomAccessFile rafile;

    protected RrdRandomAccessFileBackend(String path, boolean readOnly) throws IOException {
        super(path, readOnly);
        this.rafile = new RandomAccessFile(path, readOnly ? "r" : "rw");
    }

    @Override
    public void close() throws IOException {
        this.rafile.close();
    }

    @Override
    protected void write(long offset, byte[] b) throws IOException {
        this.rafile.seek(offset);
        this.rafile.write(b);
    }

    @Override
    protected void read(long offset, byte[] b) throws IOException {
        this.rafile.seek(offset);
        if (this.rafile.read(b) != b.length) {
            throw new IOException("Not enough bytes available in file " + this.getPath());
        }
    }

    @Override
    protected void setLength(long length) throws IOException {
        this.rafile.setLength(length);
    }
}

