/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.MemoryResource;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import org.jetbrains.annotations.Nullable;

public class ClassPath {
    private static final ResourceStringLoaderIterator ourResourceIterator = new ResourceStringLoaderIterator();
    private static final LoaderCollector ourLoaderCollector = new LoaderCollector();
    private final Stack<URL> myUrls = new Stack();
    private final List<Loader> myLoaders = new ArrayList<Loader>();
    private volatile boolean myAllUrlsWereProcessed;
    private final AtomicInteger myLastLoaderProcessed = new AtomicInteger();
    private final Map<URL, Loader> myLoadersMap = new HashMap<URL, Loader>();
    private final ClasspathCache myCache = new ClasspathCache();
    final boolean myCanLockJars;
    private final boolean myCanUseCache;
    private final boolean myAcceptUnescapedUrls;
    final boolean myPreloadJarContents;
    final boolean myCanHavePersistentIndex;
    final boolean myLazyClassloadingCaches;
    @Nullable
    private final CachePoolImpl myCachePool;
    @Nullable
    private final UrlClassLoader.CachingCondition myCachingCondition;
    final boolean myLogErrorOnMissingJar;
    private static final boolean ourDumpOrder = "true".equals(System.getProperty("idea.dump.order"));
    private static PrintStream ourOrder;
    private static long ourOrderSize;
    private static final Set<String> ourOrderedUrls;
    static final boolean ourLogTiming;
    private static final AtomicLong ourTotalTime;
    private static final AtomicInteger ourTotalRequests;

    public ClassPath(List<URL> urls, boolean canLockJars, boolean canUseCache, boolean acceptUnescapedUrls, boolean preloadJarContents, boolean canHavePersistentIndex, @Nullable CachePoolImpl cachePool, @Nullable UrlClassLoader.CachingCondition cachingCondition, boolean logErrorOnMissingJar, boolean lazyClassloadingCaches) {
        this.myLazyClassloadingCaches = lazyClassloadingCaches;
        this.myCanLockJars = canLockJars;
        this.myCanUseCache = canUseCache && !this.myLazyClassloadingCaches;
        this.myAcceptUnescapedUrls = acceptUnescapedUrls;
        this.myPreloadJarContents = preloadJarContents;
        this.myCachePool = cachePool;
        this.myCachingCondition = cachingCondition;
        this.myCanHavePersistentIndex = canHavePersistentIndex;
        this.myLogErrorOnMissingJar = logErrorOnMissingJar;
        this.push(urls);
    }

    @Deprecated
    void addURL(URL url) {
        this.push(Collections.singletonList(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(List<URL> urls) {
        if (!urls.isEmpty()) {
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                for (int i = urls.size() - 1; i >= 0; --i) {
                    this.myUrls.push(urls.get(i));
                }
                this.myAllUrlsWereProcessed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Resource getResource(String s) {
        long started = ClassPath.startTiming();
        try {
            Loader loader;
            int i;
            if (this.myCanUseCache) {
                boolean allUrlsWereProcessed = this.myAllUrlsWereProcessed;
                i = allUrlsWereProcessed ? 0 : this.myLastLoaderProcessed.get();
                Resource prevResource = this.myCache.iterateLoaders(s, ourResourceIterator, s, this);
                if (prevResource != null || allUrlsWereProcessed) {
                    Resource resource = prevResource;
                    return resource;
                }
            } else {
                i = 0;
            }
            String shortName = ClasspathCache.transformName(s);
            while ((loader = this.getLoader(i++)) != null) {
                if (this.myCanUseCache && !this.myCache.loaderHasName(s, shortName, loader)) continue;
                Resource resource = loader.getResource(s);
                if (resource == null) continue;
                Resource resource2 = resource;
                return resource2;
            }
        }
        finally {
            ClassPath.logTiming(this, started, s);
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) {
        return new MyEnumeration(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoader(int i) {
        while (this.myLoaders.size() < i + 1) {
            URL url;
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                if (this.myUrls.empty()) {
                    if (this.myCanUseCache) {
                        this.myCache.nameSymbolsLoaded();
                        this.myAllUrlsWereProcessed = true;
                    }
                    return null;
                }
                url = this.myUrls.pop();
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                this.initLoaders(url, this.myLoaders.size());
            }
            catch (IOException e) {
                Logger.getInstance(ClassPath.class).info("url: " + url, e);
            }
        }
        return this.myLoaders.get(i);
    }

    public List<URL> getBaseUrls() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Loader loader : this.myLoaders) {
            result.add(loader.getBaseURL());
        }
        return result;
    }

    private void initLoaders(URL url, int index) throws IOException {
        File file;
        Loader loader;
        String path;
        if (this.myAcceptUnescapedUrls) {
            path = url.getFile();
        } else {
            try {
                path = url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                Logger.getInstance(ClassPath.class).error("url: " + url, e);
                path = url.getFile();
            }
        }
        if (path != null && "file".equals(url.getProtocol()) && (loader = this.createLoader(url, index, file = new File(path), file.getName().startsWith("classpath"))) != null) {
            this.initLoader(url, loader);
        }
    }

    private Loader createLoader(URL url, int index, File file, boolean processRecursively) throws IOException {
        if (file.isDirectory()) {
            return new FileLoader(url, index, this);
        }
        if (file.isFile()) {
            String[] referencedJars;
            JarLoader loader = new JarLoader(url, index, this);
            if (processRecursively && (referencedJars = ClassPath.loadManifestClasspath(loader)) != null) {
                long s2 = ourLogTiming ? System.nanoTime() : 0L;
                ArrayList<URL> urls = new ArrayList<URL>(referencedJars.length);
                for (String referencedJar : referencedJars) {
                    try {
                        urls.add(new URI(referencedJar).toURL());
                    }
                    catch (Exception e) {
                        Logger.getInstance(ClassPath.class).warn("url: " + url + " / " + referencedJar, e);
                    }
                }
                this.push(urls);
                if (ourLogTiming) {
                    System.out.println("Loaded all " + referencedJars.length + " urls " + (System.nanoTime() - s2) / 1000000L + "ms");
                }
            }
            return loader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLoader(URL url, Loader loader) throws IOException {
        if (this.myCanUseCache) {
            boolean lastOne;
            ClasspathCache.LoaderData data;
            ClasspathCache.LoaderData loaderData = data = this.myCachePool == null ? null : this.myCachePool.getCachedData(url);
            if (data == null) {
                data = loader.buildData();
                if (this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
                    this.myCachePool.cacheData(url, data);
                }
            }
            this.myCache.applyLoaderData(data, loader);
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                lastOne = this.myUrls.isEmpty();
            }
            if (lastOne) {
                this.myCache.nameSymbolsLoaded();
                this.myAllUrlsWereProcessed = true;
            }
            this.myLastLoaderProcessed.incrementAndGet();
        }
        this.myLoaders.add(loader);
        this.myLoadersMap.put(url, loader);
    }

    Attributes getManifestData(URL url) {
        return this.myCanUseCache && this.myCachePool != null ? this.myCachePool.getManifestData(url) : null;
    }

    void cacheManifestData(URL url, Attributes manifestAttributes) {
        if (this.myCanUseCache && this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
            this.myCachePool.cacheManifestData(url, manifestAttributes);
        }
    }

    private static synchronized void printOrder(Loader loader, String url, Resource resource) {
        if (!ourDumpOrder) {
            return;
        }
        if (!ourOrderedUrls.add(url)) {
            return;
        }
        String home = FileUtil.toSystemIndependentName(PathManager.getHomePath());
        try {
            if (resource instanceof MemoryResource) {
                ourOrderSize += (long)resource.getBytes().length;
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        if (ourOrder == null) {
            File orderFile = new File(PathManager.getBinPath(), "order.txt");
            try {
                if (!FileUtil.ensureCanCreateFile(orderFile)) {
                    return;
                }
                ourOrder = new PrintStream(new FileOutputStream(orderFile, true));
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        ClassPath.closeOrderStream();
                    }
                });
            }
            catch (IOException e) {
                return;
            }
        }
        if (ourOrder != null) {
            String jarURL;
            Pair<String, String> pair = URLUtil.splitJarUrl(loader.getBaseURL().toExternalForm());
            String string = jarURL = pair != null ? (String)pair.first : null;
            if (jarURL != null && jarURL.startsWith(home)) {
                jarURL = jarURL.replaceFirst(home, "");
                jarURL = StringUtil.trimEnd(jarURL, "!/");
                ourOrder.println(url + ":" + jarURL);
            }
        }
    }

    private static synchronized void closeOrderStream() {
        ourOrder.close();
        System.out.println(ourOrderSize);
    }

    private static long startTiming() {
        return ourLogTiming ? System.nanoTime() : 0L;
    }

    private static void logTiming(ClassPath path, long started, String msg) {
        if (!ourLogTiming) {
            return;
        }
        long time = System.nanoTime() - started;
        long totalTime = ourTotalTime.addAndGet(time);
        int totalRequests = ourTotalRequests.incrementAndGet();
        if (time > 10000000L) {
            System.out.println(time / 1000000L + " ms for " + msg);
        }
        if (totalRequests % 10000 == 0) {
            System.out.println(path + ", requests:" + ourTotalRequests + ", time:" + totalTime / 1000000L + "ms");
        }
    }

    private static String[] loadManifestClasspath(JarLoader loader) {
        try {
            String[] urls;
            String classPath = loader.getClassPathManifestAttribute();
            if (classPath != null && (urls = classPath.split(" ")).length > 0 && urls[0].startsWith("file:")) {
                return urls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        ourOrderedUrls = new HashSet<String>();
        ourLogTiming = Boolean.getBoolean("idea.print.classpath.timing");
        ourTotalTime = new AtomicLong();
        ourTotalRequests = new AtomicInteger();
        if (ourLogTiming) {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook for tracing classloading information"){

                @Override
                public void run() {
                    System.out.println("Classloading requests:" + ourTotalRequests + ", time:" + ourTotalTime.get() / 1000000L + "ms");
                }
            });
        }
    }

    private static class LoaderCollector
    extends ClasspathCache.LoaderIterator<Object, Collection<Loader>, Object> {
        private LoaderCollector() {
        }

        @Override
        Object process(Loader loader, Collection<Loader> parameter, Object parameter2) {
            parameter.add(loader);
            return null;
        }
    }

    private static class ResourceStringLoaderIterator
    extends ClasspathCache.LoaderIterator<Resource, String, ClassPath> {
        private ResourceStringLoaderIterator() {
        }

        @Override
        Resource process(Loader loader, String s, ClassPath classPath) {
            if (!classPath.myCache.loaderHasName(s, ClasspathCache.transformName(s), loader)) {
                return null;
            }
            Resource resource = loader.getResource(s);
            if (resource != null) {
                ClassPath.printOrder(loader, s, resource);
            }
            return resource;
        }
    }

    private class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex;
        private Resource myRes;
        private final String myName;
        private final String myShortName;
        private final List<Loader> myLoaders;

        MyEnumeration(String name) {
            this.myName = name;
            this.myShortName = ClasspathCache.transformName(name);
            ArrayList loaders = null;
            if (ClassPath.this.myCanUseCache && ClassPath.this.myAllUrlsWereProcessed) {
                LinkedHashSet loadersSet = new LinkedHashSet();
                ClassPath.this.myCache.iterateLoaders(name, ourLoaderCollector, loadersSet, this);
                if (name.endsWith("/")) {
                    ClassPath.this.myCache.iterateLoaders(name.substring(0, name.length() - 1), ourLoaderCollector, loadersSet, this);
                } else {
                    ClassPath.this.myCache.iterateLoaders(name + "/", ourLoaderCollector, loadersSet, this);
                }
                loaders = new ArrayList(loadersSet);
            }
            this.myLoaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.myRes != null) {
                return true;
            }
            long started = ClassPath.startTiming();
            try {
                if (this.myLoaders != null) {
                    while (this.myIndex < this.myLoaders.size()) {
                        Loader loader = this.myLoaders.get(this.myIndex++);
                        if (!ClassPath.this.myCache.loaderHasName(this.myName, this.myShortName, loader)) {
                            this.myRes = null;
                            continue;
                        }
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    Loader loader;
                    while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                        if (ClassPath.this.myCanUseCache && !ClassPath.this.myCache.loaderHasName(this.myName, this.myShortName, loader)) continue;
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                ClassPath.logTiming(ClassPath.this, started, this.myName);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }
    }
}

