/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Decompressor {
    private Condition<? super String> myFilter = null;
    private boolean myOverwrite = true;
    private Consumer<? super File> myConsumer;

    public Decompressor filter(@Nullable Condition<? super String> filter) {
        this.myFilter = filter;
        return this;
    }

    public Decompressor overwrite(boolean overwrite) {
        this.myOverwrite = overwrite;
        return this;
    }

    public Decompressor postprocessor(@Nullable Consumer<? super File> consumer) {
        this.myConsumer = consumer;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull File outputDir) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(0);
        }
        this.openStream();
        try {
            Entry entry;
            while ((entry = this.nextEntry()) != null) {
                String name = entry.name;
                if (this.myFilter != null && !this.myFilter.value(name)) continue;
                File outputFile = Decompressor.entryFile(outputDir, name);
                if (entry.isDirectory) {
                    FileUtil.createDirectory(outputFile);
                } else if (!outputFile.exists() || this.myOverwrite) {
                    InputStream inputStream = this.openEntryStream(entry);
                    try {
                        FileUtil.createParentDirs(outputFile);
                        FileOutputStream outputStream = new FileOutputStream(outputFile);
                        try {
                            FileUtil.copy(inputStream, outputStream);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    finally {
                        this.closeEntryStream(inputStream);
                    }
                }
                if (this.myConsumer == null) continue;
                this.myConsumer.consume(outputFile);
            }
        }
        finally {
            this.closeStream();
        }
    }

    protected Decompressor() {
    }

    protected abstract void openStream() throws IOException;

    protected abstract Entry nextEntry() throws IOException;

    protected abstract InputStream openEntryStream(Entry var1) throws IOException;

    protected abstract void closeEntryStream(InputStream var1) throws IOException;

    protected abstract void closeStream() throws IOException;

    @NotNull
    public static File entryFile(@NotNull File outputDir, @NotNull String entryName) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(1);
        }
        if (entryName == null) {
            Decompressor.$$$reportNull$$$0(2);
        }
        if (entryName.contains("..") && ArrayUtil.contains("..", entryName.split("[/\\\\]"))) {
            throw new IOException("Invalid entry name: " + entryName);
        }
        File file = new File(outputDir, entryName);
        if (file == null) {
            Decompressor.$$$reportNull$$$0(3);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/Decompressor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/Decompressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "entryFile";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Entry {
        private final String name;
        private final boolean isDirectory;

        Entry(String name, boolean isDirectory) {
            this.name = name;
            this.isDirectory = isDirectory;
        }
    }

    public static class Zip
    extends Decompressor {
        private final File mySource;
        private ZipFile myZip;
        private Enumeration<? extends ZipEntry> myEntries;
        private ZipEntry myEntry;

        public Zip(@NotNull File file) {
            if (file == null) {
                Zip.$$$reportNull$$$0(0);
            }
            this.mySource = file;
        }

        @Override
        protected void openStream() throws IOException {
            this.myZip = new ZipFile(this.mySource);
            this.myEntries = this.myZip.entries();
        }

        @Override
        protected Entry nextEntry() {
            this.myEntry = this.myEntries.hasMoreElements() ? this.myEntries.nextElement() : null;
            return this.myEntry == null ? null : new Entry(this.myEntry.getName(), this.myEntry.isDirectory());
        }

        @Override
        protected InputStream openEntryStream(Entry entry) throws IOException {
            return this.myZip.getInputStream(this.myEntry);
        }

        @Override
        protected void closeEntryStream(InputStream stream) throws IOException {
            stream.close();
        }

        @Override
        protected void closeStream() throws IOException {
            this.myZip.close();
            this.myZip = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/Decompressor$Zip", "<init>"));
        }
    }

    public static class Tar
    extends Decompressor {
        private final Object mySource;
        private TarArchiveInputStream myStream;

        public Tar(@NotNull File file) {
            if (file == null) {
                Tar.$$$reportNull$$$0(0);
            }
            this.mySource = file;
        }

        public Tar(@NotNull InputStream stream) {
            if (stream == null) {
                Tar.$$$reportNull$$$0(1);
            }
            this.mySource = stream;
        }

        @Override
        protected void openStream() throws IOException {
            BufferedInputStream input;
            block2: {
                input = new BufferedInputStream(this.mySource instanceof File ? new FileInputStream((File)this.mySource) : (InputStream)this.mySource);
                try {
                    input = new CompressorStreamFactory().createCompressorInputStream((InputStream)input);
                }
                catch (CompressorException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof IOException)) break block2;
                    throw (IOException)cause;
                }
            }
            this.myStream = new TarArchiveInputStream((InputStream)input);
        }

        @Override
        protected Entry nextEntry() throws IOException {
            TarArchiveEntry tarEntry = this.myStream.getNextTarEntry();
            return tarEntry == null ? null : new Entry(tarEntry.getName(), tarEntry.isDirectory());
        }

        @Override
        protected InputStream openEntryStream(Entry entry) {
            return this.myStream;
        }

        @Override
        protected void closeEntryStream(InputStream stream) {
        }

        @Override
        protected void closeStream() throws IOException {
            if (this.mySource instanceof File) {
                this.myStream.close();
                this.myStream = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Decompressor$Tar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

