/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Compressor
implements Closeable {
    private Condition<? super String> myFilter = null;

    public Compressor filter(@Nullable Condition<? super String> filter) {
        this.myFilter = filter;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFile(@NotNull String entryName, @NotNull File file) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            Compressor.$$$reportNull$$$0(1);
        }
        if (this.accepts(entryName = Compressor.entryName(entryName))) {
            FileInputStream source = new FileInputStream(file);
            try {
                this.writeFileEntry(entryName, source, file.length(), file.lastModified());
            }
            finally {
                ((InputStream)source).close();
            }
        }
    }

    public final void addFile(@NotNull String entryName, @NotNull byte[] content) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(2);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(3);
        }
        this.addFile(entryName, content, -1L);
    }

    public final void addFile(@NotNull String entryName, @NotNull byte[] content, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(4);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(5);
        }
        if (this.accepts(entryName = Compressor.entryName(entryName))) {
            this.writeFileEntry(entryName, new ByteArrayInputStream(content), content.length, Compressor.timestamp(timestamp));
        }
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(6);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(7);
        }
        this.addFile(entryName, content, -1L);
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(8);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(9);
        }
        if (this.accepts(entryName = Compressor.entryName(entryName))) {
            this.writeFileEntry(entryName, content, -1L, Compressor.timestamp(timestamp));
        }
    }

    public final void addDirectory(@NotNull String entryName) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(10);
        }
        this.addDirectory(entryName, -1L);
    }

    public final void addDirectory(@NotNull String entryName, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(11);
        }
        if (this.accepts(entryName = Compressor.entryName(entryName))) {
            this.writeDirectoryEntry(entryName, Compressor.timestamp(timestamp));
        }
    }

    public final void addDirectory(@NotNull File directory) throws IOException {
        if (directory == null) {
            Compressor.$$$reportNull$$$0(12);
        }
        this.addRecursively("", directory);
    }

    public final void addDirectory(@NotNull String prefix, @NotNull File directory) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(13);
        }
        if (directory == null) {
            Compressor.$$$reportNull$$$0(14);
        }
        this.addRecursively(Compressor.entryName(prefix), directory);
    }

    protected Compressor() {
    }

    private static String entryName(String name) {
        String entryName = StringUtil.trimLeading(StringUtil.trimTrailing(name.replace('\\', '/'), '/'), '/');
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("Invalid entry name: " + name);
        }
        return entryName;
    }

    private static long timestamp(long timestamp) {
        return timestamp == -1L ? System.currentTimeMillis() : timestamp;
    }

    private boolean accepts(String entryName) {
        return this.myFilter == null || this.myFilter.value(entryName);
    }

    private void addRecursively(String prefix, File directory) throws IOException {
        File[] children = directory.listFiles();
        if (children != null) {
            if (!prefix.isEmpty()) {
                this.addDirectory(prefix, directory.lastModified());
            }
            for (File child : children) {
                String name;
                String string = name = prefix.isEmpty() ? child.getName() : prefix + '/' + child.getName();
                if (child.isDirectory()) {
                    this.addRecursively(name, child);
                    continue;
                }
                this.addFile(name, child);
            }
        }
    }

    protected abstract void writeDirectoryEntry(String var1, long var2) throws IOException;

    protected abstract void writeFileEntry(String var1, InputStream var2, long var3, long var5) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/Compressor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Jar
    extends Zip {
        public Jar(@NotNull File file) throws IOException {
            if (file == null) {
                Jar.$$$reportNull$$$0(0);
            }
            super(new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
        }

        public final void addManifest(@NotNull Manifest manifest) throws IOException {
            if (manifest == null) {
                Jar.$$$reportNull$$$0(1);
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            manifest.write(buffer);
            this.addFile("META-INF/MANIFEST.MF", buffer.toByteArray());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manifest";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/io/Compressor$Jar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addManifest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Zip
    extends Compressor {
        private final ZipOutputStream myStream;

        public Zip(@NotNull File file) throws FileNotFoundException {
            if (file == null) {
                Zip.$$$reportNull$$$0(0);
            }
            this(new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
        }

        public Zip(@NotNull OutputStream stream) {
            if (stream == null) {
                Zip.$$$reportNull$$$0(1);
            }
            this(new ZipOutputStream(stream));
        }

        public Zip withLevel(int compressionLevel) {
            this.myStream.setLevel(compressionLevel);
            return this;
        }

        protected Zip(ZipOutputStream stream) {
            this.myStream = stream;
        }

        @Override
        protected void writeDirectoryEntry(String name, long timestamp) throws IOException {
            ZipEntry e = new ZipEntry(name + '/');
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
            e.setTime(timestamp);
            this.myStream.putNextEntry(e);
            this.myStream.closeEntry();
        }

        @Override
        protected void writeFileEntry(String name, InputStream source, long length, long timestamp) throws IOException {
            ZipEntry e = new ZipEntry(name);
            if (length == 0L) {
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
            }
            e.setTime(timestamp);
            this.myStream.putNextEntry(e);
            FileUtil.copy(source, this.myStream);
            this.myStream.closeEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Compressor$Zip";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Tar
    extends Compressor {
        private final TarArchiveOutputStream myStream;

        public Tar(@NotNull File file, @NotNull Compression compression) throws IOException {
            if (file == null) {
                Tar.$$$reportNull$$$0(0);
            }
            if (compression == null) {
                Tar.$$$reportNull$$$0(1);
            }
            this(new FileOutputStream(file), compression);
        }

        private Tar(OutputStream stream, Compression compression) throws IOException {
            this.myStream = new TarArchiveOutputStream(Tar.compressedStream(stream, compression));
            this.myStream.setLongFileMode(3);
        }

        private static OutputStream compressedStream(OutputStream stream, Compression compression) throws IOException {
            if (compression == Compression.GZIP) {
                return new GzipCompressorOutputStream(stream);
            }
            if (compression == Compression.BZIP2) {
                return new BZip2CompressorOutputStream(stream);
            }
            return stream;
        }

        @Override
        protected void writeDirectoryEntry(String name, long timestamp) throws IOException {
            TarArchiveEntry e = new TarArchiveEntry(name + '/');
            e.setModTime(timestamp);
            this.myStream.putArchiveEntry((ArchiveEntry)e);
            this.myStream.closeArchiveEntry();
        }

        @Override
        protected void writeFileEntry(String name, InputStream source, long length, long timestamp) throws IOException {
            TarArchiveEntry e = new TarArchiveEntry(name);
            e.setSize(length);
            e.setModTime(timestamp);
            this.myStream.putArchiveEntry((ArchiveEntry)e);
            FileUtil.copy(source, (OutputStream)this.myStream);
            this.myStream.closeArchiveEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compression";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Compressor$Tar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum Compression {
            GZIP,
            BZIP2,
            NONE;

        }
    }
}

