/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.Splitter;
import javax.swing.JComponent;

public class PseudoSplitter
extends Splitter {
    private boolean myFirstIsFixed = false;
    private int myFirstFixedSize;

    public PseudoSplitter(boolean vertical) {
        super(vertical);
    }

    private int getSizeForComp(JComponent component) {
        return this.getOrientation() ? component.getHeight() : component.getWidth();
    }

    public void fixFirst(float proportion) {
        assert (this.getFirstComponent() != null);
        int total = this.getSizeForComp(this);
        this.myFirstFixedSize = (int)(proportion * (float)(total - this.getDividerWidth()));
        this.myFirstIsFixed = true;
    }

    public void fixFirst() {
        assert (this.getFirstComponent() != null);
        this.myFirstFixedSize = this.getSizeForComp(this.getFirstComponent());
        this.myFirstIsFixed = true;
    }

    public void freeAll() {
        this.myFirstIsFixed = false;
    }

    @Override
    public void doLayout() {
        int total = this.getSizeForComp(this);
        if (this.myFirstIsFixed) {
            this.myProportion = (float)this.myFirstFixedSize / (float)(total - this.getDividerWidth());
        }
        super.doLayout();
    }

    @Override
    public void setProportion(float proportion) {
        boolean firstIsFixed = this.myFirstIsFixed;
        this.myFirstIsFixed = false;
        super.setProportion(proportion);
        int total = this.getSizeForComp(this);
        if (firstIsFixed) {
            this.myFirstFixedSize = (int)(this.myProportion * (float)(total - this.getDividerWidth()));
            this.myFirstIsFixed = true;
        }
    }
}

