/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.jetbrains.rest.editor.RestJavaFxHtmlPanel;
import com.jetbrains.rest.editor.RestPreviewPanel;
import com.jetbrains.rest.editor.RestPreviewProvider;
import com.jetbrains.rest.editor.RestSettings;
import com.jetbrains.rest.editor.RestSwingHtmlPanel;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    private static final long PARSING_CALL_TIMEOUT_MS = 50L;
    private static final String NO_PREVIEW = "<h2>No preview available.</h2><br/><br/>";
    private static final long RENDERING_DELAY_MS = 20L;
    @NotNull
    private final RestPreviewPanel myPanel;
    @NotNull
    private final VirtualFile myFile;
    private final Project myProject;
    @Nullable
    private final Document myDocument;
    @NotNull
    private final Alarm myPooledAlarm;
    @NotNull
    private final Alarm mySwingAlarm;
    private final Object REQUESTS_LOCK;
    @Nullable
    private Runnable myLastRequest;
    @NotNull
    private String myLastRenderedHtml;

    public RestPreviewFileEditor(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(0);
        }
        this.myPooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySwingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.REQUESTS_LOCK = new Object();
        this.myLastRequest = null;
        this.myLastRenderedHtml = "";
        this.myFile = file;
        this.myProject = project;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        RestPreviewPanel restPreviewPanel = this.myPanel = RestSettings.getInstance().getCurrentPanel().equals("Swing") ? new RestSwingHtmlPanel() : new RestJavaFxHtmlPanel();
        if (this.myDocument != null) {
            this.myDocument.addDocumentListener(new DocumentListener(){

                public void beforeDocumentChange(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    RestPreviewFileEditor.this.myPooledAlarm.cancelAllRequests();
                }

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    RestPreviewFileEditor.this.myPooledAlarm.addRequest(() -> RestPreviewFileEditor.this.updateHtml(), 50L);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/jetbrains/rest/editor/RestPreviewFileEditor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeDocumentChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "documentChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel.getComponent();
        if (jComponent == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getComponent();
    }

    @NotNull
    public String getName() {
        if ("ReStructuredText HTML Preview" == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return "ReStructuredText HTML Preview";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.myPooledAlarm.cancelAllRequests();
        this.myPooledAlarm.addRequest(() -> this.updateHtml(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtml() {
        if (!this.myFile.isValid() || this.myDocument == null || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Pair<String, String> htmlAndError = RestPreviewProvider.getProviders()[0].toHtml(this.myDocument.getText(), this.myFile, this.myProject);
        if (htmlAndError == null) {
            return;
        }
        String html = (String)htmlAndError.getFirst();
        if (html.isEmpty()) {
            html = NO_PREVIEW + (String)htmlAndError.getSecond();
        }
        if (!this.myFile.isValid() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastRequest);
            }
            String finalHtml = html;
            this.myLastRequest = () -> {
                if (!finalHtml.equals(this.myLastRenderedHtml)) {
                    this.myLastRenderedHtml = finalHtml;
                    this.myPanel.setHtml(this.myLastRenderedHtml);
                }
                this.myPanel.render();
                Object object = this.REQUESTS_LOCK;
                synchronized (object) {
                    this.myLastRequest = null;
                }
            };
            this.mySwingAlarm.addRequest(this.myLastRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            RestPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myPanel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rest/editor/RestPreviewFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rest/editor/RestPreviewFileEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

