/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLValue;

public class YamlGenericValueAdapter
implements JsonValueAdapter {
    @NotNull
    private final YAMLValue myValue;

    public YamlGenericValueAdapter(@NotNull YAMLValue value) {
        if (value == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(0);
        }
        this.myValue = value;
    }

    public boolean isShouldBeIgnored() {
        return true;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isStringLiteral() {
        String text = this.getTextWithoutRefs();
        return !YamlGenericValueAdapter.hasNonStringTags(text);
    }

    private String getTextWithoutRefs() {
        YAMLAnchor[] anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myValue, YAMLAnchor.class);
        if (anchors == null || anchors.length == 0) {
            return this.myValue.getText();
        }
        int endOffset = anchors[anchors.length - 1].getTextRange().getEndOffset();
        TextRange valueTextRange = this.myValue.getTextRange();
        int offset = valueTextRange.getEndOffset();
        TextRange range = new TextRange(endOffset, offset);
        range = range.shiftLeft(valueTextRange.getStartOffset());
        String text = this.myValue.getText();
        return text.substring(range.getStartOffset()).trim();
    }

    private static boolean hasNonStringTags(@NotNull String text) {
        if (text == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(1);
        }
        return YamlGenericValueAdapter.hasTag(text, "bool") || YamlGenericValueAdapter.hasTag(text, "null") || YamlGenericValueAdapter.hasTag(text, "int") || YamlGenericValueAdapter.hasTag(text, "float");
    }

    private static boolean hasTag(@NotNull String text, @NotNull String tagName) {
        if (text == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(2);
        }
        if (tagName == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(3);
        }
        return StringUtil.startsWith((CharSequence)text, (CharSequence)("!!" + tagName));
    }

    public boolean isNumberLiteral() {
        String text = this.getTextWithoutRefs();
        return YamlGenericValueAdapter.isNumber(text);
    }

    public boolean isBooleanLiteral() {
        String text = this.getTextWithoutRefs();
        return "true".equals(text) || "false".equals(text) || YamlGenericValueAdapter.hasTag(text, "bool");
    }

    public boolean isNull() {
        String text = this.getTextWithoutRefs();
        return "null".equals(text) || YamlGenericValueAdapter.hasTag(text, "null");
    }

    @NotNull
    public PsiElement getDelegate() {
        YAMLValue yAMLValue = this.myValue;
        if (yAMLValue == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(4);
        }
        return yAMLValue;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    public boolean shouldCheckIntegralRequirements() {
        return false;
    }

    private static boolean isNumber(@Nullable String s) {
        if (s == null) {
            return false;
        }
        return YamlGenericValueAdapter.isInteger(s) || YamlGenericValueAdapter.isFloat(s);
    }

    private static boolean isInteger(@NotNull String s) {
        int startIndex;
        if (s == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(5);
        }
        if (s.length() == 0) {
            return false;
        }
        if ("0".equals(s)) {
            return true;
        }
        if (YamlGenericValueAdapter.hasTag(s, "int")) {
            return true;
        }
        for (int i = startIndex = s.charAt(0) == '-' ? 1 : 0; i < s.length(); ++i) {
            if (i == startIndex && s.charAt(i) == '0') {
                return false;
            }
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFloat(@NotNull String s) {
        if (s == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(6);
        }
        if (".inf".equals(s) || "-.inf".equals(s) || ".nan".equals(s)) {
            return true;
        }
        if (YamlGenericValueAdapter.hasTag(s, "float")) {
            return true;
        }
        return Pattern.matches("-?[1-9](\\.[0-9]*[1-9])?(e[-+][1-9][0-9]*)?", s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlGenericValueAdapter";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlGenericValueAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasNonStringTags";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasTag";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInteger";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFloat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

