/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettingsForm;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownSettingsConfigurable
implements SearchableConfigurable {
    static final String PLANT_UML_DIRECTORY = "plantUML";
    static final String PLANTUML_JAR_URL = Registry.stringValue((String)"markdown.plantuml.download.link");
    static final String PLANTUML_JAR = "plantuml.jar";
    private static final String DOWNLOAD_CACHE_DIRECTORY = "download-cache";
    public static final Ref<VirtualFile> PLANTUML_JAR_TEST = Ref.create();
    @Nullable
    private MarkdownSettingsForm myForm;
    @NotNull
    private final MarkdownApplicationSettings myMarkdownApplicationSettings;

    public MarkdownSettingsConfigurable(@NotNull MarkdownApplicationSettings markdownApplicationSettings) {
        if (markdownApplicationSettings == null) {
            MarkdownSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this.myForm = null;
        this.myMarkdownApplicationSettings = markdownApplicationSettings;
    }

    @NotNull
    public String getId() {
        if ("Settings.Markdown" == null) {
            MarkdownSettingsConfigurable.$$$reportNull$$$0(1);
        }
        return "Settings.Markdown";
    }

    @Nls
    public String getDisplayName() {
        return MarkdownBundle.message("markdown.settings.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        MarkdownSettingsForm form = this.getForm();
        if (form == null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel(MarkdownBundle.message("markdown.settings.no.providers", new Object[0])), "North");
            return panel;
        }
        return form.getComponent();
    }

    @Nullable
    public MarkdownSettingsForm getForm() {
        if (!MarkdownHtmlPanelProvider.hasAvailableProviders()) {
            return null;
        }
        if (this.myForm == null) {
            this.myForm = new MarkdownSettingsForm();
        }
        return this.myForm;
    }

    public boolean isModified() {
        MarkdownSettingsForm form = this.getForm();
        if (form == null) {
            return false;
        }
        return !form.getMarkdownCssSettings().equals(this.myMarkdownApplicationSettings.getMarkdownCssSettings()) || !form.getMarkdownPreviewSettings().equals(this.myMarkdownApplicationSettings.getMarkdownPreviewSettings()) || form.isDisableInjections() != this.myMarkdownApplicationSettings.isDisableInjections();
    }

    public void apply() throws ConfigurationException {
        MarkdownSettingsForm form = this.getForm();
        if (form == null) {
            return;
        }
        form.validate();
        this.myMarkdownApplicationSettings.setMarkdownCssSettings(form.getMarkdownCssSettings());
        this.myMarkdownApplicationSettings.setMarkdownPreviewSettings(form.getMarkdownPreviewSettings());
        this.myMarkdownApplicationSettings.setDisableInjections(form.isDisableInjections());
        ((MarkdownApplicationSettings.SettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(MarkdownApplicationSettings.SettingsChangedListener.TOPIC)).settingsChanged(this.myMarkdownApplicationSettings);
    }

    public void reset() {
        MarkdownSettingsForm form = this.getForm();
        if (form == null) {
            return;
        }
        form.setMarkdownCssSettings(this.myMarkdownApplicationSettings.getMarkdownCssSettings());
        form.setMarkdownPreviewSettings(this.myMarkdownApplicationSettings.getMarkdownPreviewSettings());
        form.setDisableInjections(this.myMarkdownApplicationSettings.isDisableInjections());
    }

    public void disposeUIResources() {
        if (this.myForm != null) {
            Disposer.dispose((Disposable)this.myForm);
        }
        this.myForm = null;
    }

    public static boolean isPlantUMLAvailable() {
        File jarPath = MarkdownSettingsConfigurable.getDownloadedJarPath();
        return jarPath != null && jarPath.exists();
    }

    @NotNull
    public static File getDirectoryToDownload() {
        File file = new File(PathManager.getSystemPath(), "download-cache/plantUML");
        if (file == null) {
            MarkdownSettingsConfigurable.$$$reportNull$$$0(2);
        }
        return file;
    }

    @Nullable
    public static File getDownloadedJarPath() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Optional.ofNullable(PLANTUML_JAR_TEST.get()).map(VfsUtilCore::virtualToIoFile).orElse(null);
        }
        return new File(MarkdownSettingsConfigurable.getDirectoryToDownload(), PLANTUML_JAR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markdownApplicationSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownSettingsConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryToDownload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

