/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.DialogManager;
import com.intellij.util.text.StringKt;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncAction;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpstreamEditorKt;
import org.jetbrains.settingsRepository.actions.SyncActionKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/settingsRepository/SyncAction;", "Ljavax/swing/AbstractAction;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "urlTextField", "Ljavax/swing/JTextField;", "project", "Lcom/intellij/openapi/project/Project;", "dialogManager", "Lcom/intellij/ui/components/DialogManager;", "(Lorg/jetbrains/settingsRepository/SyncType;Ljavax/swing/JTextField;Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/components/DialogManager;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "createError", "Lcom/intellij/openapi/ui/ValidationInfo;", "message", "", "doSync", "", "saveRemoteRepositoryUrl", "intellij.settingsRepository"})
final class SyncAction
extends AbstractAction {
    private final SyncType syncType;
    private final JTextField urlTextField;
    private final Project project;
    private final DialogManager dialogManager;

    private final ValidationInfo saveRemoteRepositoryUrl() {
        String url = StringKt.nullize((String)this.urlTextField.getText(), (boolean)true);
        String string = UpstreamEditorKt.validateUrl(url, this.project);
        if (string != null) {
            String string2;
            String it = string2 = string;
            return this.createError(it);
        }
        RepositoryManager repositoryManager = IcsManagerKt.getIcsManager().getRepositoryManager();
        repositoryManager.createRepositoryIfNeed();
        repositoryManager.setUpstream(url, null);
        return null;
    }

    private final ValidationInfo createError(String message) {
        return new ValidationInfo(message, (JComponent)this.urlTextField);
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.dialogManager.performAction((Function0)new Function0<List<? extends ValidationInfo>>(this){
            final /* synthetic */ SyncAction this$0;

            @Nullable
            public final List<ValidationInfo> invoke() {
                return SyncAction.access$doSync(this.this$0);
            }
            {
                this.this$0 = syncAction;
                super(0);
            }
        });
    }

    private final List<ValidationInfo> doSync() {
        IcsManager icsManager2 = IcsManagerKt.getIcsManager();
        ActionsCollector.getInstance().record("Ics." + this.getValue("Name"), IcsManager.class);
        boolean isRepositoryWillBeCreated = !icsManager2.getRepositoryManager().isRepositoryExists();
        boolean upstreamSet = false;
        try {
            ValidationInfo validationInfo = this.saveRemoteRepositoryUrl();
            if (validationInfo != null) {
                ValidationInfo validationInfo2;
                ValidationInfo it = validationInfo2 = validationInfo;
                if (isRepositoryWillBeCreated) {
                    icsManager2.getRepositoryManager().deleteRepository();
                }
                return CollectionsKt.listOf((Object)it);
            }
            upstreamSet = true;
            if (isRepositoryWillBeCreated) {
                icsManager2.setApplicationLevelStreamProvider();
            }
            if (isRepositoryWillBeCreated && this.syncType != SyncType.OVERWRITE_LOCAL) {
                ApplicationManager.getApplication().saveSettings();
                icsManager2.sync(this.syncType, this.project, (Function0<Unit>)((Function0)doSync.2.INSTANCE));
            } else {
                icsManager2.sync(this.syncType, this.project, null);
            }
        }
        catch (Throwable e) {
            if (isRepositoryWillBeCreated) {
                icsManager2.getRepositoryManager().deleteRepository();
            }
            IcsManagerKt.getLOG().warn(e);
            if (!upstreamSet || e instanceof NoRemoteRepositoryException) {
                return CollectionsKt.listOf((Object)this.createError(IcsBundleKt.icsMessage("set.upstream.failed.message", e.getMessage())));
            }
            String string = e.getMessage();
            if (string == null) {
                string = "Internal error";
            }
            return CollectionsKt.listOf((Object)this.createError(string));
        }
        SyncActionKt.getNOTIFICATION_GROUP().createNotification(IcsBundleKt.icsMessage("sync.done.message", new Object[0]), NotificationType.INFORMATION).notify(this.project);
        return CollectionsKt.emptyList();
    }

    public SyncAction(@NotNull SyncType syncType, @NotNull JTextField urlTextField, @Nullable Project project, @NotNull DialogManager dialogManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncType), (String)"syncType");
        Intrinsics.checkParameterIsNotNull((Object)urlTextField, (String)"urlTextField");
        Intrinsics.checkParameterIsNotNull((Object)dialogManager, (String)"dialogManager");
        super(IcsBundleKt.icsMessage("action." + syncType.getMessageKey() + "Settings.text", new Object[0]));
        this.syncType = syncType;
        this.urlTextField = urlTextField;
        this.project = project;
        this.dialogManager = dialogManager;
    }

    @Nullable
    public static final /* synthetic */ List access$doSync(SyncAction $this) {
        return $this.doSync();
    }
}

