/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitLogBranchOperationsActionGroup
extends ActionGroup
implements DumbAware {
    private static final int MAX_BRANCH_GROUPS = 2;
    private static final int MAX_TAG_GROUPS = 1;

    public GitLogBranchOperationsActionGroup() {
        this.setPopup(false);
    }

    public boolean hideIfNoVisibleChildren() {
        return true;
    }

    @NotNull
    public AnAction[] getChildren(AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(0);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        List refs = (List)e.getData(VcsLogDataKeys.VCS_LOG_REFS);
        if (project == null || log == null || logUI == null || refs == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List commits2 = log.getSelectedCommits();
        if (commits2.size() != 1) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        CommitId commit2 = (CommitId)commits2.get(0);
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        GitRepository root = (GitRepository)repositoryManager.getRepositoryForRoot(commit2.getRoot());
        if (root == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List branchRefs = ContainerUtil.filter((Collection)refs, ref -> {
            if (ref.getType() == GitRefManager.LOCAL_BRANCH) {
                return !ref.getName().equals(root.getCurrentBranchName());
            }
            return ref.getType() == GitRefManager.REMOTE_BRANCH;
        });
        List tagRefs = ContainerUtil.filter((Collection)refs, ref -> ref.getType() == GitRefManager.TAG);
        VcsLogProvider provider = (VcsLogProvider)logUI.getDataPack().getLogProviders().get(root.getRoot());
        if (provider != null) {
            VcsLogRefManager refManager = provider.getReferenceManager();
            Comparator comparator = refManager.getLabelsOrderComparator();
            ContainerUtil.sort((List)branchRefs, (Comparator)comparator);
            ContainerUtil.sort((List)tagRefs, (Comparator)comparator);
        }
        ArrayList<DefaultActionGroup> groups = new ArrayList<DefaultActionGroup>();
        if (!branchRefs.isEmpty()) {
            GitVcsSettings settings = GitVcsSettings.getInstance(project);
            boolean showBranchesPopup = branchRefs.size() > 2;
            List<GitRepository> allRepositories = repositoryManager.getRepositories();
            THashSet commonBranches = new THashSet(GitReference.BRANCH_NAME_HASHING_STRATEGY);
            for (GitLocalBranch gitLocalBranch : GitBranchUtil.getCommonLocalBranches((Collection<? extends GitRepository>)allRepositories)) {
                commonBranches.add(gitLocalBranch.getName());
            }
            for (GitRemoteBranch gitRemoteBranch : GitBranchUtil.getCommonRemoteBranches((Collection<? extends GitRepository>)allRepositories)) {
                commonBranches.add(gitRemoteBranch.getName());
            }
            ArrayList<AnAction> branchActionGroups = new ArrayList<AnAction>();
            for (VcsRef ref2 : branchRefs) {
                branchActionGroups.add(GitLogBranchOperationsActionGroup.createBranchGroup(project, ref2, root, allRepositories, (Set<String>)commonBranches, settings, showBranchesPopup));
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup("Branches", branchActionGroups);
            defaultActionGroup.setPopup(showBranchesPopup);
            groups.add(defaultActionGroup);
        }
        if (!tagRefs.isEmpty()) {
            boolean showTagsPopup = tagRefs.size() > 1;
            ArrayList<AnAction> tagActionGroups = new ArrayList<AnAction>();
            for (VcsRef ref3 : tagRefs) {
                tagActionGroups.add(GitLogBranchOperationsActionGroup.createTagGroup(project, ref3, root, showTagsPopup));
            }
            DefaultActionGroup tagsGroup = new DefaultActionGroup("Tags", tagActionGroups);
            tagsGroup.setPopup(showTagsPopup);
            groups.add(tagsGroup);
        }
        AnAction[] anActionArray = groups.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    @NotNull
    private static AnAction createBranchGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, @NotNull List<GitRepository> allRepositories, @NotNull Set<String> commonBranches, @NotNull GitVcsSettings settings, boolean showBranchesPopup) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(5);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(6);
        }
        if (repository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(7);
        }
        if (allRepositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(8);
        }
        if (commonBranches == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(10);
        }
        boolean isSyncBranch = settings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC && allRepositories.size() > 1 && commonBranches.contains(ref.getName());
        boolean isLocal = ref.getType() == GitRefManager.LOCAL_BRANCH;
        ArrayList<Object> actions = new ArrayList<Object>(3);
        if (isSyncBranch) {
            ActionGroup allReposActions = GitLogBranchOperationsActionGroup.createBranchActions(project, allRepositories, ref, repository, isLocal);
            allReposActions.getTemplatePresentation().setText("In All Repositories");
            allReposActions.setPopup(true);
            actions.add(allReposActions);
            actions.add(Separator.getInstance());
        }
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createBranchActions(project, Collections.singletonList(repository), ref, repository, isLocal);
        singleRepoActions.setPopup(false);
        actions.add(singleRepoActions);
        String text = showBranchesPopup ? ref.getName() : "Branch '" + ref.getName() + "'";
        DefaultActionGroup group = new DefaultActionGroup(actions);
        group.getTemplatePresentation().setText(text, false);
        group.setPopup(true);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(11);
        }
        return defaultActionGroup;
    }

    @NotNull
    private static AnAction createTagGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, boolean showTagsPopup) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(12);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(13);
        }
        if (repository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(14);
        }
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createTagActions(project, Collections.singletonList(repository), ref, repository);
        singleRepoActions.setPopup(false);
        String text = showTagsPopup ? ref.getName() : "Tag '" + ref.getName() + "'";
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{singleRepoActions});
        group.getTemplatePresentation().setText(text, false);
        group.setPopup(true);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(15);
        }
        return defaultActionGroup;
    }

    @NotNull
    private static ActionGroup createBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull VcsRef ref, @NotNull GitRepository selectedRepository, boolean isLocal) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(16);
        }
        if (repositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(17);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(18);
        }
        if (selectedRepository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(19);
        }
        if (isLocal) {
            GitBranchPopupActions.LocalBranchActions localBranchActions = new GitBranchPopupActions.LocalBranchActions(project, repositories, ref.getName(), selectedRepository);
            if (localBranchActions == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(20);
            }
            return localBranchActions;
        }
        GitBranchPopupActions.RemoteBranchActions remoteBranchActions = new GitBranchPopupActions.RemoteBranchActions(project, repositories, ref.getName(), selectedRepository);
        if (remoteBranchActions == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(21);
        }
        return remoteBranchActions;
    }

    @NotNull
    private static ActionGroup createTagActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull VcsRef ref, @NotNull GitRepository selectedRepository) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(22);
        }
        if (repositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(23);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(24);
        }
        if (selectedRepository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(25);
        }
        GitBranchPopupActions.TagActions tagActions = new GitBranchPopupActions.TagActions(project, repositories, ref.getName(), selectedRepository);
        if (tagActions == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(26);
        }
        return tagActions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitLogBranchOperationsActionGroup";
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 13: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositories";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonBranches";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitLogBranchOperationsActionGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createBranchGroup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagGroup";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createBranchActions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBranchGroup";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTagGroup";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createBranchActions";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createTagActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

