/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoClient;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.info.SvnInfoHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CmdInfoClient
extends BaseSvnClient
implements InfoClient {
    private static final Logger LOG = Logger.getInstance(CmdInfoClient.class);

    private String execute(@NotNull List<String> parameters, @NotNull File path) throws SvnBindException {
        if (parameters == null) {
            CmdInfoClient.$$$reportNull$$$0(0);
        }
        if (path == null) {
            CmdInfoClient.$$$reportNull$$$0(1);
        }
        final ProcessOutput output = new ProcessOutput();
        LineCommandAdapter listener = new LineCommandAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT) {
                    output.appendStdout(line);
                }
            }
        };
        try {
            CommandExecutor command = this.execute(this.myVcs, Target.on(path), SvnCommandName.info, parameters, (LineCommandListener)listener);
            return command.getOutput();
        }
        catch (SvnBindException e) {
            String text = StringUtil.notNullize((String)e.getMessage());
            if (text.contains("W155010")) {
                return output.getStdout();
            }
            if (text.contains("is not a working copy") && StringUtil.isNotEmpty((String)output.getStdout())) {
                return output.getStdout() + "</info>";
            }
            throw e;
        }
    }

    @Nullable
    private static Info parseResult(@Nullable File base, @Nullable String result) throws SvnBindException {
        CollectInfoHandler handler = new CollectInfoHandler();
        CmdInfoClient.parseResult(handler, base, result);
        return handler.getInfo();
    }

    private static void parseResult(@NotNull InfoConsumer handler, @Nullable File base, @Nullable String result) throws SvnBindException {
        if (handler == null) {
            CmdInfoClient.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)result)) {
            return;
        }
        SvnInfoHandler infoHandler = new SvnInfoHandler(base, (Consumer<? super Info>)((Consumer)info -> {
            if (handler == null) {
                CmdInfoClient.$$$reportNull$$$0(10);
            }
            try {
                handler.consume(info);
            }
            catch (SvnBindException e) {
                throw new SvnExceptionWrapper(e);
            }
        }));
        CmdInfoClient.parseResult(result, infoHandler);
    }

    private static void parseResult(@NotNull String result, @NotNull SvnInfoHandler handler) throws SvnBindException {
        if (result == null) {
            CmdInfoClient.$$$reportNull$$$0(3);
        }
        if (handler == null) {
            CmdInfoClient.$$$reportNull$$$0(4);
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(result.trim().getBytes(CharsetToolkit.UTF8_CHARSET)), (DefaultHandler)handler);
        }
        catch (SvnExceptionWrapper e) {
            LOG.info("info output " + result);
            throw new SvnBindException(e.getCause());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.info("info output " + result);
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private static List<String> buildParameters(@NotNull Target target, @Nullable Revision revision, @Nullable Depth depth) {
        if (target == null) {
            CmdInfoClient.$$$reportNull$$$0(5);
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        CommandUtil.put((List<? super String>)parameters, depth);
        CommandUtil.put((List<? super String>)parameters, revision);
        CommandUtil.put((List<? super String>)parameters, target);
        parameters.add("--xml");
        ArrayList arrayList = parameters;
        if (arrayList == null) {
            CmdInfoClient.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    public Info doInfo(@NotNull File path, @Nullable Revision revision) throws SvnBindException {
        if (path == null) {
            CmdInfoClient.$$$reportNull$$$0(7);
        }
        File base = CommandUtil.requireExistingParent(path);
        return CmdInfoClient.parseResult(base, this.execute(CmdInfoClient.buildParameters(Target.on(path), revision, Depth.EMPTY), path));
    }

    @Override
    public Info doInfo(@NotNull Target target, @Nullable Revision revision) throws SvnBindException {
        if (target == null) {
            CmdInfoClient.$$$reportNull$$$0(8);
        }
        this.assertUrl(target);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.info, CmdInfoClient.buildParameters(target, revision, Depth.EMPTY), null);
        return CmdInfoClient.parseResult(null, command.getOutput());
    }

    @Override
    public void doInfo(@NotNull Collection<File> paths, @Nullable InfoConsumer handler) throws SvnBindException {
        File base;
        if (paths == null) {
            CmdInfoClient.$$$reportNull$$$0(9);
        }
        if ((base = (File)ContainerUtil.getFirstItem(paths)) != null) {
            base = CommandUtil.requireExistingParent(base);
            ArrayList parameters = ContainerUtil.newArrayList();
            for (File file : paths) {
                CommandUtil.put((List<? super String>)parameters, file);
            }
            parameters.add("--xml");
            String result = this.execute(parameters, base);
            if (handler != null) {
                CmdInfoClient.parseResult(handler, base, result);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/info/CmdInfoClient";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/info/CmdInfoClient";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseResult";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildParameters";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseResult$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectInfoHandler
    implements InfoConsumer {
        @Nullable
        private Info myInfo;

        private CollectInfoHandler() {
        }

        public void consume(Info info) {
            this.myInfo = info;
        }

        @Nullable
        public Info getInfo() {
            return this.myInfo;
        }
    }
}

