/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.search.LexerEditorHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class SyntaxHighlighterOverEditorHighlighter
implements SyntaxHighlighter {
    private final Lexer lexer;
    private LayeredHighlighterIterator layeredHighlighterIterator;
    private final SyntaxHighlighter highlighter;

    public SyntaxHighlighterOverEditorHighlighter(SyntaxHighlighter _highlighter, VirtualFile file, Project project) {
        if (file.getFileType() == PlainTextFileType.INSTANCE) {
            this.highlighter = new PlainSyntaxHighlighter();
            this.lexer = this.highlighter.getHighlightingLexer();
        } else {
            this.highlighter = _highlighter;
            EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file);
            this.lexer = editorHighlighter instanceof LayeredLexerEditorHighlighter ? new LexerEditorHighlighterLexer(editorHighlighter, false) : this.highlighter.getHighlightingLexer();
        }
    }

    @Override
    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = this.lexer;
        if (lexer == null) {
            SyntaxHighlighterOverEditorHighlighter.$$$reportNull$$$0(0);
        }
        return lexer;
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        SyntaxHighlighter activeSyntaxHighlighter = this.layeredHighlighterIterator != null ? this.layeredHighlighterIterator.getActiveSyntaxHighlighter() : this.highlighter;
        TextAttributesKey[] textAttributesKeyArray = activeSyntaxHighlighter.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            SyntaxHighlighterOverEditorHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    public void restart(@NotNull CharSequence text) {
        if (text == null) {
            SyntaxHighlighterOverEditorHighlighter.$$$reportNull$$$0(2);
        }
        this.lexer.start(text);
        if (this.lexer instanceof LexerEditorHighlighterLexer) {
            HighlighterIterator iterator = ((LexerEditorHighlighterLexer)this.lexer).getHighlighterIterator();
            this.layeredHighlighterIterator = iterator instanceof LayeredHighlighterIterator ? (LayeredHighlighterIterator)iterator : null;
        }
    }

    public void resetPosition(int startOffset) {
        if (this.lexer instanceof LexerEditorHighlighterLexer) {
            ((LexerEditorHighlighterLexer)this.lexer).resetPosition(startOffset);
            HighlighterIterator iterator = ((LexerEditorHighlighterLexer)this.lexer).getHighlighterIterator();
            this.layeredHighlighterIterator = iterator instanceof LayeredHighlighterIterator ? (LayeredHighlighterIterator)iterator : null;
        } else {
            CharSequence text = this.lexer.getBufferSequence();
            this.lexer.start(text, startOffset, text.length());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/SyntaxHighlighterOverEditorHighlighter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/SyntaxHighlighterOverEditorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

