/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnActionButton
extends AnAction
implements ShortcutProvider {
    private boolean myEnabled = true;
    private boolean myVisible = true;
    private ShortcutSet myShortcut;
    private JComponent myContextComponent;
    private Set<AnActionButtonUpdater> myUpdaters;

    public AnActionButton(String text) {
        super(text);
    }

    public AnActionButton(String text, String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public AnActionButton(String text, Icon icon) {
        this(text, null, icon);
    }

    public AnActionButton() {
    }

    public static AnActionButton fromAction(AnAction action) {
        Presentation presentation = action.getTemplatePresentation();
        AnActionButtonWrapper button = action instanceof CheckedActionGroup ? new CheckedAnActionButton(presentation, action) : new AnActionButtonWrapper(presentation, action);
        button.setShortcut(action.getShortcutSet());
        return button;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    @Override
    public final void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            AnActionButton.$$$reportNull$$$0(0);
        }
        boolean bl = enabled = this.isEnabled() && this.isContextComponentOk();
        if (enabled && this.myUpdaters != null) {
            for (AnActionButtonUpdater updater : this.myUpdaters) {
                if (updater.isEnabled(e)) continue;
                enabled = false;
                break;
            }
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(this.isVisible());
        if (enabled) {
            this.updateButton(e);
        }
    }

    public final void addCustomUpdater(@NotNull AnActionButtonUpdater updater) {
        if (updater == null) {
            AnActionButton.$$$reportNull$$$0(1);
        }
        if (this.myUpdaters == null) {
            this.myUpdaters = new SmartHashSet();
        }
        this.myUpdaters.add(updater);
    }

    public void updateButton(@NotNull AnActionEvent e) {
        if (e == null) {
            AnActionButton.$$$reportNull$$$0(2);
        }
        JComponent component = this.getContextComponent();
        e.getPresentation().setEnabled(component != null && component.isShowing() && component.isEnabled());
    }

    @Override
    public ShortcutSet getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(ShortcutSet shortcut) {
        this.myShortcut = shortcut;
    }

    public void setContextComponent(JComponent contextComponent) {
        this.myContextComponent = contextComponent;
    }

    public JComponent getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.getContextComponent());
        if (dataContext == null) {
            AnActionButton.$$$reportNull$$$0(3);
        }
        return dataContext;
    }

    private boolean isContextComponentOk() {
        return this.myContextComponent == null || this.myContextComponent.isVisible() && UIUtil.getParentOfType(JLayeredPane.class, (Component)this.myContextComponent) != null;
    }

    @Nullable
    public final RelativePoint getPreferredPopupPoint() {
        Container c = this.myContextComponent;
        ActionToolbar toolbar = null;
        while (!((c = c.getParent()) == null || c instanceof JComponent && (toolbar = (ActionToolbar)((JComponent)c).getClientProperty("ACTION_TOOLBAR")) != null)) {
        }
        if (toolbar instanceof JComponent) {
            for (Component comp : ((JComponent)((Object)toolbar)).getComponents()) {
                if (!(comp instanceof ActionButtonComponent) || !(comp instanceof AnActionHolder) || ((AnActionHolder)((Object)comp)).getAction() != this) continue;
                return new RelativePoint((Component)comp.getParent(), new Point(comp.getX(), comp.getY() + comp.getHeight()));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AnActionButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AnActionButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCustomUpdater";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateButton";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AnActionEventWrapper
    extends AnActionEvent {
        private final AnActionButton myPeer;

        private AnActionEventWrapper(AnActionEvent e, AnActionButton peer) {
            super(e.getInputEvent(), e.getDataContext(), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
            this.myPeer = peer;
        }

        public void showPopup(JBPopup popup) {
            popup.show(this.myPeer.getPreferredPopupPoint());
        }
    }

    public static class AnActionButtonWrapper
    extends AnActionButton {
        private final AnAction myAction;

        public AnActionButtonWrapper(Presentation presentation, AnAction action) {
            super(presentation.getText(), presentation.getDescription(), presentation.getIcon());
            this.myAction = action;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AnActionButtonWrapper.$$$reportNull$$$0(0);
            }
            this.myAction.actionPerformed(new AnActionEventWrapper(e, this));
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                AnActionButtonWrapper.$$$reportNull$$$0(1);
            }
            this.myAction.update(e);
            boolean enabled = e.getPresentation().isEnabled();
            boolean visible = e.getPresentation().isVisible();
            if (enabled && visible) {
                super.updateButton(e);
            }
        }

        @Override
        public boolean isDumbAware() {
            return this.myAction.isDumbAware();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ui/AnActionButton$AnActionButtonWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CheckedAnActionButton
    extends AnActionButtonWrapper
    implements CheckedActionGroup {
        private final AnAction myDelegate;

        public CheckedAnActionButton(Presentation presentation, AnAction action) {
            super(presentation, action);
            this.myDelegate = action;
        }

        public AnAction getDelegate() {
            return this.myDelegate;
        }
    }
}

