/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BeanConfigurable<T>
implements UnnamedConfigurable {
    private final T myInstance;
    private final List<BeanField> myFields;

    protected BeanConfigurable(@NotNull T beanInstance) {
        if (beanInstance == null) {
            BeanConfigurable.$$$reportNull$$$0(0);
        }
        this.myFields = new ArrayList<BeanField>();
        this.myInstance = beanInstance;
    }

    @NotNull
    protected T getInstance() {
        T t = this.myInstance;
        if (t == null) {
            BeanConfigurable.$$$reportNull$$$0(1);
        }
        return t;
    }

    @Deprecated
    protected void checkBox(@NonNls String fieldName, String title) {
        this.myFields.add(new CheckboxField(fieldName, title));
    }

    protected void checkBox(@NotNull String title, final @NotNull Getter<Boolean> getter, final @NotNull Setter<Boolean> setter) {
        if (title == null) {
            BeanConfigurable.$$$reportNull$$$0(2);
        }
        if (getter == null) {
            BeanConfigurable.$$$reportNull$$$0(3);
        }
        if (setter == null) {
            BeanConfigurable.$$$reportNull$$$0(4);
        }
        CheckboxField field = new CheckboxField("", title){

            @Override
            Object getBeanValue(@NotNull Object instance) {
                if (instance == null) {
                    1.$$$reportNull$$$0(0);
                }
                return getter.get();
            }

            @Override
            void setBeanValue(Object instance, Object value) {
                setter.set((Object)((Boolean)value));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/options/BeanConfigurable$1", "getBeanValue"));
            }
        };
        this.myFields.add(field);
    }

    protected <V> void component(final @NotNull JComponent component, final @NotNull Getter<? extends V> beanGetter, final @NotNull Setter<? super V> beanSetter, final @NotNull Getter<? extends V> componentGetter, final @NotNull Setter<? super V> componentSetter) {
        if (component == null) {
            BeanConfigurable.$$$reportNull$$$0(5);
        }
        if (beanGetter == null) {
            BeanConfigurable.$$$reportNull$$$0(6);
        }
        if (beanSetter == null) {
            BeanConfigurable.$$$reportNull$$$0(7);
        }
        if (componentGetter == null) {
            BeanConfigurable.$$$reportNull$$$0(8);
        }
        if (componentSetter == null) {
            BeanConfigurable.$$$reportNull$$$0(9);
        }
        BeanField<JComponent> field = new BeanField<JComponent>(""){

            @Override
            @NotNull
            JComponent createComponent() {
                JComponent jComponent = component;
                if (jComponent == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            @Override
            Object getComponentValue() {
                return componentGetter.get();
            }

            @Override
            void setComponentValue(Object value) {
                componentSetter.set(value);
            }

            @Override
            protected Class getValueClass() {
                return null;
            }

            @Override
            Object getBeanValue(@NotNull Object instance) {
                if (instance == null) {
                    2.$$$reportNull$$$0(1);
                }
                return beanGetter.get();
            }

            @Override
            void setBeanValue(Object instance, Object value) {
                beanSetter.set(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/options/BeanConfigurable$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instance";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/options/BeanConfigurable$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getBeanValue";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myFields.add(field);
    }

    @Override
    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridLayout(this.myFields.size(), 1));
        for (BeanField field : this.myFields) {
            panel.add((Component)field.getComponent());
        }
        return panel;
    }

    @Override
    public boolean isModified() {
        for (BeanField field : this.myFields) {
            if (!field.isModified(this.myInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() throws ConfigurationException {
        for (BeanField field : this.myFields) {
            field.apply(this.myInstance);
        }
    }

    @Override
    public void reset() {
        for (BeanField field : this.myFields) {
            field.reset(this.myInstance);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanInstance";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/BeanConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanGetter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanSetter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentGetter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentSetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/BeanConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkBox";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "component";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CheckboxField
    extends BeanField<JCheckBox> {
        private final String myTitle;

        private CheckboxField(String fieldName, String title) {
            super(fieldName);
            this.myTitle = title;
        }

        @Override
        @NotNull
        JCheckBox createComponent() {
            JCheckBox jCheckBox = new JCheckBox(this.myTitle);
            if (jCheckBox == null) {
                CheckboxField.$$$reportNull$$$0(0);
            }
            return jCheckBox;
        }

        @Override
        Object getComponentValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }

        @Override
        void setComponentValue(Object value) {
            ((JCheckBox)this.getComponent()).setSelected((Boolean)value);
        }

        @Override
        protected String getterName() {
            return "is" + StringUtil.capitalize((String)this.myFieldName);
        }

        @Override
        protected Class getValueClass() {
            return Boolean.TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/BeanConfigurable$CheckboxField", "createComponent"));
        }
    }

    private static abstract class BeanField<T extends JComponent> {
        String myFieldName;
        T myComponent;

        private BeanField(String fieldName) {
            this.myFieldName = fieldName;
        }

        T getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        @NotNull
        abstract T createComponent();

        boolean isModified(@NotNull Object instance) {
            Object beanValue;
            Object componentValue;
            if (instance == null) {
                BeanField.$$$reportNull$$$0(0);
            }
            return !Comparing.equal((Object)(componentValue = this.getComponentValue()), (Object)(beanValue = this.getBeanValue(instance)));
        }

        void apply(@NotNull Object instance) {
            if (instance == null) {
                BeanField.$$$reportNull$$$0(1);
            }
            this.setBeanValue(instance, this.getComponentValue());
        }

        void reset(@NotNull Object instance) {
            if (instance == null) {
                BeanField.$$$reportNull$$$0(2);
            }
            this.setComponentValue(this.getBeanValue(instance));
        }

        abstract Object getComponentValue();

        abstract void setComponentValue(Object var1);

        Object getBeanValue(@NotNull Object instance) {
            if (instance == null) {
                BeanField.$$$reportNull$$$0(3);
            }
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                return field.get(instance);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod(this.getterName(), new Class[0]);
                    return method.invoke(instance, new Object[0]);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @NonNls
        protected String getterName() {
            return "get" + StringUtil.capitalize((String)this.myFieldName);
        }

        void setBeanValue(Object instance, Object value) {
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                field.set(instance, value);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod("set" + StringUtil.capitalize((String)this.myFieldName), this.getValueClass());
                    method.invoke(instance, value);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract Class getValueClass();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "instance";
            objectArray2[1] = "com/intellij/openapi/options/BeanConfigurable$BeanField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isModified";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBeanValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

