/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.MnemonicWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.CellRendererPane;

final class MnemonicContainerListener
implements ContainerListener {
    MnemonicContainerListener() {
    }

    void addTo(Component component) {
        if (component == null || component instanceof CellRendererPane) {
            return;
        }
        if (component instanceof Container) {
            this.addTo((Container)component);
        }
        MnemonicWrapper.getWrapper(component);
    }

    void removeFrom(Component component) {
        if (component instanceof Container) {
            this.removeFrom((Container)component);
        }
    }

    @Override
    public void componentAdded(ContainerEvent event) {
        this.addTo(event.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent event) {
        this.removeFrom(event.getChild());
    }

    private void addTo(Container container) {
        if (!this.isAddedTo(container)) {
            container.addContainerListener(this);
            for (Component component : container.getComponents()) {
                this.addTo(component);
            }
        }
    }

    private void removeFrom(Container container) {
        if (this.isAddedTo(container)) {
            container.removeContainerListener(this);
            for (Component component : container.getComponents()) {
                this.removeFrom(component);
            }
        }
    }

    private boolean isAddedTo(Container container) {
        for (ContainerListener listener : container.getContainerListeners()) {
            if (listener != this) continue;
            return true;
        }
        return false;
    }
}

