/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsAdd;

import com.intellij.cvsSupport2.cvsoperations.common.CompositeOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddFileOperation;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class AddFilesOperation
extends CompositeOperation {
    private final Map<KeywordSubstitution, AddFileOperation> mySubstitutionToOperation = new HashMap<KeywordSubstitution, AddFileOperation>();
    private final Map<VirtualFile, AddFileOperation> myAlreadyProcessedParentToOperation = new HashMap<VirtualFile, AddFileOperation>();
    private int myFilesCount = -1;
    private int myMainPartSize = 0;

    public void addFile(VirtualFile file, KeywordSubstitution keywordSubstitution) {
        if (file.isDirectory()) {
            AddFileOperation op = this.getOperationForFile(file);
            op.addFile(file);
            if (!this.containsSubOperation(op)) {
                if (this.myMainPartSize == this.getSubOperationsCount()) {
                    this.addOperation(op);
                } else {
                    this.addOperation(this.myMainPartSize, op);
                }
                ++this.myMainPartSize;
            }
        } else {
            if (!this.mySubstitutionToOperation.containsKey(keywordSubstitution)) {
                AddFileOperation substitutionOperation = new AddFileOperation(keywordSubstitution);
                this.mySubstitutionToOperation.put(keywordSubstitution, substitutionOperation);
                this.addOperation(substitutionOperation);
            }
            this.mySubstitutionToOperation.get(keywordSubstitution).addFile(file);
        }
    }

    private AddFileOperation getOperationForFile(VirtualFile file) {
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return new AddFileOperation(null);
        }
        if (!this.myAlreadyProcessedParentToOperation.containsKey(parent)) {
            this.myAlreadyProcessedParentToOperation.put(parent, new AddFileOperation(null));
        }
        return this.myAlreadyProcessedParentToOperation.get(parent);
    }

    @Override
    public int getFilesToProcessCount() {
        if (this.myFilesCount == -1) {
            this.myFilesCount = this.calculateAllFilesCount();
        }
        return this.myFilesCount;
    }

    private int calculateAllFilesCount() {
        return this.getSubOperations().stream().mapToInt(cvsOperation -> ((AddFileOperation)cvsOperation).getFilesCount()).sum();
    }
}

