/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.AbstractActionFromEditGroup;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditorInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditorsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.ui.EditorsPanel;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import java.util.List;

public class ViewEditorsAction
extends AbstractActionFromEditGroup {
    private EditorsOperation myEditorsOperation;

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.getViewEditorsOperationName();
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        this.myEditorsOperation = new EditorsOperation(context.getSelectedFiles());
        return new CommandCvsHandler(CvsBundle.getViewEditorsOperationName(), this.myEditorsOperation);
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        if (successfully) {
            List<EditorInfo> editors = this.myEditorsOperation.getEditors();
            String filePath = CvsVfsUtil.getFileFor(context.getSelectedFile()).getAbsolutePath();
            Project project = context.getProject();
            if (project == null) {
                return;
            }
            if (editors.isEmpty()) {
                VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)CvsBundle.message((String)"message.error.no.editors.for.file", (Object[])new Object[]{filePath}), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
            } else {
                tabbedWindow.addTab(CvsBundle.message((String)"message.editors.for.file", (Object[])new Object[]{filePath}), new EditorsPanel(project, editors), true, true, true, true, null, "cvs.editors");
            }
        }
    }
}

